# 機能設計書 5-アナライザードライバー

## 概要

本ドキュメントは、Roslynプラットフォームにおけるアナライザードライバー (AnalyzerDriver) の機能設計について記述する。アナライザードライバーは、診断アナライザーを実行してコードの品質問題を検出するための基盤機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：アナライザードライバーは、Roslyn診断アナライザーフレームワークの中核コンポーネントである。開発者やサードパーティが作成した診断アナライザーを読み込み、コンパイル時やIDEでのリアルタイム解析時に実行することで、コードの品質問題、パターン違反、潜在的なバグを検出する。これにより、一貫したコーディング規約の適用とコード品質の向上を実現している。

**機能の利用シーン**：
- コンパイル時のアナライザー実行
- Visual Studio IDEでのリアルタイム解析
- dotnet buildでのコード解析
- CI/CDパイプラインでのコード品質チェック
- エディターでの波線表示とコード修正提案

**主要な処理内容**：
1. アナライザーアセンブリの読み込みとインスタンス化
2. CompilationEventキューからのイベント受信
3. アナライザーアクションの登録と実行
4. シンボル、構文ノード、セマンティックモデルに対する解析
5. 診断メッセージの生成とフィルタリング
6. 生成コード (Generated Code) の判定と除外
7. DiagnosticSuppressorによる診断の抑制

**関連システム・外部連携**：
- C#/VBコンパイラ
- CompilationWithAnalyzers
- AnalyzerManager
- MSBuildタスク

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | バックエンド処理のため画面は存在しない |

## 機能種別

解析エンジン / フレームワーク

## 入力仕様

### 入力パラメータ (AnalyzerDriver)

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| analyzers | ImmutableArray<DiagnosticAnalyzer> | Yes | 実行するアナライザーの配列 | 空でないこと |
| analyzerManager | AnalyzerManager | Yes | アナライザー管理インスタンス | null不可 |
| severityFilter | SeverityFilter | Yes | 重要度フィルター | Suppress/Default含まない |
| isComment | Func<SyntaxTrivia, bool> | Yes | コメント判定デリゲート | null不可 |

### CompilationWithAnalyzersOptions

| パラメータ名 | 型 | 説明 |
|-------------|-----|------|
| Options | AnalyzerOptions | アナライザーオプション |
| OnAnalyzerException | Action<Exception, DiagnosticAnalyzer, Diagnostic> | 例外ハンドラー |
| AnalyzerExceptionFilter | Func<Exception, bool> | 例外フィルター |
| ConcurrentAnalysis | bool | 並列実行の有効化 |
| LogAnalyzerExecutionTime | bool | 実行時間ログ |
| ReportSuppressedDiagnostics | bool | 抑制された診断の報告 |

### 入力データソース

- Compilationオブジェクト (構文木、参照)
- DiagnosticAnalyzerアセンブリ
- AnalyzerConfigファイル (.editorconfig)
- RuleSetファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Diagnostics | ImmutableArray<Diagnostic> | 検出された診断の配列 |
| AnalysisResult | AnalysisResult | 解析結果の詳細 |
| AnalyzerTelemetry | AnalyzerTelemetry | アナライザー実行統計 |

### 出力先

- DiagnosticQueue (診断キュー)
- CompilationWithAnalyzers.GetAnalyzerDiagnosticsAsync経由

## 処理フロー

### 処理シーケンス

```
1. AnalyzerDriver初期化
   └─ コンストラクタでアナライザー配列とオプション設定

2. 初期化タスク実行 (WhenInitializedTask)
   └─ 全アナライザーのInitializeを呼び出し
   └─ AnalyzerActionsの収集
   └─ 生成コード判定フラグの設定

3. イベント処理ループ (PrimaryTask)
   └─ CompilationEventQueueからイベント取得
   └─ ワーカータスクでイベント処理

4. イベント種別ごとの処理
   ├─ CompilationStartedEvent → コンパイル開始アクション実行
   ├─ SymbolDeclaredEvent → シンボルアクション実行
   ├─ CompilationUnitCompletedEvent → 構文木アクション実行
   └─ CompilationCompletedEvent → コンパイル完了アクション実行

5. 診断生成
   └─ アナライザーからReportDiagnostic呼び出し
   └─ 重要度フィルタリング
   └─ DiagnosticSuppressorによる抑制
   └─ DiagnosticQueueへ追加

6. 完了処理
   └─ DiagnosticQueueのComplete呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[AnalyzerDriver生成] --> B[Initialize呼び出し]
    B --> C[アナライザー初期化]
    C --> D[AnalyzerActions収集]
    D --> E[PrimaryTask開始]
    E --> F{CompilationEvent取得}
    F -->|イベントあり| G[イベント種別判定]
    F -->|キュー完了| H[DiagnosticQueue.Complete]
    G -->|CompilationStarted| I[コンパイル開始アクション]
    G -->|SymbolDeclared| J[シンボルアクション]
    G -->|CompilationUnitCompleted| K[構文木アクション]
    G -->|CompilationCompleted| L[コンパイル完了アクション]
    I --> M[診断レポート]
    J --> M
    K --> M
    L --> M
    M --> N[重要度フィルター]
    N --> O{DiagnosticSuppressor?}
    O -->|Yes| P[抑制チェック]
    O -->|No| Q[DiagnosticQueue追加]
    P --> Q
    Q --> F
    H --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 生成コード除外 | GeneratedCodeAttributeを持つコードは解析から除外可能 | GeneratedCodeAnalysisFlags設定時 |
| BR-02 | 重要度フィルタリング | 設定された重要度以下の診断は除外 | SeverityFilter設定時 |
| BR-03 | 並列実行 | ConcurrentAnalysis=trueで並列実行 | 既定で有効 |
| BR-04 | ワーカー数 | Environment.ProcessorCount個のワーカータスク | 常時 |
| BR-05 | 診断抑制 | DiagnosticSuppressorで診断を抑制可能 | Suppressor登録時 |

### GeneratedCodeAnalysisFlags

| 値 | 説明 |
|---|------|
| None | 生成コードを解析しない |
| Analyze | 生成コードを解析するが診断を報告しない |
| ReportDiagnostics | 生成コードの診断も報告する |
| Default | Analyze + ReportDiagnostics |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AD0001 | アナライザー例外 | アナライザー実行時例外 | OnAnalyzerExceptionで処理 |
| - | 読み込み失敗 | アセンブリ読み込みエラー | AnalyzerLoadFailureEventArgs発行 |
| - | タイムアウト | アナライザー実行タイムアウト | キャンセル処理 |

### リトライ仕様

リトライ処理は存在しない。アナライザー例外時はOnAnalyzerExceptionハンドラーで処理。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- ConcurrentAnalysisによる並列アナライザー実行
- AsyncQueueによる非同期イベント処理
- キャッシュによるSemanticModel再利用
- 生成コードの遅延判定

## セキュリティ考慮事項

- アナライザーアセンブリは信頼された場所からのみ読み込み
- アナライザー実行時の例外キャッチと隔離

## 備考

- AnalyzerDriverはabstractクラス、言語固有の派生クラスが存在
- CompilationWithAnalyzersはAnalyzerDriverのラッパー
- DiagnosticSuppressorは診断を抑制する特殊なアナライザー

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アナライザーフレームワークのコアデータ構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DiagnosticAnalyzer.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticAnalyzer.cs` | アナライザー基底クラス |
| 1-2 | DiagnosticAnalyzerAction.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticAnalyzerAction.cs` | アナライザーアクション定義 |
| 1-3 | CompilationEvent.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/CompilationEvent.cs` | コンパイルイベント基底クラス |

**読解のコツ**: DiagnosticAnalyzerはInitializeメソッドでアクションを登録する。アクションは特定のイベント (シンボル宣言、構文ノード等) に対して実行される。

#### Step 2: AnalyzerDriverを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AnalyzerDriver.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerDriver.cs` | メインドライバークラス |

**主要処理フロー**:
1. **28行目**: AnalyzerDriverクラス定義、IDisposable実装
2. **67-68行目**: Analyzers, AnalyzerManagerプロパティ
3. **154行目**: DefaultGeneratedCodeAnalysisFlags定義
4. **337行目**: ワーカータスク数 = Environment.ProcessorCount
5. **344-365行目**: CompilationEventQueue, DiagnosticQueueプロパティ
6. **374-387行目**: コンストラクタでの初期化

#### Step 3: CompilationWithAnalyzersを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CompilationWithAnalyzers.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/CompilationWithAnalyzers.cs` | 公開API |

**主要処理フロー**:
- Compilationとアナライザーを組み合わせて解析実行
- GetAnalyzerDiagnosticsAsync: 非同期で診断取得
- GetAllDiagnosticsAsync: 全診断取得

#### Step 4: 関連コンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AnalyzerManager.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerManager.cs` | アナライザー管理 |
| 4-2 | AnalyzerExecutor.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerExecutor.cs` | アナライザー実行 |
| 4-3 | DiagnosticQueue.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticQueue.cs` | 診断キュー |
| 4-4 | DiagnosticSuppressor.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticSuppressor.cs` | 診断抑制機能 |

### プログラム呼び出し階層図

```
CompilationWithAnalyzers
    │
    ├─ AnalyzerDriver.Create
    │      │
    │      └─ CSharpAnalyzerDriver / VisualBasicAnalyzerDriver
    │
    ├─ AnalyzerDriver.Initialize
    │      │
    │      ├─ AnalyzerManager.GetAnalyzerActions
    │      │      │
    │      │      └─ DiagnosticAnalyzer.Initialize
    │      │
    │      └─ AnalyzerActions収集
    │
    └─ AnalyzerDriver.GetDiagnosticsAsync
           │
           ├─ PrimaryTask
           │      │
           │      ├─ CompilationEventQueue.DequeueAsync
           │      │
           │      └─ ProcessCompilationEvent
           │             │
           │             ├─ ProcessSymbolDeclared
           │             │
           │             ├─ ProcessCompilationUnitCompleted
           │             │
           │             └─ ProcessCompilationCompleted
           │
           ├─ AnalyzerExecutor.ExecuteActions
           │      │
           │      └─ DiagnosticAnalyzer callbacks
           │
           └─ DiagnosticQueue
                  │
                  └─ 診断結果
```

### データフロー図

```
[入力]                           [処理]                            [出力]

Compilation              ──▶  CompilationWithAnalyzers     ──▶  診断リスト
        │                              │
        ▼                              ▼
DiagnosticAnalyzer[]     ──▶  AnalyzerDriver              ──▶  DiagnosticQueue
        │                              │
        ▼                              ▼
AnalyzerOptions          ──▶  AnalyzerExecutor            ──▶  アナライザー実行
        │                              │
        ▼                              ▼
                              CompilationEventQueue
                                       │
                    ┌──────────────────┼──────────────────┐
                    ▼                  ▼                  ▼
            CompilationStarted   SymbolDeclared    CompilationCompleted
                    │                  │                  │
                    └──────────────────┼──────────────────┘
                                       ▼
                              アナライザーアクション実行
                                       │
                                       ▼
                              ReportDiagnostic
                                       │
                    ┌──────────────────┼──────────────────┐
                    ▼                  ▼                  ▼
            SeverityFilter     DiagnosticSuppressor   DiagnosticQueue
                                                            │
                                                            ▼
                                                     ImmutableArray<Diagnostic>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnalyzerDriver.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerDriver.cs` | ソース | メインドライバー |
| CompilationWithAnalyzers.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/CompilationWithAnalyzers.cs` | ソース | 公開API |
| AnalyzerManager.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerManager.cs` | ソース | アナライザー管理 |
| AnalyzerExecutor.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerExecutor.cs` | ソース | アナライザー実行 |
| DiagnosticAnalyzer.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticAnalyzer.cs` | ソース | アナライザー基底クラス |
| DiagnosticSuppressor.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticSuppressor.cs` | ソース | 診断抑制 |
| DiagnosticQueue.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/DiagnosticQueue.cs` | ソース | 診断キュー |
| CompilationEvent.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/CompilationEvent.cs` | ソース | イベント基底クラス |
| AnalyzerFileReference.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerFileReference.cs` | ソース | アナライザー参照 |
| AnalyzerAssemblyLoader.cs | `src/Compilers/Core/Portable/DiagnosticAnalyzer/AnalyzerAssemblyLoader.cs` | ソース | アセンブリ読み込み |
