# 機能設計書 6-拡張機能

## 概要

本ドキュメントは、Roslynプラットフォームにおける拡張機能 (CodeFix/CodeRefactoring) の機能設計について記述する。拡張機能は、コード修正 (CodeFix) とコードリファクタリング (CodeRefactoring) を提供するための基盤フレームワークである。

### 本機能の処理概要

**業務上の目的・背景**：拡張機能フレームワークは、IDEやエディターにおけるコード品質改善機能を提供する。CodeFixは診断メッセージに対する自動修正を提供し、CodeRefactoringはカーソル位置のコードに対するリファクタリング操作を提供する。これにより、開発者は一貫したコーディングスタイルの維持、一般的なエラーの自動修正、コードの構造改善を効率的に行うことができる。

**機能の利用シーン**：
- Visual Studioの電球メニュー (Light Bulb) からのコード修正
- Visual Studio Codeのクイックフィックス
- エラー/警告の自動修正
- 名前の変更、型の移動などのリファクタリング操作
- using文の自動追加
- コードスタイルの適用

**主要な処理内容**：
1. CodeFixProvider/CodeRefactoringProviderの読み込みと管理
2. 診断ID/カーソル位置に基づくプロバイダーの特定
3. CodeActionの生成と表示
4. コード変更の適用
5. FixAllプロバイダーによる一括修正
6. 設定に基づく抑制処理

**関連システム・外部連携**：
- アナライザードライバー (診断の取得)
- ワークスペース (コード変更の適用)
- Visual Studio IDE
- Visual Studio Code

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | バックエンドサービスのため直接的な画面は存在しない |

## 機能種別

フレームワーク / 拡張ポイント

## 入力仕様

### CodeFixService入力

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | null不可 |
| range | TextSpan | Yes | 対象範囲 | 有効な範囲 |
| priority | CodeActionRequestPriority | No | 優先度フィルター | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### CodeRefactoringService入力

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | TextDocument | Yes | 対象ドキュメント | null不可 |
| range | TextSpan | Yes | 選択範囲 | 有効な範囲 |
| priority | CodeActionRequestPriority | No | 優先度フィルター | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- Workspace/Solution/Project/Document
- DiagnosticAnalyzerからの診断情報
- MEFによるCodeFixProvider/CodeRefactoringProviderの読み込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CodeFixCollection | CodeFixCollection | 適用可能な修正の集合 |
| CodeRefactoring | CodeRefactoring | 適用可能なリファクタリングの集合 |
| CodeAction | CodeAction | 個別のコードアクション |

### 出力先

- IDE UI (電球メニュー、クイックアクション)
- Workspaceへのコード変更適用

## 処理フロー

### CodeFix処理シーケンス

```
1. GetMostSevereFixAsync / GetFixesAsync呼び出し
   └─ CodeFixServiceが診断を取得

2. 診断IDに対するプロバイダー特定
   ├─ ワークスペースフィクサー検索
   └─ プロジェクトフィクサー検索

3. 各CodeFixProviderのRegisterCodeFixesAsync呼び出し
   └─ CodeFixContextで修正を登録

4. CodeFixCollectionの生成
   └─ 適用可能な修正をまとめて返却

5. ユーザー選択後、CodeActionの適用
   └─ Workspaceへの変更適用
```

### CodeRefactoring処理シーケンス

```
1. GetRefactoringsAsync呼び出し
   └─ CodeRefactoringServiceがプロバイダーを取得

2. ドキュメント種別・言語に基づくプロバイダー特定
   └─ LanguageDocumentToProvidersMapから検索

3. 各CodeRefactoringProviderのComputeRefactoringsAsync呼び出し
   └─ CodeRefactoringContextでリファクタリングを登録

4. CodeRefactoringリストの生成
   └─ 適用可能なリファクタリングをまとめて返却

5. ユーザー選択後、CodeActionの適用
   └─ Workspaceへの変更適用
```

### フローチャート

```mermaid
flowchart TD
    A[コードに問題検出/カーソル位置] --> B{CodeFix or Refactoring?}
    B -->|CodeFix| C[CodeFixService.GetFixesAsync]
    B -->|Refactoring| D[CodeRefactoringService.GetRefactoringsAsync]
    C --> E[診断IDでプロバイダー検索]
    D --> F[言語/ドキュメント種別でプロバイダー検索]
    E --> G[CodeFixProvider.RegisterCodeFixesAsync]
    F --> H[CodeRefactoringProvider.ComputeRefactoringsAsync]
    G --> I[CodeAction生成]
    H --> I
    I --> J[IDEに表示]
    J --> K{ユーザー選択?}
    K -->|Yes| L[CodeAction.GetOperationsAsync]
    K -->|No| M[終了]
    L --> N[ApplyChangesOperation実行]
    N --> O[Workspace変更適用]
    O --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | MEFによる読み込み | CodeFixProvider/CodeRefactoringProviderはMEFで読み込み | 起動時 |
| BR-02 | 言語フィルタリング | プロバイダーは対象言語でフィルタリング | 常時 |
| BR-03 | 優先度順序付け | ExtensionOrderer.Orderで順序付け | 常時 |
| BR-04 | 抑制済み診断除外 | IsSuppressed=trueの診断は除外 | CodeFix時 |
| BR-05 | FixAll対応 | FixAllProviderで一括修正可能 | FixAll実行時 |

### CodeActionRequestPriority

| 値 | 説明 |
|---|------|
| High | 高優先度 (コンパイラアナライザーのみ) |
| Default | 通常優先度 |
| Low | 低優先度 |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | プロバイダー例外 | CodeFixProvider実行時例外 | IErrorLoggerServiceで記録 |
| - | 変更適用失敗 | Workspace変更失敗 | ユーザー通知 |
| - | キャンセル | 処理中断 | OperationCanceledException |

### リトライ仕様

リトライ処理は存在しない。

## トランザクション仕様

トランザクション処理は存在しない。コード変更はWorkspaceを通じて原子的に適用。

## パフォーマンス要件

- 遅延初期化 (Lazy) によるプロバイダー読み込み
- ConditionalWeakTableによるキャッシュ
- 優先度ベースのフィルタリングで不要な処理をスキップ

## セキュリティ考慮事項

- コード変更はユーザー確認後に適用
- サードパーティプロバイダーは信頼された場所からのみ読み込み

## 備考

- CodeFixProviderはDiagnosticAnalyzerの診断に対して動作
- CodeRefactoringProviderはカーソル位置/選択範囲に対して動作
- FixAllプロバイダーでドキュメント/プロジェクト/ソリューション全体の一括修正が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

拡張機能の公開APIから理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ICodeFixService.cs | `src/Features/Core/Portable/CodeFixes/Service/ICodeFixService.cs` | CodeFixサービスインターフェース |
| 1-2 | ICodeRefactoringService.cs | `src/Features/Core/Portable/CodeRefactorings/ICodeRefactoringService.cs` | リファクタリングサービスインターフェース |

**読解のコツ**: これらのインターフェースはIDEから呼び出されるエントリーポイント。GetFixesAsync/GetRefactoringsAsyncメソッドを確認する。

#### Step 2: CodeFixServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeFixService.cs | `src/Features/Core/Portable/CodeFixes/Service/CodeFixService.cs` | メインサービス実装 |

**主要処理フロー**:
1. **39-40行目**: ICodeFixServiceを実装、MEF Export
2. **42-43行目**: CodeFixProviderのLazy配列を保持
3. **45行目**: プロジェクト固有フィクサーのキャッシュ (ConditionalWeakTable)
4. **58-71行目**: コンストラクタでMEF Importされたプロバイダーを受け取り
5. **93-148行目**: GetMostSevereFixAsync - 重要度順の修正取得

#### Step 3: CodeRefactoringServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeRefactoringService.cs | `src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs` | リファクタリングサービス実装 |

**主要処理フロー**:
- **27-31行目**: ICodeRefactoringServiceを実装、MEF Export
- **33-39行目**: 言語/ドキュメント種別/拡張子によるプロバイダーマップ
- **45-72行目**: DistributeLanguagesAndDocuments - プロバイダーの分類
- **80-100行目**: GetProviders - ドキュメントに対するプロバイダー取得

#### Step 4: CodeActionを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CodeAction.cs | `src/Workspaces/Core/Portable/CodeActions/CodeAction.cs` | コードアクション基底クラス |
| 4-2 | CodeFixCollection.cs | `src/Features/Core/Portable/CodeFixes/CodeFixCollection.cs` | 修正コレクション |

### プログラム呼び出し階層図

```
IDE (Visual Studio / VS Code)
    │
    ├─ [CodeFix]
    │   └─ ICodeFixService.GetFixesAsync
    │          │
    │          └─ CodeFixService
    │                 │
    │                 ├─ IDiagnosticAnalyzerService.GetDiagnosticsForSpanAsync
    │                 │      │
    │                 │      └─ 診断リスト取得
    │                 │
    │                 ├─ GetProjectFixers / GetWorkspaceFixers
    │                 │      │
    │                 │      └─ DiagnosticId → CodeFixProvider[]
    │                 │
    │                 └─ CodeFixProvider.RegisterCodeFixesAsync
    │                        │
    │                        └─ CodeAction登録
    │
    └─ [CodeRefactoring]
        └─ ICodeRefactoringService.GetRefactoringsAsync
               │
               └─ CodeRefactoringService
                      │
                      ├─ GetProviders (言語/ドキュメント種別)
                      │      │
                      │      └─ CodeRefactoringProvider[]
                      │
                      └─ CodeRefactoringProvider.ComputeRefactoringsAsync
                             │
                             └─ CodeAction登録
                                    │
                                    ▼
                             ユーザー選択
                                    │
                                    ▼
                             CodeAction.GetOperationsAsync
                                    │
                                    ▼
                             ApplyChangesOperation
                                    │
                                    ▼
                             Workspace.TryApplyChanges
```

### データフロー図

```
[入力]                           [処理]                           [出力]

Diagnostic[]              ──▶  CodeFixService              ──▶  CodeFixCollection
        │                              │
        ▼                              ▼
診断ID                    ──▶  プロバイダー検索            ──▶  CodeFixProvider[]
        │                              │
        ▼                              ▼
TextDocument              ──▶  RegisterCodeFixesAsync      ──▶  CodeAction[]
        │                              │
        ▼                              ▼
                                  ユーザー選択
                                       │
                                       ▼
                                  GetOperationsAsync
                                       │
                                       ▼
                              ApplyChangesOperation
                                       │
                                       ▼
                              変更後Solution

[CodeRefactoring]

TextDocument              ──▶  CodeRefactoringService      ──▶  CodeRefactoring[]
        │                              │
        ▼                              ▼
言語 + DocKind            ──▶  プロバイダー検索            ──▶  CodeRefactoringProvider[]
        │                              │
        ▼                              ▼
カーソル位置/選択範囲     ──▶  ComputeRefactoringsAsync    ──▶  CodeAction[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeFixService.cs | `src/Features/Core/Portable/CodeFixes/Service/CodeFixService.cs` | ソース | CodeFixサービス |
| ICodeFixService.cs | `src/Features/Core/Portable/CodeFixes/Service/ICodeFixService.cs` | ソース | サービスインターフェース |
| CodeRefactoringService.cs | `src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs` | ソース | リファクタリングサービス |
| ICodeRefactoringService.cs | `src/Features/Core/Portable/CodeRefactorings/ICodeRefactoringService.cs` | ソース | サービスインターフェース |
| CodeFixCollection.cs | `src/Features/Core/Portable/CodeFixes/CodeFixCollection.cs` | ソース | 修正コレクション |
| CodeRefactoring.cs | `src/Features/Core/Portable/CodeRefactorings/CodeRefactoring.cs` | ソース | リファクタリングデータ |
| CodeAction.cs | `src/Workspaces/Core/Portable/CodeActions/CodeAction.cs` | ソース | アクション基底クラス |
| AbstractSuppressionCodeFixProvider.cs | `src/Features/Core/Portable/CodeFixes/Suppression/AbstractSuppressionCodeFixProvider.cs` | ソース | 抑制CodeFix |
