# 機能設計書 62-パッケージ追加

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「パッケージ追加（AddPackage）」機能の設計を記述する。この機能は、コンパイラエラーに対してNuGetパッケージのインストールを提案するコードフィックス機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：.NET開発において、必要なアセンブリが見つからないエラー（CS0012等）が発生した際に、開発者が手動でNuGetパッケージを検索してインストールする作業は煩雑である。本機能は、不足しているアセンブリを含むNuGetパッケージを自動的に検索し、ワンクリックでプロジェクトに追加できる機能を提供することで、開発生産性を向上させる。

**機能の利用シーン**：コード編集中に参照が見つからないエラーが発生した場合、ライトバルブ（電球アイコン）またはCtrl+.キーボードショートカットで呼び出される。例えば「Newtonsoft.Json.JsonConvert」を使用しようとしてエラーが出た際に、「Newtonsoft.Json」パッケージのインストールを提案する。

**主要な処理内容**：
1. 診断情報から不足しているアセンブリ名を抽出
2. ISymbolSearchServiceを使用してNuGetパッケージソースを検索
3. 一致するパッケージを見つけた場合、インストールアクションを生成
4. パッケージマネージャー経由またはプロジェクトファイル直接編集でパッケージを追加

**関連システム・外部連携**：NuGetパッケージ検索サービス（ISymbolSearchService）、パッケージインストーラーサービス（IPackageInstallerService）、NuGetパッケージソース（nuget.org等）と連携する。

**権限による制御**：NuGetパッケージ検索機能はオプションで有効/無効を切り替え可能。プレリリース版パッケージの表示は派生クラスでオーバーライド可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ（ライトバルブ） | 主画面 | パッケージ追加候補の表示と選択 |

## 機能種別

コード修正（CodeFix）/ パッケージ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| context | CodeFixContext | Yes | コードフィックスコンテキスト | - |
| assemblyNames | ISet&lt;string&gt; | Yes | 検索対象のアセンブリ名セット | 空でないこと |

### 入力データソース

- コンパイラ診断情報（参照不足エラー）
- NuGetパッケージソース（nuget.org等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CodeAction | ImmutableArray&lt;CodeAction&gt; | パッケージインストールアクション |
| PackageName | string | インストール対象パッケージ名 |
| PackageSource | string | パッケージソース名 |

### 出力先

エディタ上のライトバルブメニュー（コードアクションとして表示）

## 処理フロー

### 処理シーケンス

```
1. GetAddPackagesCodeActionsAsync呼び出し
   └─ CodeFixContextとアセンブリ名セットを受け取る
2. サービス取得
   └─ ISymbolSearchService, IPackageInstallerServiceを取得
3. パッケージソースごとに検索
   └─ FindMatchingPackagesAsyncで一致するパッケージを検索
4. CodeAction生成
   └─ InstallPackageParentCodeActionを作成
```

### フローチャート

```mermaid
flowchart TD
    A[診断情報受け取り] --> B{パッケージ検索有効?}
    B -->|No| C[空の結果を返す]
    B -->|Yes| D{インストーラー利用可能?}
    D -->|No| C
    D -->|Yes| E[パッケージソース取得]
    E --> F[各ソースで検索]
    F --> G[一致パッケージ収集]
    G --> H[ランク順にソート]
    H --> I[CodeAction生成]
    I --> J[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | パッケージランキング | 検索結果はパッケージのランクでソートされる | 常時 |
| BR-62-02 | プレリリース制御 | プレリリース版の表示は派生クラスで制御 | 派生クラスでオーバーライド時 |
| BR-62-03 | サービス依存 | ISymbolSearchServiceとIPackageInstallerServiceが必須 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | サービス未取得 | ISymbolSearchService/IPackageInstallerServiceが取得できない | 空の結果を返す |
| - | 検索オプション無効 | SearchNuGetPackagesがfalse | 空の結果を返す |
| - | インストーラー無効 | installerService.IsEnabled()がfalse | 空の結果を返す |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（プロジェクトファイル編集はMSBuildの機構で管理）

## パフォーマンス要件

- パッケージ検索はネットワークI/Oを伴うため、非同期処理で実装
- 複数のアセンブリ名に対して並列検索を実行

## セキュリティ考慮事項

- 信頼できるパッケージソースのみを使用することを推奨
- パッケージの署名検証はNuGetクライアントに委譲

## 備考

本機能は抽象クラス（AbstractAddPackageCodeFixProvider）として実装されており、具体的な診断IDは派生クラスで定義される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PackageWithAssemblyResult | ISymbolSearchService内 | 検索結果の構造（パッケージ名、ランク等） |

**読解のコツ**: PackageWithAssemblyResultはIComparableを実装しておりランクでソート可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractAddPackageCodeFixProvider.cs | `src/Features/Core/Portable/AddPackage/AbstractAddPackageCodeFixProvider.cs` | CodeFixProviderとしてのエントリーポイント |

**主要処理フロー**:
1. **29-70行目**: GetAddPackagesCodeActionsAsyncメソッドでパッケージ検索とアクション生成
2. **37-42行目**: サービス取得と有効性チェック
3. **44-48行目**: 検索オプションのチェック
4. **53-66行目**: 各パッケージソースでの検索とアクション生成

#### Step 3: パッケージ検索を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FindMatchingPackagesAsync | AbstractAddPackageCodeFixProvider.cs内 | パッケージ検索のロジック |

**主要処理フロー**:
- **72-93行目**: 各アセンブリ名に対してFindPackagesWithAssemblyAsyncを呼び出し
- **90行目**: 結果をランク順にソート

#### Step 4: インストールアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | InstallPackageParentCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallPackageParentCodeAction.cs` | 親アクション（バージョン選択を含む） |
| 4-2 | InstallPackageDirectlyCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallPackageDirectlyCodeAction.cs` | 直接インストールアクション |
| 4-3 | InstallWithPackageManagerCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallWithPackageManagerCodeAction.cs` | パッケージマネージャー経由アクション |

### プログラム呼び出し階層図

```
AbstractAddPackageCodeFixProvider.GetAddPackagesCodeActionsAsync
    │
    ├─ workspaceServices.GetService<ISymbolSearchService>
    ├─ workspaceServices.GetService<IPackageInstallerService>
    │
    ├─ installerService.IsEnabled(projectId)
    ├─ installerService.TryGetPackageSources()
    │
    └─ FindMatchingPackagesAsync
           │
           └─ symbolSearchService.FindPackagesWithAssemblyAsync
                  │
                  └─ PackageWithAssemblyResult[]
                         │
                         └─ InstallPackageParentCodeAction
                                │
                                ├─ InstallPackageDirectlyCodeAction
                                └─ InstallWithPackageManagerCodeAction
```

### データフロー図

```
[入力]                          [処理]                               [出力]

Diagnostic          ───▶  AbstractAddPackageCodeFixProvider
(CS0012等)                        │
                                  ▼
AssemblyNames       ───▶  FindMatchingPackagesAsync
                                  │
                                  ▼
                         ISymbolSearchService              ───▶  PackageWithAssemblyResult[]
                                  │
                                  ▼
                         InstallPackageParentCodeAction    ───▶  ライトバルブメニュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractAddPackageCodeFixProvider.cs | `src/Features/Core/Portable/AddPackage/AbstractAddPackageCodeFixProvider.cs` | ソース | 抽象基底CodeFixProvider |
| ParentInstallPackageCodeAction.cs | `src/Features/Core/Portable/AddPackage/ParentInstallPackageCodeAction.cs` | ソース | 親コードアクション |
| InstallPackageDirectlyCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallPackageDirectlyCodeAction.cs` | ソース | 直接インストールアクション |
| InstallPackageDirectlyCodeActionOperation.cs | `src/Features/Core/Portable/AddPackage/InstallPackageDirectlyCodeActionOperation.cs` | ソース | インストール操作 |
| InstallWithPackageManagerCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallWithPackageManagerCodeAction.cs` | ソース | パッケージマネージャー経由アクション |
| InstallPackageParentCodeAction.cs | `src/Features/Core/Portable/AddPackage/InstallPackageParentCodeAction.cs` | ソース | 親アクション（バージョン選択含む） |
| AbstractAddSpecificPackageCodeFixProvider.cs | `src/Features/Core/Portable/AddPackage/AbstractAddSpecificPackageCodeFixProvider.cs` | ソース | 特定パッケージ追加の基底 |
