# 機能設計書 63-不足参照の追加

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「不足参照の追加（AddMissingReference）」機能の設計を記述する。この機能は、コンパイラエラーに対して不足しているプロジェクト参照またはアセンブリ参照の追加を提案するコードフィックス機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：.NET開発において、必要なアセンブリが参照されていないエラーが発生した際に、開発者が手動で参照を追加する作業は煩雑である。本機能は、不足しているアセンブリを自動的に特定し、NuGetパッケージの追加または直接アセンブリ参照の追加を提案することで、開発生産性を向上させる。

**機能の利用シーン**：コード編集中に「型 'XXX' は参照されていないアセンブリで定義されています」のようなエラー（CS0012等）が発生した場合、ライトバルブ（電球アイコン）で呼び出される。

**主要な処理内容**：
1. 診断情報から参照されていないアセンブリのIDを抽出
2. 同じアセンブリを参照しているプロジェクトを検索し、参照追加アクションを生成
3. NuGetパッケージ検索と追加アクションも同時に生成
4. 両方のアクションをライトバルブに登録

**関連システム・外部連携**：NuGetパッケージ検索サービス（ISymbolSearchService）、パッケージインストーラーサービス（IPackageInstallerService）と連携する。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ（ライトバルブ） | 主画面 | 参照追加候補の表示と選択 |

## 機能種別

コード修正（CodeFix）/ 参照管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| context | CodeFixContext | Yes | コードフィックスコンテキスト | - |

### 入力データソース

- コンパイラ診断情報（参照不足エラー）
- 診断プロパティ（UnreferencedAssemblyIdentity）
- ソリューション内のプロジェクト参照

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| addPackageCodeActions | ImmutableArray&lt;CodeAction&gt; | パッケージ追加アクション |
| addReferenceCodeActions | ImmutableArray&lt;CodeAction&gt; | 参照追加アクション |

### 出力先

エディタ上のライトバルブメニュー（コードアクションとして表示）

## 処理フロー

### 処理シーケンス

```
1. RegisterCodeFixesAsync呼び出し
   └─ CodeFixContextを受け取る
2. GetUniqueIdentitiesAsync
   └─ 診断情報からアセンブリIDを抽出
3. 並列でアクション生成
   ├─ GetAddPackagesCodeActionsAsync（NuGetパッケージ検索）
   └─ GetAddReferencesCodeActionsAsync（参照追加アクション）
4. 両アクションを登録
```

### フローチャート

```mermaid
flowchart TD
    A[診断情報受け取り] --> B[アセンブリID抽出]
    B --> C[重複排除]
    C --> D[自プロジェクトアセンブリを除外]
    D --> E{アセンブリIDあり?}
    E -->|No| F[終了]
    E -->|Yes| G[パッケージ検索]
    E -->|Yes| H[参照追加アクション生成]
    G --> I[アクション登録]
    H --> I
    I --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-63-01 | 自己参照除外 | 自分自身のアセンブリは参照候補から除外 | 常時 |
| BR-63-02 | 重複排除 | 同じアセンブリIDは1つにまとめる | 常時 |
| BR-63-03 | プレリリース除外 | プレリリース版パッケージは提案しない | IncludePrerelease = false |
| BR-63-04 | 二重登録 | パッケージと参照の両方のアクションを登録 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アセンブリID未取得 | 診断からアセンブリIDを抽出できない | 何もしない |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- パッケージ検索と参照追加アクション生成は非同期で実行

## セキュリティ考慮事項

特になし

## 備考

FixAllProviderは現時点で未サポート（GitHub Issue #34459）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssemblyIdentity | Microsoft.CodeAnalysis.dll | アセンブリ識別情報（名前、バージョン、公開鍵等） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractAddMissingReferenceCodeFixProvider.cs | `src/Features/Core/Portable/AddMissingReference/AbstractAddMissingReferenceCodeFixProvider.cs` | CodeFixProviderエントリーポイント |

**主要処理フロー**:
1. **31-42行目**: RegisterCodeFixesAsyncでアクション登録
2. **34行目**: GetUniqueIdentitiesAsyncでアセンブリID抽出
3. **37行目**: GetAddPackagesCodeActionsAsyncでパッケージ検索
4. **38行目**: GetAddReferencesCodeActionsAsyncで参照追加アクション

#### Step 3: アセンブリID抽出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GetUniqueIdentitiesAsync | AbstractAddMissingReferenceCodeFixProvider.cs内 | アセンブリID抽出ロジック |

**主要処理フロー**:
- **57-79行目**: 診断情報からアセンブリIDを抽出
- **65行目**: compilation.GetUnreferencedAssemblyIdentitiesで取得
- **69-74行目**: 診断プロパティからも取得
- **77行目**: 自己参照を除外

#### Step 4: 参照追加アクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AddMissingReferenceCodeAction.cs | `src/Features/Core/Portable/AddMissingReference/AddMissingReferenceCodeAction.cs` | 参照追加コードアクション |

### プログラム呼び出し階層図

```
AbstractAddMissingReferenceCodeFixProvider.RegisterCodeFixesAsync
    │
    ├─ GetUniqueIdentitiesAsync
    │      │
    │      ├─ compilation.GetUnreferencedAssemblyIdentities
    │      └─ AssemblyIdentity.TryParseDisplayName
    │
    ├─ GetAddPackagesCodeActionsAsync (継承元)
    │      └─ AbstractAddPackageCodeFixProvider.GetAddPackagesCodeActionsAsync
    │
    └─ GetAddReferencesCodeActionsAsync
           └─ AddMissingReferenceCodeAction.CreateAsync
                  └─ プロジェクト参照追加
```

### データフロー図

```
[入力]                          [処理]                               [出力]

Diagnostic          ───▶  AbstractAddMissingReferenceCodeFixProvider
(CS0012等)                        │
                                  ▼
                         GetUniqueIdentitiesAsync
                                  │
                                  ▼
AssemblyIdentity[]  ◀───  compilation.GetUnreferencedAssemblyIdentities
                                  │
                    ┌─────────────┴─────────────┐
                    ▼                           ▼
           GetAddPackagesCodeActions    GetAddReferencesCodeActions
                    │                           │
                    └───────────┬───────────────┘
                                ▼
                    context.RegisterFixes    ───▶  ライトバルブメニュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractAddMissingReferenceCodeFixProvider.cs | `src/Features/Core/Portable/AddMissingReference/AbstractAddMissingReferenceCodeFixProvider.cs` | ソース | CodeFixProvider実装 |
| AddMissingReferenceCodeAction.cs | `src/Features/Core/Portable/AddMissingReference/AddMissingReferenceCodeAction.cs` | ソース | 参照追加コードアクション |
| AbstractAddPackageCodeFixProvider.cs | `src/Features/Core/Portable/AddPackage/AbstractAddPackageCodeFixProvider.cs` | ソース | 基底クラス（パッケージ追加） |
