# 機能設計書 64-型の完全修飾

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「型の完全修飾（FullyQualify）」機能の設計を記述する。この機能は、未解決の型名に対してusingディレクティブを追加する代わりに、完全修飾名（名前空間を含む完全な型名）に置き換えるコードフィックス機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：usingディレクティブを追加すると名前空間のスコープが広がり、場合によっては名前の衝突が発生する可能性がある。本機能は、型名を完全修飾名で記述することで、usingを追加せずに型を参照できる手段を提供する。特に、異なる名前空間に同名の型が存在する場合に有用である。

**機能の利用シーン**：コード編集中に未解決の型名が存在する場合、ライトバルブで「完全修飾」オプションとして表示される。例えば「List」と入力したときに「System.Collections.Generic.List」に置き換える候補を提示する。

**主要な処理内容**：
1. 未解決の識別子（SimpleNameSyntax）を検出
2. プロジェクト内で一致する型・名前空間を検索
3. 完全修飾名への置換テキスト変更を生成
4. コードクリーンアップを適用して最終的なテキスト変更を返す

**関連システム・外部連携**：リモートホスト（OOP処理）と連携可能。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ（ライトバルブ） | 主画面 | 完全修飾候補の表示と選択 |

## 機能種別

コード修正（CodeFix）/ 型名解決

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| span | TextSpan | Yes | 診断の位置 | - |

### 入力データソース

- コンパイラ診断情報（未解決の型名を示すエラー）
- ソリューション内のシンボル情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FullyQualifyFixData | FullyQualifyFixData | 修正データ（タイトルとテキスト変更） |
| Title | string | 完全修飾名（例：System.Collections.Generic.List） |
| TextChanges | ImmutableArray&lt;TextChange&gt; | ドキュメントへのテキスト変更 |

### 出力先

エディタ上のライトバルブメニュー（コードアクションとして表示）

## 処理フロー

### 処理シーケンス

```
1. GetFixDataAsync呼び出し
   └─ ドキュメントとスパンを受け取る
2. リモート/ローカル振り分け
   └─ OOP利用可能ならリモートで処理
3. シンボル検索
   ├─ 型の検索（SymbolFilter.Type）
   ├─ 属性コンテキストなら属性型も検索
   └─ 名前空間の検索（SymbolFilter.Namespace）
4. 候補のフィルタリング
   └─ アクセシビリティ、アリティ等でフィルタ
5. TextChange生成
   └─ 完全修飾名への置換を生成
```

### フローチャート

```mermaid
flowchart TD
    A[診断情報受け取り] --> B{リモートホスト利用可能?}
    B -->|Yes| C[OOPで処理]
    B -->|No| D[インプロセスで処理]
    C --> E[SimpleNameSyntax取得]
    D --> E
    E --> F{完全修飾可能?}
    F -->|No| G[nullを返す]
    F -->|Yes| H[型・名前空間検索]
    H --> I{候補あり?}
    I -->|No| G
    I -->|Yes| J[候補をフィルタ・ソート]
    J --> K[最大3件に絞る]
    K --> L[TextChange生成]
    L --> M[FullyQualifyFixData返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-64-01 | 最大結果数 | 最大3件の候補を返す | 常時 |
| BR-64-02 | 重み付け | 型 > エラーなし名前空間 > エラーあり名前空間の順 | 常時 |
| BR-64-03 | アクセシビリティ | アクセス可能な型・名前空間のみ候補とする | 常時 |
| BR-64-04 | アリティチェック | ジェネリック型の型引数数が一致すること | 常時 |
| BR-64-05 | 属性コンテキスト | 属性コンテキストでは属性型のみを候補とする | IsNameOfAttribute時 |

### 計算ロジック

重み付け:
- NamespaceWithNoErrorsWeight = 0
- TypeWeight = 1
- NamespaceWithErrorsWeight = 2

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 候補なし | 一致する型・名前空間が見つからない | nullを返す |
| - | リモート通信エラー | OOP通信失敗 | インプロセスにフォールバック |

### リトライ仕様

リモート通信失敗時はインプロセス処理にフォールバック

## トランザクション仕様

該当なし

## パフォーマンス要件

- リモートホスト利用可能時はOOPで処理して応答性を確保
- DeclarationFinderを使用して効率的にシンボル検索

## セキュリティ考慮事項

特になし

## 備考

特になし

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractFullyQualifyService.SymbolResult.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyService.SymbolResult.cs` | シンボル検索結果と重み付け |

**読解のコツ**: SymbolResultはSymbolと重み（weight）を持ち、IComparableでソート可能。

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IFullyQualifyService.cs | `src/Features/Core/Portable/FullyQualify/IFullyQualifyService.cs` | サービスインターフェース |

#### Step 3: 実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractFullyQualifyService.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyService.cs` | 実装の中核ロジック |

**主要処理フロー**:
1. **30-34行目**: 定数定義（MaxResults、各種Weight）
2. **39-57行目**: GetFixDataAsyncでリモート/ローカル振り分け
3. **59-179行目**: GetFixDataInCurrentProcessAsyncで実際の処理
4. **78-80行目**: 型・名前空間の検索
5. **119-148行目**: GetTypeSearchResultsで型候補をフィルタ
6. **151-178行目**: GetNamespaceSearchResultsで名前空間候補を生成

#### Step 4: コードアクションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractFullyQualifyCodeFixProvider.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyCodeFixProvider.cs` | CodeFixProvider実装 |

### プログラム呼び出し階層図

```
AbstractFullyQualifyCodeFixProvider.RegisterCodeFixesAsync
    │
    └─ IFullyQualifyService.GetFixDataAsync
           │
           ├─ RemoteHostClient.TryInvokeAsync (OOP)
           │      └─ IRemoteFullyQualifyService
           │
           └─ GetFixDataInCurrentProcessAsync (In-proc)
                  │
                  ├─ CanFullyQualify（抽象メソッド）
                  │
                  ├─ DeclarationFinder.FindAllDeclarationsWithNormalQueryAsync
                  │      ├─ SymbolFilter.Type
                  │      └─ SymbolFilter.Namespace
                  │
                  ├─ GetTypeSearchResults
                  │      └─ IsValidNamedTypeSearchResult
                  │
                  ├─ GetNamespaceSearchResults
                  │      └─ BindsWithoutErrors
                  │
                  └─ AddFixesAsync
                         └─ ProcessNodeAsync
                                ├─ ReplaceNodeAsync（抽象メソッド）
                                └─ CodeAction.CleanupDocumentAsync
```

### データフロー図

```
[入力]                          [処理]                               [出力]

Diagnostic          ───▶  AbstractFullyQualifyCodeFixProvider
(CS0246等)                        │
                                  ▼
                         IFullyQualifyService.GetFixDataAsync
                                  │
                                  ▼
                         DeclarationFinder          ───▶  ImmutableArray<ISymbol>
                                  │
                                  ▼
                         GetTypeSearchResults
                         GetNamespaceSearchResults  ───▶  SymbolResult[]
                                  │
                                  ▼
                         FilterAndSort              ───▶  上位3件
                                  │
                                  ▼
                         ProcessNodeAsync           ───▶  TextChange[]
                                  │
                                  ▼
                         FullyQualifyFixData        ───▶  ライトバルブメニュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IFullyQualifyService.cs | `src/Features/Core/Portable/FullyQualify/IFullyQualifyService.cs` | ソース | サービスインターフェース |
| AbstractFullyQualifyService.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyService.cs` | ソース | 実装の中核 |
| AbstractFullyQualifyService.SymbolResult.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyService.SymbolResult.cs` | ソース | シンボル検索結果 |
| AbstractFullyQualifyCodeFixProvider.cs | `src/Features/Core/Portable/FullyQualify/AbstractFullyQualifyCodeFixProvider.cs` | ソース | CodeFixProvider |
| IRemoteFullyQualifyService.cs | `src/Features/Core/Portable/FullyQualify/IRemoteFullyQualifyService.cs` | ソース | リモートサービスインターフェース |
