# 機能設計書 65-インポート整理

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「インポート整理（OrganizeImports）」機能の設計を記述する。この機能は、usingディレクティブ（C#）またはImportsステートメント（VB）のソートと不要なインポートの削除を行うコードリファクタリング機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：コードベースのusingディレクティブが乱雑になると可読性が低下し、また不要なインポートが残っているとコードの見通しが悪くなる。本機能は、インポートを整理・ソートすることでコードの品質と可読性を向上させる。

**機能の利用シーン**：usingディレクティブ上にカーソルがある状態でライトバルブを表示すると「usingの整理」オプションが表示される。プロジェクト全体またはソリューション全体に対しても適用可能。

**主要な処理内容**：
1. usingディレクティブの位置を検出
2. IOrganizeImportsServiceを呼び出してインポートを整理
3. 整理前後で変更がある場合のみコードアクションを提供
4. プロジェクト/ソリューションスコープでのリファクタリングもサポート

**関連システム・外部連携**：IOrganizeImportsService（言語固有サービス）と連携。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ（ライトバルブ） | 主画面 | インポート整理の実行 |

## 機能種別

コードリファクタリング / コード整形

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| span | TextSpan | Yes | カーソル位置 | usingディレクティブ上 |

### 入力データソース

- ドキュメントの構文ツリー
- OrganizeImportsOptions設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| newRoot | SyntaxNode | 整理後の構文ルート |

### 出力先

エディタ上のドキュメント

## 処理フロー

### 処理シーケンス

```
1. ComputeRefactoringsAsync呼び出し
   └─ ドキュメントとスパンを受け取る
2. usingディレクティブ検出
   └─ カーソル位置からusingを探す
3. RemoveImportsAsync呼び出し
   └─ IOrganizeImportsServiceでインポート整理
4. 変更チェック
   └─ oldRoot != newRootの場合のみアクション登録
5. CodeAction登録
```

### フローチャート

```mermaid
flowchart TD
    A[カーソル位置取得] --> B[トークン取得]
    B --> C[usingディレクティブを祖先から検索]
    C --> D{usingあり?}
    D -->|No| E[終了（アクションなし）]
    D -->|Yes| F[RemoveImportsAsync呼び出し]
    F --> G{変更あり?}
    G -->|No| E
    G -->|Yes| H[CodeAction登録]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | 変更時のみ表示 | 整理後に変更がある場合のみアクションを表示 | 常時 |
| BR-65-02 | 優先度Low | 他のコードアクションより低い優先度で表示 | 常時 |
| BR-65-03 | Refactor All対応 | プロジェクト/ソリューションスコープでリファクタリング可能 | 常時 |
| BR-65-04 | 構文のみクリーンアップ | セマンティクスは変更しない | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | usingなし | カーソル位置にusingがない | アクションを表示しない |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 構文のみの処理のためセマンティック解析不要で高速

## セキュリティ考慮事項

特になし

## 備考

SupportedRefactorAllScopesでプロジェクト/ソリューションスコープのリファクタリングをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OrganizeImportsCodeRefactoringProvider.cs | `src/Features/Core/Portable/OrganizeImports/OrganizeImportsCodeRefactoringProvider.cs` | リファクタリングプロバイダー |

**主要処理フロー**:
1. **22-25行目**: ExportCodeRefactoringProvider属性でC#/VB両対応
2. **27行目**: SupportedRefactorAllScopesでプロジェクト/ソリューションスコープ対応
3. **32-33行目**: ComputeRequestPriorityがLow（優先度低）
4. **39行目**: Cleanupは構文のみ（SyntaxOnly）
5. **66-93行目**: ComputeRefactoringsAsyncでリファクタリング計算

#### Step 2: インポート整理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RemoveImportsAsync | OrganizeImportsCodeRefactoringProvider.cs内 | インポート整理の呼び出し |

**主要処理フロー**:
- **41-52行目**: RemoveImportsAsyncでIOrganizeImportsServiceを呼び出し
- **44行目**: IOrganizeImportsService取得
- **47-48行目**: GetOrganizeImportsOptionsAsyncでオプション取得
- **48行目**: OrganizeImportsAsyncで整理実行

#### Step 3: Refactor All処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RefactorAllAsync | OrganizeImportsCodeRefactoringProvider.cs内 | Refactor All処理 |

**主要処理フロー**:
- **54-64行目**: RefactorAllAsyncでSyntaxEditorを使用して変更適用

### プログラム呼び出し階層図

```
OrganizeImportsCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ document.GetRequiredSyntaxRootAsync
    ├─ oldRoot.FindToken
    ├─ token.GetAncestors().FirstOrDefault(IsUsingOrExternOrImport)
    │
    └─ RemoveImportsAsync
           │
           ├─ document.GetRequiredLanguageService<IOrganizeImportsService>
           ├─ document.GetOrganizeImportsOptionsAsync
           └─ organizeImportsService.OrganizeImportsAsync
                  │
                  └─ newDocument
                         │
                         └─ context.RegisterRefactoring
                                │
                                └─ CodeAction.Create

OrganizeImportsCodeRefactoringProvider.RefactorAllAsync
    │
    └─ RemoveImportsAsync
           │
           └─ editor.ReplaceNode
```

### データフロー図

```
[入力]                          [処理]                               [出力]

TextSpan            ───▶  OrganizeImportsCodeRefactoringProvider
(カーソル位置)                    │
                                  ▼
                         FindToken/GetAncestors
                                  │
                                  ▼
usingディレクティブ  ◀───  ISyntaxFactsService.IsUsingOrExternOrImport
                                  │
                                  ▼
                         IOrganizeImportsService.OrganizeImportsAsync
                                  │
                                  ▼
                         newRoot                    ───▶  エディタに適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OrganizeImportsCodeRefactoringProvider.cs | `src/Features/Core/Portable/OrganizeImports/OrganizeImportsCodeRefactoringProvider.cs` | ソース | リファクタリングプロバイダー |
| IOrganizeImportsService.cs | Workspaces内 | ソース | インポート整理サービスインターフェース |
| OrganizeImportsOptions | Workspaces内 | ソース | オプション設定 |
