# 機能設計書 67-スペルチェック

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「スペルチェック（SpellCheck）」機能の設計を記述する。この機能は、識別子のスペルミスを検出し、類似する正しいシンボル名への修正を提案するコードフィックス機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：プログラミング中に識別子のスペルミスは頻繁に発生し、コンパイルエラーの原因となる。本機能は、未解決の識別子に対して、現在のコンテキストで利用可能な類似名称のシンボルを提案することで、開発者が素早くミスを修正できるよう支援する。

**機能の利用シーン**：コード編集中に「Sring」と入力したときに「String」への修正を提案するなど、スペルミスの識別子に対してライトバルブで修正候補を表示する。

**主要な処理内容**：
1. 未解決の識別子（SimpleNameSyntax）を検出
2. CompletionServiceで現在のコンテキストで利用可能なシンボルを取得
3. WordSimilarityCheckerで類似度を計算
4. 類似度の高い候補を最大3件提案

**関連システム・外部連携**：CompletionService（コード補完サービス）と連携。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ（ライトバルブ） | 主画面 | スペル修正候補の表示と選択 |

## 機能種別

コード修正（CodeFix）/ スペルチェック

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| context | CodeFixContext | Yes | コードフィックスコンテキスト | - |

### 入力データソース

- コンパイラ診断情報（未解決識別子）
- CompletionListからの補完候補

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CodeAction | CodeAction[] | スペル修正アクション（最大3件） |

### 出力先

エディタ上のライトバルブメニュー（コードアクションとして表示）

## 処理フロー

### 処理シーケンス

```
1. RegisterCodeFixesAsync呼び出し
   └─ 診断位置のノード/トークンを取得
2. CheckNodeAsync/CheckTokenAsync
   └─ SimpleNameSyntaxまたはトークンをチェック
3. CreateSpellCheckCodeIssueAsync
   └─ CompletionServiceで候補取得
4. CheckItemsAsync
   └─ WordSimilarityCheckerで類似度計算
5. CodeAction生成
   └─ 最大3件の修正候補を登録
```

### フローチャート

```mermaid
flowchart TD
    A[診断位置取得] --> B{ノード一致?}
    B -->|Yes| C[CheckNodeAsync]
    B -->|No| D{トークン一致?}
    D -->|Yes| E[CheckTokenAsync]
    D -->|No| F[終了]
    C --> G[SimpleNameSyntax検索]
    E --> H[トークンチェック]
    G --> I{3文字以上?}
    H --> I
    I -->|No| F
    I -->|Yes| J[CompletionService呼び出し]
    J --> K[WordSimilarityChecker]
    K --> L[類似候補ソート]
    L --> M{候補あり?}
    M -->|No| F
    M -->|Yes| N[CodeAction登録]
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | 最小文字数 | 3文字以上の識別子のみ対象 | 常時 |
| BR-67-02 | 最大候補数 | 最大3件の修正候補を提案 | 常時 |
| BR-67-03 | 優先度Low | CodeActionPriority.Lowで表示 | 常時 |
| BR-67-04 | スニペット除外 | 補完候補からスニペットを除外 | 常時 |
| BR-67-05 | 未インポート型除外 | 未インポートの型は候補に含めない | 常時 |
| BR-67-06 | ジェネリック考慮 | ジェネリック名の場合はジェネリック候補のみ | IsGeneric時 |

### 計算ロジック

類似度計算:
- WordSimilarityCheckerを使用
- substringsAreSimilar: true（部分文字列も類似とみなす）
- matchCostでソート

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 候補なし | 類似する候補が見つからない | 何も表示しない |
| - | ドキュメント変更不可 | CanApplyChangeがfalse | 何も表示しない |

### リトライ仕様

特になし

## トランザクション仕様

該当なし

## パフォーマンス要件

- CompletionServiceはスニペットと未インポート型を除外して高速化

## セキュリティ考慮事項

特になし

## 備考

FixAllProviderは未サポート（GitHub Issue #34462）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractSpellCheckCodeFixProvider.cs | `src/Features/Core/Portable/SpellCheck/AbstractSpellCheckCodeFixProvider.cs` | CodeFixProvider実装 |

**主要処理フロー**:
1. **23行目**: MinTokenLength = 3（最小文字数）
2. **25-30行目**: GetFixAllProvider returns null（FixAll未サポート）
3. **37-61行目**: RegisterCodeFixesAsyncでノード/トークンチェック
4. **63-87行目**: CheckNodeAsyncでSimpleNameSyntax処理
5. **89-102行目**: CheckTokenAsyncでトークン処理

#### Step 2: 補完候補取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CreateSpellCheckCodeIssueAsync | AbstractSpellCheckCodeFixProvider.cs内 | 補完候補取得 |

**主要処理フロー**:
- **107-143行目**: CreateSpellCheckCodeIssueAsyncでCompletionService呼び出し
- **119-126行目**: CompletionOptionsでスニペット/未インポート除外
- **130-131行目**: GetCompletionsAsyncで候補取得
- **138行目**: WordSimilarityChecker初期化

#### Step 3: 類似度計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CheckItemsAsync | AbstractSpellCheckCodeFixProvider.cs内 | 類似度計算とソート |

**主要処理フロー**:
- **145-196行目**: CheckItemsAsyncで類似候補をフィルタ・ソート
- **155-170行目**: 各候補の類似度チェック（AreSimilar）
- **172-178行目**: matchCostでソートして上位3件選択
- **180-195行目**: CodeAction作成・登録

### プログラム呼び出し階層図

```
AbstractSpellCheckCodeFixProvider.RegisterCodeFixesAsync
    │
    ├─ document.CanApplyChange
    ├─ syntaxRoot.FindNode / FindToken
    │
    ├─ CheckNodeAsync
    │      │
    │      └─ node.DescendantNodesAndSelf().OfType<TSimpleName>
    │             │
    │             ├─ ShouldSpellCheck（抽象）
    │             ├─ semanticModel.GetSymbolInfo
    │             └─ CreateSpellCheckCodeIssueAsync
    │
    └─ CheckTokenAsync
           │
           ├─ ISyntaxFactsService.IsWord
           └─ CreateSpellCheckCodeIssueAsync
                  │
                  ├─ CompletionService.GetCompletionsAsync
                  │      │
                  │      └─ CompletionOptions
                  │             ├─ SnippetsBehavior = NeverInclude
                  │             └─ ShowItemsFromUnimportedNamespaces = false
                  │
                  └─ CheckItemsAsync
                         │
                         ├─ WordSimilarityChecker.AreSimilar
                         ├─ GetInsertionTextAsync
                         └─ CreateCodeAction
```

### データフロー図

```
[入力]                          [処理]                               [出力]

Diagnostic          ───▶  AbstractSpellCheckCodeFixProvider
(未解決識別子)                    │
                                  ▼
                         SimpleNameSyntax / Token
                                  │
                                  ▼
                         CompletionService.GetCompletionsAsync
                                  │
                                  ▼
CompletionList      ◀───  (スニペット/未インポート除外)
                                  │
                                  ▼
                         WordSimilarityChecker.AreSimilar
                                  │
                                  ▼
類似候補            ◀───  matchCostでソート
                                  │
                                  ▼
                         CreateCodeAction (最大3件)   ───▶  ライトバルブメニュー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractSpellCheckCodeFixProvider.cs | `src/Features/Core/Portable/SpellCheck/AbstractSpellCheckCodeFixProvider.cs` | ソース | CodeFixProvider実装 |
| SpellCheckSpan.cs | `src/Features/Core/Portable/SpellCheck/SpellCheckSpan.cs` | ソース | スペルチェック範囲 |
| SpellCheckKind.cs | `src/Features/Core/Portable/SpellCheck/SpellCheckKind.cs` | ソース | スペルチェック種別 |
| ISpellCheckingSpanService.cs | `src/Features/Core/Portable/SpellCheck/ISpellCheckingSpanService.cs` | ソース | スパンサービスインターフェース |
| AbstractSpellCheckSpanService.cs | `src/Features/Core/Portable/SpellCheck/AbstractSpellCheckSpanService.cs` | ソース | スパンサービス実装 |
| WordSimilarityChecker | Shared/Utilities | ソース | 類似度計算ユーティリティ |
