# 機能設計書 7-ワークスペース管理

## 概要

本ドキュメントは、Roslynプラットフォームにおけるワークスペース管理の機能設計について記述する。ワークスペースは、ソースコードプロジェクトとドキュメントのアクティブなセットへのアクセスを提供する中核コンポーネントである。

### 本機能の処理概要

**業務上の目的・背景**：ワークスペースは、IDE、ビルドシステム、外部ツールがソースコードのプロジェクト構造にアクセスするための統一されたAPIを提供する。ソリューション、プロジェクト、ドキュメントの階層構造を管理し、コンパイル、解析、コード変更などの操作の基盤となる。不変性を維持しつつ、イベント通知により変更を追跡することで、効率的なインクリメンタル処理を可能としている。

**機能の利用シーン**：
- Visual Studio/VS CodeでのプロジェクトOpen
- MSBuildワークスペースによるソリューション読み込み
- アドホックワークスペースでの一時的なコンパイル
- 外部ツールからのコード解析
- コード変更の適用と伝播

**主要な処理内容**：
1. Solution/Project/Documentの階層管理
2. CurrentSolutionの不変スナップショット提供
3. TryApplyChangesによるコード変更の適用
4. WorkspaceChangedイベントによる変更通知
5. ホストサービスの提供
6. ソースジェネレーター実行の管理

**関連システム・外部連携**：
- Visual Studio IDE
- MSBuildビルドシステム
- コンパイラ (csc/vbc)
- 言語サービス

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | バックエンドサービスのため画面は存在しない |

## 機能種別

コアフレームワーク / データ管理

## 入力仕様

### Workspaceコンストラクタ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| host | HostServices | Yes | ホストサービスプロバイダー | null不可 |
| workspaceKind | string | No | ワークスペース種別識別子 | - |

### TryApplyChanges

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| solution | Solution | Yes | 適用するソリューション | null不可 |
| progress | IProgress<CodeAnalysisProgress> | No | 進捗報告 | - |

### 入力データソース

- ソリューションファイル (.sln)
- プロジェクトファイル (.csproj/.vbproj)
- ソースファイル (.cs/.vb)
- 参照アセンブリ (.dll)

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CurrentSolution | Solution | 現在のソリューションスナップショット |
| WorkspaceChanged | イベント | ワークスペース変更通知 |
| DocumentChanged | イベント | ドキュメント変更通知 |

### 出力先

- メモリ内のSolutionオブジェクト
- イベントサブスクライバーへの通知

## 処理フロー

### 処理シーケンス

```
1. Workspace初期化
   └─ コンストラクタでHostServices設定
   └─ 空のSolution生成

2. ソリューション読み込み (派生クラス)
   └─ OnSolutionAdded / OnProjectAdded / OnDocumentAdded
   └─ CurrentSolution更新

3. コード編集
   └─ Document取得
   └─ テキスト変更
   └─ 新しいSolution生成

4. 変更適用
   └─ TryApplyChanges呼び出し
   └─ 変更検出
   └─ CurrentSolution更新
   └─ WorkspaceChangedイベント発行

5. ソースジェネレーター実行
   └─ バックグラウンドで生成ソース更新
```

### フローチャート

```mermaid
flowchart TD
    A[Workspace生成] --> B[HostServices設定]
    B --> C[空Solution生成]
    C --> D{ソリューション読み込み?}
    D -->|Yes| E[派生クラスで読み込み]
    D -->|No| F[AdhocWorkspace使用]
    E --> G[CurrentSolution更新]
    F --> G
    G --> H{コード変更?}
    H -->|Yes| I[新Solution生成]
    H -->|No| J[CurrentSolution参照]
    I --> K[TryApplyChanges]
    K --> L{適用成功?}
    L -->|Yes| M[CurrentSolution更新]
    L -->|No| N[エラー処理]
    M --> O[WorkspaceChangedイベント]
    O --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 不変性 | Solutionは不変、変更時は新インスタンス生成 | 常時 |
| BR-02 | スナップショット | CurrentSolutionは常に一貫した状態を提供 | 常時 |
| BR-03 | イベント通知 | 変更時にWorkspaceChangedイベント発行 | SetCurrentSolution時 |
| BR-04 | シリアライズ | 変更操作はシリアライズロック下で実行 | OnXXXメソッド呼び出し時 |
| BR-05 | 部分セマンティクス | PartialSemanticsEnabledで部分解析を許可 | IDE環境 |

### WorkspaceKind

| 値 | 説明 |
|---|------|
| Host | Visual Studio等のホストワークスペース |
| MSBuild | MSBuildワークスペース |
| Remote | リモートワークスペース |
| Interactive | 対話的ワークスペース |

### WorkspaceChangeKind

| 値 | 説明 |
|---|------|
| SolutionAdded | ソリューション追加 |
| SolutionRemoved | ソリューション削除 |
| ProjectAdded | プロジェクト追加 |
| ProjectRemoved | プロジェクト削除 |
| DocumentAdded | ドキュメント追加 |
| DocumentRemoved | ドキュメント削除 |
| DocumentChanged | ドキュメント変更 |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNullException | 引数エラー | null引数 | 有効な引数を指定 |
| InvalidOperationException | 操作エラー | 不正な状態での操作 | 状態確認 |
| WorkspaceDiagnostic | ワークスペース診断 | 読み込み警告/エラー | Diagnosticsプロパティでログ確認 |

### リトライ仕様

リトライ処理は存在しない。

## トランザクション仕様

トランザクション処理は存在しない。変更はCurrentSolutionの原子的な更新で実現。

## パフォーマンス要件

- 不変データ構造によるキャッシュ効率化
- インクリメンタル更新のサポート
- AsyncBatchingWorkQueueによる効率的なイベント処理

## セキュリティ考慮事項

- ファイルシステムアクセス権限の確認
- アナライザー分離読み込み

## 備考

- Workspaceはabstractクラス、MSBuildWorkspace等の派生クラスが具体的な実装を提供
- AdhocWorkspaceは簡易的な一時ワークスペースとして使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: コアデータ構造を理解する

ワークスペースの階層構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Workspace.cs | `src/Workspaces/Core/Portable/Workspace/Workspace.cs` | メインワークスペースクラス |
| 1-2 | Solution.cs | `src/Workspaces/Core/Portable/Workspace/Solution/Solution.cs` | ソリューション管理 |
| 1-3 | Project.cs | `src/Workspaces/Core/Portable/Workspace/Solution/Project.cs` | プロジェクト管理 |
| 1-4 | Document.cs | `src/Workspaces/Core/Portable/Workspace/Solution/Document.cs` | ドキュメント管理 |

**読解のコツ**: Solution → Project → Document の階層構造を理解する。全て不変オブジェクト。

#### Step 2: Workspaceクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Workspace.cs | `src/Workspaces/Core/Portable/Workspace/Workspace.cs` | メインクラス |

**主要処理フロー**:
1. **37行目**: abstractクラス、IDisposable実装
2. **48行目**: _serializationLockでミューテーション操作をシリアライズ
3. **51行目**: _stateLockでmutableフィールドを保護
4. **56行目**: _latestSolutionで現在のソリューションを保持
5. **70-104行目**: コンストラクタ、HostServices設定と初期化
6. **109行目**: Servicesプロパティ
7. **122行目**: Kindプロパティ (ワークスペース種別)
8. **154-160行目**: CurrentSolutionプロパティ

#### Step 3: 変更適用処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Workspace.cs | 後半部分 | TryApplyChanges, SetCurrentSolution |
| 3-2 | Workspace_Events.cs | `src/Workspaces/Core/Portable/Workspace/Workspace_Events.cs` | イベント定義 |

#### Step 4: 派生クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AdhocWorkspace.cs | `src/Workspaces/Core/Portable/Workspace/AdhocWorkspace.cs` | アドホックワークスペース |

### プログラム呼び出し階層図

```
Workspace (abstract)
    │
    ├─ Properties
    │   ├─ Services : HostWorkspaceServices
    │   ├─ Kind : string
    │   └─ CurrentSolution : Solution
    │
    ├─ Solution管理
    │   ├─ CreateSolution
    │   ├─ SetCurrentSolution
    │   └─ TryApplyChanges
    │
    ├─ イベント
    │   ├─ WorkspaceChanged
    │   ├─ DocumentOpened
    │   ├─ DocumentClosed
    │   └─ DocumentActiveContextChanged
    │
    └─ 派生クラス
        ├─ AdhocWorkspace
        ├─ MSBuildWorkspace
        └─ RemoteWorkspace

Solution
    │
    ├─ Projects : ImmutableArray<Project>
    │      │
    │      └─ Project
    │             │
    │             ├─ Documents : ImmutableArray<Document>
    │             │
    │             ├─ AdditionalDocuments
    │             │
    │             └─ AnalyzerConfigDocuments
    │
    └─ With* methods (不変オブジェクトの変更)
```

### データフロー図

```
[入力]                         [処理]                          [出力]

ソリューションファイル   ──▶  Workspace派生クラス        ──▶  CurrentSolution
        │                              │
        ▼                              ▼
プロジェクトファイル     ──▶  OnProjectAdded            ──▶  Project追加
        │                              │
        ▼                              ▼
ソースファイル           ──▶  OnDocumentAdded           ──▶  Document追加
        │                              │
        ▼                              ▼
コード変更               ──▶  TryApplyChanges           ──▶  新Solution
        │                              │
        ▼                              ▼
                              SetCurrentSolution
                                       │
                                       ▼
                              WorkspaceChangedイベント
                                       │
                                       ▼
                              サブスクライバー通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Workspace.cs | `src/Workspaces/Core/Portable/Workspace/Workspace.cs` | ソース | メインワークスペースクラス |
| Workspace_Events.cs | `src/Workspaces/Core/Portable/Workspace/Workspace_Events.cs` | ソース | イベント定義 |
| Workspace_Editor.cs | `src/Workspaces/Core/Portable/Workspace/Workspace_Editor.cs` | ソース | エディター統合 |
| Workspace_SourceGeneration.cs | `src/Workspaces/Core/Portable/Workspace/Workspace_SourceGeneration.cs` | ソース | ソースジェネレーター |
| AdhocWorkspace.cs | `src/Workspaces/Core/Portable/Workspace/AdhocWorkspace.cs` | ソース | アドホックワークスペース |
| WorkspaceKind.cs | `src/Workspaces/Core/Portable/Workspace/WorkspaceKind.cs` | ソース | 種別定義 |
| WorkspaceChangeKind.cs | `src/Workspaces/Core/Portable/Workspace/WorkspaceChangeKind.cs` | ソース | 変更種別 |
| WorkspaceChangeEventArgs.cs | `src/Workspaces/Core/Portable/Workspace/WorkspaceChangeEventArgs.cs` | ソース | イベント引数 |
