# 機能設計書 70-タスクリスト

## 概要

本ドキュメントは、Roslyn IDE機能の一つである「タスクリスト（TaskList）」機能の設計を記述する。この機能は、コード内のTODO、HACK、UNDONE等のコメントを収集し、Visual Studioのタスクリストウィンドウに表示する機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：開発者はコード内にTODO、HACK等のコメントを残して、後で対処すべき項目をマークすることが多い。本機能は、これらのコメントを自動的に検出してタスクリストに一覧表示することで、開発者が未完了のタスクを見落とすことなく管理できるよう支援する。

**機能の利用シーン**：Visual Studioのタスクリストウィンドウ（表示 > タスクリスト）で「コメント」を選択すると、プロジェクト内のすべてのタスクコメントが一覧表示される。

**主要な処理内容**：
1. ドキュメントの構文ツリーからトリビア（コメント）を抽出
2. コメント内容をタスクリスト記述子（TODO、HACK等）と照合
3. 一致したコメントをTaskListItemとして収集
4. タスクリストウィンドウに表示

**関連システム・外部連携**：Visual Studioタスクリストウィンドウ、リモートホスト（OOP）と連携。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | タスクリストウィンドウ | 主画面 | タスクコメントの一覧表示 |

## 機能種別

コード分析 / タスク管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| descriptors | ImmutableArray&lt;TaskListItemDescriptor&gt; | Yes | タスクリスト記述子（TODO等） | 空でないこと |

### 入力データソース

- ドキュメントの構文ツリー
- タスクリスト記述子設定（オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TaskListItem | ImmutableArray&lt;TaskListItem&gt; | タスクリストアイテム配列 |
| Priority | TaskListItemDescriptor.Priority | 優先度 |
| Message | string | タスクメッセージ |
| DocumentId | DocumentId | ドキュメントID |
| LineSpan | FileLinePositionSpan | 行位置 |

### 出力先

Visual Studioタスクリストウィンドウ

## 処理フロー

### 処理シーケンス

```
1. GetTaskListItemsAsync呼び出し
   └─ ドキュメントと記述子を受け取る
2. リモート/ローカル振り分け
   └─ OOP利用可能ならリモートで処理
3. 構文ツリー走査
   └─ DescendantTriviaでトリビア取得
4. コメント判定
   └─ PreprocessorHasComment, IsSingleLineComment, IsMultilineComment
5. タスクコメント照合
   └─ 記述子と大文字小文字無視で比較
6. TaskListItem生成
   └─ 位置情報とメッセージを含むアイテム作成
```

### フローチャート

```mermaid
flowchart TD
    A[ドキュメント取得] --> B{OOP利用可能?}
    B -->|Yes| C[リモートで処理]
    B -->|No| D[インプロセスで処理]
    C --> E[構文ツリー走査]
    D --> E
    E --> F[DescendantTrivia]
    F --> G{コメント?}
    G -->|No| H[次のトリビアへ]
    G -->|Yes| I[AppendTaskListItems]
    I --> J{記述子と一致?}
    J -->|No| H
    J -->|Yes| K[識別子文字チェック]
    K --> L{後続が識別子文字?}
    L -->|Yes| H
    L -->|No| M[TaskListItem追加]
    M --> H
    H --> N{トリビア終了?}
    N -->|No| F
    N -->|Yes| O[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-70-01 | 大文字小文字無視 | タスクトークンの比較は大文字小文字を無視 | 常時 |
| BR-70-02 | 識別子文字チェック | トークン直後が識別子文字の場合は除外（例：todobook） | 常時 |
| BR-70-03 | 複数行コメント対応 | 複数行コメントは各行を個別に処理 | IsMultilineComment時 |
| BR-70-04 | #lineリマッピング | #lineディレクティブによる行番号リマッピングを考慮 | 常時 |
| BR-70-05 | プリプロセッサ対応 | #region等のプリプロセッサコメントも対象 | PreprocessorHasComment時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 記述子なし | descriptorsが空 | 空の結果を返す |
| - | リモート通信エラー | OOP通信失敗 | インプロセスにフォールバック |

### リトライ仕様

リモート通信失敗時はインプロセス処理にフォールバック

## トランザクション仕様

該当なし

## パフォーマンス要件

- リモートホスト（OOP）での処理で応答性を確保
- SyntacticDocumentでテキストとツリーを強参照保持

## セキュリティ考慮事項

特になし

## 備考

標準のタスクトークンはTODO、HACK、UNDONE。オプションでカスタムトークンを追加可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ITaskListService | Features内 | サービスインターフェース |

#### Step 2: 実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractTaskListService.cs | `src/Features/Core/Portable/TaskList/AbstractTaskListService.cs` | 実装の中核ロジック |

**主要処理フロー**:
1. **17-21行目**: 抽象メソッド定義（言語固有のコメント判定）
2. **23-24行目**: GetNormalizedText, GetCommentStartingIndex抽象メソッド
3. **26-46行目**: GetTaskListItemsAsyncでリモート/ローカル振り分け
4. **48-75行目**: GetTaskListItemsInProcessAsyncで実際の処理

#### Step 3: コメント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppendTaskListItemsOnSingleLine | AbstractTaskListService.cs内 | 単一行コメント処理 |

**主要処理フロー**:
- **80-117行目**: AppendTaskListItemsOnSingleLineで単一行処理
- **86行目**: GetCommentStartingIndexでコメント開始位置取得
- **90行目**: GetNormalizedTextで正規化
- **94-99行目**: 大文字小文字無視で比較
- **101-106行目**: 識別子文字チェック

#### Step 4: 複数行コメント処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ProcessMultilineComment | AbstractTaskListService.cs内 | 複数行コメント処理 |

**主要処理フロー**:
- **119-160行目**: ProcessMultilineCommentで複数行処理
- **135-138行目**: 単一行の場合の処理
- **143-151行目**: 複数行の場合、各行を個別処理

### プログラム呼び出し階層図

```
ITaskListService.GetTaskListItemsAsync
    │
    ├─ RemoteHostClient.TryInvokeAsync (OOP)
    │      └─ IRemoteTaskListService
    │
    └─ GetTaskListItemsInProcessAsync (In-proc)
           │
           ├─ SyntacticDocument.CreateAsync
           │
           └─ syntaxDoc.Root.DescendantTrivia
                  │
                  ├─ ContainsComments
                  │      ├─ PreprocessorHasComment（抽象）
                  │      ├─ IsSingleLineComment（抽象）
                  │      └─ IsMultilineComment（抽象）
                  │
                  └─ AppendTaskListItems（抽象）
                         │
                         ├─ AppendTaskListItemsOnSingleLine
                         │      │
                         │      ├─ GetCommentStartingIndex（抽象）
                         │      ├─ GetNormalizedText（抽象）
                         │      ├─ StringCompare (OrdinalIgnoreCase)
                         │      ├─ IsIdentifierCharacter（抽象）
                         │      └─ TaskListItem作成
                         │
                         └─ ProcessMultilineComment
                                │
                                └─ AppendTaskListItemsOnSingleLine (各行)
```

### データフロー図

```
[入力]                          [処理]                               [出力]

Document            ───▶  AbstractTaskListService
TaskListItemDescriptor[]          │
                                  ▼
                         SyntacticDocument.CreateAsync
                                  │
                                  ▼
                         Root.DescendantTrivia
                                  │
                                  ▼
SyntaxTrivia[]      ◀───  コメント判定
                                  │
                                  ▼
                         AppendTaskListItems
                                  │
                                  ▼
                         記述子照合・識別子チェック
                                  │
                                  ▼
TaskListItem[]      ───▶  タスクリストウィンドウ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractTaskListService.cs | `src/Features/Core/Portable/TaskList/AbstractTaskListService.cs` | ソース | 抽象基底サービス |
| ITaskListService.cs | Features内 | ソース | サービスインターフェース |
| TaskListItem | Features内 | ソース | タスクリストアイテムデータ |
| TaskListItemDescriptor | Features内 | ソース | タスクリスト記述子 |
| IRemoteTaskListService | Features内 | ソース | リモートサービスインターフェース |
| CSharpTaskListService.cs | Features/CSharp内 | ソース | C#固有実装 |
| VisualBasicTaskListService.cs | Features/VisualBasic内 | ソース | VB固有実装 |
