# 機能設計書 74-コメント選択

## 概要

本ドキュメントは、Roslynのコメント選択（CommentSelection）機能の設計を記載する。この機能は、選択されたコード領域に対してコメント化（コメントアウト）およびアンコメント操作を提供し、開発者のコード編集効率を向上させる。

### 本機能の処理概要

**業務上の目的・背景**：開発作業において、コードの一時的な無効化やデバッグ目的でのコメントアウト、逆に以前コメントアウトしたコードの再有効化は頻繁に行われる操作である。コメント選択機能は、これらの操作を効率的に行うための基盤を提供する。単一行コメント（`//`や`'`）とブロックコメント（`/* */`や`<!--  -->`）の両方に対応し、言語に応じた適切なコメント記法を使用する。

**機能の利用シーン**：コードエディタで選択範囲を指定し、ショートカットキー（例：Ctrl+K, Ctrl+C でコメント化、Ctrl+K, Ctrl+U でアンコメント）を押下したときに使用される。また、エディタの「コメント」メニューやコンテキストメニューからも呼び出される。

**主要な処理内容**：
1. 言語に応じたコメント記法情報を提供
2. 単一行コメントのサポート判定
3. ブロックコメントのサポート判定
4. コメント開始・終了文字列の提供

**関連システム・外部連携**：Visual Studioエディタ、Language Server Protocol (LSP)、エディタのコマンドシステムと連携する。

**権限による制御**：特になし。全ユーザーが利用可能な標準機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | 選択範囲のコメント化・アンコメント操作 |

## 機能種別

エディタ支援機能（テキスト変換）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | GetInfo()はパラメータなし | - |

### 入力データソース

- 言語固有の設定（各言語のサービス実装から取得）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SupportsSingleLineComment | bool | 単一行コメントをサポートするか |
| SupportsBlockComment | bool | ブロックコメントをサポートするか |
| SingleLineCommentString | string | 単一行コメント開始文字列（例："//", "'"） |
| BlockCommentStartString | string | ブロックコメント開始文字列（例："/*", "<!--"） |
| BlockCommentEndString | string | ブロックコメント終了文字列（例："*/", "-->"） |

### 出力先

- CommentSelectionInfo構造体として返却
- エディタのコメント処理システム

## 処理フロー

### 処理シーケンス

```
1. サービスの取得
   └─ ICommentSelectionServiceを言語に応じて取得
2. コメント情報の取得
   └─ GetInfo()を呼び出し
3. CommentSelectionInfoの生成
   ├─ ブロックコメントサポートの場合
   │   └─ 全てのプロパティを設定
   └─ 単一行コメントのみの場合
       └─ ブロックコメント文字列は空文字
4. 結果返却
   └─ CommentSelectionInfoを返却
```

### フローチャート

```mermaid
flowchart TD
    A[GetInfo呼び出し] --> B{ブロックコメントサポート?}
    B -->|Yes| C[全プロパティ設定]
    C --> D[CommentSelectionInfo生成]
    B -->|No| E[ブロック文字列を空に設定]
    E --> D
    D --> F[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-74-1 | 単一行コメント必須 | 全ての言語で単一行コメントをサポート | 常時 |
| BR-74-2 | ブロックコメント任意 | ブロックコメントのサポートは言語依存 | 言語による |
| BR-74-3 | C#コメント記法 | C#: `//`（単一行）、`/* */`（ブロック） | C#ドキュメント |
| BR-74-4 | VBコメント記法 | VB: `'`（単一行）、ブロックなし | VBドキュメント |

### 計算ロジック

言語別コメント記法:
- C#: SingleLineCommentString = "//", BlockCommentStartString = "/*", BlockCommentEndString = "*/"
- VB: SingleLineCommentString = "'", SupportsBlockComment = false

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | - | 通常エラーは発生しない | - |

### リトライ仕様

リトライなし。

## トランザクション仕様

トランザクションなし。

## パフォーマンス要件

- 即時応答（メモリ上の静的情報のみ返却）

## セキュリティ考慮事項

特になし。ローカルの読み取り専用操作のみ。

## 備考

- C#とVisual Basicの両言語で利用可能
- 実際のコメント化/アンコメント処理はEditorFeatures層で実装
- この機能は言語固有のコメント情報を提供する基盤サービス

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コメント選択で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommentSelectionInfo.cs | `src/Features/Core/Portable/CommentSelection/CommentSelectionInfo.cs` | コメント情報を保持する構造体の定義 |

**読解のコツ**:
- **7-25行目**: `CommentSelectionInfo`構造体の定義
- **9-16行目**: コンストラクタで全プロパティを初期化
- **18-24行目**: 各プロパティの定義（SupportsSingleLineComment, SupportsBlockComment等）

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ICommentSelectionService.cs | `src/Features/Core/Portable/CommentSelection/ICommentSelectionService.cs` | サービスインターフェースの定義 |

**主要処理フロー**:
- **9-12行目**: `ICommentSelectionService`インターフェース定義
- **11行目**: `GetInfo()` - CommentSelectionInfoを取得するメソッド

#### Step 3: 抽象実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractCommentSelectionService.cs | `src/Features/Core/Portable/CommentSelection/AbstractCommentSelectionService.cs` | 共通ロジックの実装 |

**主要処理フロー**:
- **7行目**: `AbstractCommentSelectionService`抽象クラス
- **9-12行目**: 抽象プロパティ定義（BlockCommentEndString, BlockCommentStartString等）
- **14-17行目**: `GetInfo()` - ブロックコメントサポート有無に応じてCommentSelectionInfoを生成

### プログラム呼び出し階層図

```
エディタ（コメントコマンド）
    │
    └─ ICommentSelectionService.GetInfo
           │
           └─ AbstractCommentSelectionService.GetInfo
                  │
                  ├─ SupportsBlockComment チェック
                  │
                  └─ CommentSelectionInfo 生成
                         ├─ SupportsSingleLineComment = true
                         ├─ SupportsBlockComment
                         ├─ SingleLineCommentString
                         ├─ BlockCommentStartString
                         └─ BlockCommentEndString
```

### データフロー図

```
[入力]               [処理]                           [出力]

（なし）        ───▶ GetInfo()                    ───▶ CommentSelectionInfo
                      │                                  ├─ SupportsSingleLineComment
言語固有設定    ───▶  ├─ 抽象プロパティ参照               ├─ SupportsBlockComment
                      │                                  ├─ SingleLineCommentString
                      └─ CommentSelectionInfo生成        ├─ BlockCommentStartString
                                                         └─ BlockCommentEndString
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ICommentSelectionService.cs | `src/Features/Core/Portable/CommentSelection/` | インターフェース | サービスインターフェース定義 |
| AbstractCommentSelectionService.cs | `src/Features/Core/Portable/CommentSelection/` | 抽象クラス | 共通ロジック実装 |
| CommentSelectionInfo.cs | `src/Features/Core/Portable/CommentSelection/` | データ型 | コメント情報構造体 |
