# 機能設計書 75-ドキュメントコメント

## 概要

本ドキュメントは、RoslynのドキュメントコメントXMLドキュメントコメント（DocumentationComments）機能の設計を記載する。この機能は、メソッドやクラスなどのコード要素に対してXMLドキュメントコメント（`///`や`'''`）を自動生成し、コードのドキュメント化を支援する。

### 本機能の処理概要

**業務上の目的・背景**：良質なコードドキュメントはソフトウェアの保守性と可読性を大幅に向上させる。しかし、開発者がドキュメントコメントを手動で記述するのは時間がかかり、一貫性を保つのも困難である。本機能は、メソッドシグネチャからパラメータ、戻り値、例外などのドキュメントコメントテンプレートを自動生成することで、開発者の負担を軽減し、ドキュメントの品質向上に寄与する。

**機能の利用シーン**：
1. メソッドやクラスの上で`///`（C#）または`'''`（VB）と入力したとき
2. 既存のドキュメントコメント内でEnterキーを押して新しい行を追加したとき
3. コマンドパレットから「ドキュメントコメントの挿入」を実行したとき

**主要な処理内容**：
1. ドキュメントコメント文字（`/`や`'`）入力時のテンプレート生成
2. Enterキー押下時の継続コメント行生成
3. コマンド実行時のコメントスニペット挿入
4. パラメータ、戻り値、型パラメータ、例外のタグ自動生成
5. 適切なインデントの適用

**関連システム・外部連携**：Visual Studioエディタ、Language Server Protocol (LSP)、IntelliSense、QuickInfo機能と連携する。

**権限による制御**：特になし。全ユーザーが利用可能な標準機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | ドキュメントコメントの自動生成 |

## 機能種別

エディタ支援機能（コード生成・テンプレート挿入）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | ParsedDocument | Yes | 解析済みドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上、ドキュメント長以下 |
| options | DocumentationCommentOptions | Yes | オプション設定 | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ユーザーのキーボード入力（`/`、`'`、Enter）
- エディタのコマンド実行
- ドキュメントの構文木

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| SpanToReplace | TextSpan | 置換対象のテキストスパン |
| SnippetText | string | 挿入するドキュメントコメントテキスト |
| CaretOffset | int | キャレットのオフセット位置 |
| Position | int? | 元の位置 |
| MemberNode | SyntaxNode? | 対象のメンバーノード |
| IndentText | string? | インデント文字列 |

### 出力先

- エディタのテキストバッファ
- キャレット位置の更新

## 処理フロー

### 処理シーケンス

```
1. 入力タイプの判定
   ├─ 文字入力（///）の場合 → GetDocumentationCommentSnippetOnCharacterTyped
   ├─ Enterキーの場合 → GetDocumentationCommentSnippetOnEnterTyped
   └─ コマンド実行の場合 → GetDocumentationCommentSnippetOnCommandInvoke
2. 対象メンバーの検出
   └─ GetContainingMember/GetTargetMemberで対象を特定
3. ドキュメントコメントサポートの確認
   └─ SupportsDocumentationComments/HasDocumentationCommentで判定
4. スタブ行の生成
   └─ GetDocumentationCommentStubLinesでテンプレート生成
5. インデントの適用
   └─ IndentLinesで適切なインデントを追加
6. 結果の返却
   └─ DocumentationCommentSnippetとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[入力検出] --> B{入力タイプ?}
    B -->|文字入力| C[OnCharacterTyped]
    B -->|Enter| D[OnEnterTyped]
    B -->|コマンド| E[OnCommandInvoke]
    C --> F{自動生成オプション有効?}
    F -->|No| G[処理なし]
    F -->|Yes| H[対象メンバー検出]
    D --> H
    E --> H
    H --> I{有効なメンバー?}
    I -->|No| G
    I -->|Yes| J[スタブ行生成]
    J --> K[インデント適用]
    K --> L[Snippet返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-75-1 | 自動生成オプション | AutoXmlDocCommentGenerationオプションで有効/無効を制御 | 常時 |
| BR-75-2 | 単一ドキュメントコメント | 対象メンバーに既存のドキュメントコメントがない場合のみ生成 | 常時 |
| BR-75-3 | 単一行モード | GenerateSummaryTagOnSingleLineで1行形式を選択可能 | オプション有効時 |
| BR-75-4 | summaryのみモード | GenerateOnlySummaryTagでsummaryタグのみ生成 | オプション有効時 |
| BR-75-5 | 外部トリビア継続 | Enterキー時は既存のコメントスタイルを継続 | ドキュメントコメント内 |

### 計算ロジック

キャレットオフセット計算:
- 単一行モード: `<summary></summary>`内、`<summary>`タグの直後
- 複数行モード: 2行目の`///`の後、スペース1つ分

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CancellationException | ユーザーがキャンセル | 処理中断 |

### リトライ仕様

リトライなし。失敗時はnullを返却し、通常の文字入力として処理される。

## トランザクション仕様

トランザクションなし。

## パフォーマンス要件

- 文字入力からの応答時間: 50ms以内
- 構文木のキャッシュを活用

## セキュリティ考慮事項

特になし。ローカルのコード編集操作のみ。

## 備考

- C#では`///`、Visual Basicでは`'''`がドキュメントコメント文字
- 生成されるタグ: `<summary>`, `<param>`, `<typeparam>`, `<returns>`, `<exception>`
- フォーマット処理はIDocumentationCommentFormattingServiceで提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ドキュメントコメント機能で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DocumentationCommentSnippet.cs | `src/Features/Core/Portable/DocumentationComments/DocumentationCommentSnippet.cs` | スニペット情報を保持するクラス |
| 1-2 | DocumentationCommentOptions.cs | `src/Features/Core/Portable/DocumentationComments/DocumentationCommentOptions.cs` | オプション設定の定義 |

**読解のコツ**:
- **DocumentationCommentOptions**: AutoXmlDocCommentGeneration, GenerateSummaryTagOnSingleLine, GenerateOnlySummaryTagなどのオプションを確認

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IDocumentationCommentSnippetService.cs | `src/Features/Core/Portable/DocumentationComments/IDocumentationCommentSnippetService.cs` | サービスインターフェースの定義 |

**主要処理フロー**:
- **16行目**: `DocumentationCommentCharacter` - コメント文字（C#は"/"、VBは"'"）
- **18-22行目**: `GetDocumentationCommentSnippetOnCharacterTyped` - 文字入力時の処理
- **24-28行目**: `GetDocumentationCommentSnippetOnCommandInvoke` - コマンド実行時の処理
- **30-34行目**: `GetDocumentationCommentSnippetOnEnterTyped` - Enter時の処理
- **41行目**: `IsValidTargetMember` - 有効な対象メンバーかの判定

#### Step 3: 抽象実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractDocumentationCommentSnippetService.cs | `src/Features/Core/Portable/DocumentationComments/AbstractDocumentationCommentSnippetService.cs` | 共通ロジックの実装 |

**主要処理フロー**:
- **17-19行目**: ジェネリック型パラメータでドキュメントコメントノードとメンバーノードを指定
- **21-25行目**: 抽象メソッド定義（GetContainingMember, SupportsDocumentationComments等）
- **66-101行目**: `GetDocumentationCommentSnippetOnCharacterTyped` - 文字入力時のメイン処理
- **103-143行目**: `GetDocumentationCommentLines` - ドキュメントコメント行の生成
- **244-258行目**: `GetDocumentationCommentSnippetOnEnterTyped` - Enter時の処理
- **313-351行目**: `GetDocumentationCommentSnippetOnCommandInvoke` - コマンド実行時の処理

### プログラム呼び出し階層図

```
エディタ（文字入力/Enter/コマンド）
    │
    ├─ GetDocumentationCommentSnippetOnCharacterTyped
    │      ├─ IsAtEndOfDocCommentTriviaOnBlankLine
    │      ├─ GetDocumentationCommentLines
    │      │      ├─ GetDocumentationStubLines
    │      │      │      ├─ IsSingleExteriorTrivia
    │      │      │      └─ GetDocumentationCommentStubLines
    │      │      └─ IndentLines
    │      └─ DocumentationCommentSnippet生成
    │
    ├─ GetDocumentationCommentSnippetOnEnterTyped
    │      ├─ GenerateDocumentationCommentAfterEnter
    │      └─ GenerateExteriorTriviaAfterEnter
    │             └─ GetDocumentationCommentSnippetFromPreviousLine
    │
    └─ GetDocumentationCommentSnippetOnCommandInvoke
           ├─ GetTargetMember
           ├─ GetDocumentationCommentStubLines
           └─ IndentLines
```

### データフロー図

```
[入力]               [処理]                           [出力]

カーソル位置    ───▶ 入力タイプ判定              ───▶ 処理メソッド選択
ParsedDocument  ───▶
Options         ───▶
                      │
                      ▼
              対象メンバー検出
              GetContainingMember
                      │
                      ▼
              スタブ行生成
              GetDocumentationCommentStubLines
                      │
                      ▼
              インデント適用
              IndentLines
                      │
                      ▼
              DocumentationCommentSnippet  ───▶ エディタへ適用
                      ├─ SpanToReplace
                      ├─ SnippetText
                      ├─ CaretOffset
                      └─ IndentText
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IDocumentationCommentSnippetService.cs | `src/Features/Core/Portable/DocumentationComments/` | インターフェース | サービスインターフェース定義 |
| AbstractDocumentationCommentSnippetService.cs | `src/Features/Core/Portable/DocumentationComments/` | 抽象クラス | 共通ロジック実装 |
| DocumentationCommentSnippet.cs | `src/Features/Core/Portable/DocumentationComments/` | データ型 | スニペット情報 |
| DocumentationCommentOptions.cs | `src/Features/Core/Portable/DocumentationComments/` | オプション | 生成オプション設定 |
| DocumentationCommentSnippetHelpers.cs | `src/Features/Core/Portable/DocumentationComments/` | ヘルパー | ユーティリティメソッド |
| DocumentationCommentTagType.cs | `src/Features/Core/Portable/DocumentationComments/` | 列挙型 | タグタイプ定義 |
| IDocumentationCommentFormattingService.cs | `src/Features/Core/Portable/DocumentationComments/` | インターフェース | フォーマットサービス |
| AbstractDocumentationCommentFormattingService.cs | `src/Features/Core/Portable/DocumentationComments/` | 抽象クラス | フォーマット実装 |
| DocumentationCommentProposal.cs | `src/Features/Core/Portable/DocumentationComments/` | データ型 | 提案データ |
| DocumentationCommentProposedEdit.cs | `src/Features/Core/Portable/DocumentationComments/` | データ型 | 編集提案データ |
