# 機能設計書 76-フォーマット

## 概要

本ドキュメントは、Roslynのフォーマット（Formatting）機能の設計を記載する。この機能は、コードの自動整形を行い、インデント、スペース、改行などを一貫したスタイルに統一する。特に新規ドキュメント作成時のフォーマットサービスを提供する。

### 本機能の処理概要

**業務上の目的・背景**：チーム開発において、コードスタイルの一貫性は保守性と可読性に直結する。手動でのフォーマット調整は時間がかかり、ミスも発生しやすい。フォーマット機能は、EditorConfigやIDEの設定に基づいてコードを自動整形することで、これらの問題を解決し、開発者がロジックに集中できる環境を提供する。

**機能の利用シーン**：
1. 新規ファイル作成時の自動フォーマット
2. コード編集後の保存時フォーマット
3. ショートカットキーによるドキュメント全体のフォーマット
4. 選択範囲のフォーマット

**主要な処理内容**：
1. 新規ドキュメントのフォーマット（INewDocumentFormattingService）
2. 複数のフォーマットプロバイダーによる段階的フォーマット
3. コードクリーンアップとの統合
4. フォーマットルールに基づく整形

**関連システム・外部連携**：Visual Studioエディタ、Language Server Protocol (LSP)、EditorConfig、コードクリーンアップ機能と連携する。

**権限による制御**：特になし。全ユーザーが利用可能な標準機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 35 | C#書式設定オプションページコントロール | 主機能 | C#コードのインデント・改行・スペース設定 |

## 機能種別

エディタ支援機能（コード変換・整形）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | フォーマット対象ドキュメント | null不可 |
| hintDocument | Document? | No | ヒント用ドキュメント（オプション） | - |
| options | CodeCleanupOptions | Yes | クリーンアップオプション | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ドキュメントの構文木
- EditorConfig設定
- IDEのフォーマットオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| document | Document | フォーマット済みドキュメント |

### 出力先

- エディタのテキストバッファ
- ドキュメントモデル

## 処理フロー

### 処理シーケンス

```
1. フォーマットプロバイダーの取得
   └─ MEFで登録されたINewDocumentFormattingProviderを言語でフィルタリング
2. プロバイダーによる段階的フォーマット
   ├─ 各プロバイダーでFormatNewDocumentAsyncを実行
   └─ ドキュメントが変更された場合はCodeAction.CleanupSyntaxAsyncを実行
3. エラーハンドリング
   └─ 個別プロバイダーのエラーはキャッチして続行
4. 結果返却
   └─ フォーマット済みドキュメントを返却
```

### フローチャート

```mermaid
flowchart TD
    A[FormatNewDocumentAsync開始] --> B[プロバイダー取得]
    B --> C{次のプロバイダーあり?}
    C -->|No| D[結果返却]
    C -->|Yes| E[FormatNewDocumentAsync実行]
    E --> F{ドキュメント変更?}
    F -->|Yes| G[CleanupSyntaxAsync実行]
    F -->|No| C
    G --> C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-76-1 | プロバイダー独立性 | 各プロバイダーは独立して動作し、順序依存しない | 常時 |
| BR-76-2 | エラー継続 | 1つのプロバイダーがエラーでも他は続行 | 常時 |
| BR-76-3 | 変更時クリーンアップ | ドキュメント変更時はCleanupSyntaxAsyncを実行 | ドキュメント変更時 |
| BR-76-4 | 言語フィルタリング | プロバイダーは言語ごとにフィルタリング | 常時 |

### 計算ロジック

特になし。フォーマットルールは各プロバイダーで定義される。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CancellationException | ユーザーがキャンセル | 処理中断 |
| - | Exception | プロバイダー内部エラー | ログ記録して続行 |

### リトライ仕様

リトライなし。個別プロバイダーのエラーは無視して続行。

## トランザクション仕様

トランザクションなし。各プロバイダーは独立して動作。

## パフォーマンス要件

- 大規模ドキュメントでも実用的な速度でフォーマット
- 段階的なクリーンアップで効率を確保

## セキュリティ考慮事項

特になし。ローカルのコード編集操作のみ。

## 備考

- C#とVisual Basicの両言語で利用可能
- Core/PortableにはINewDocumentFormattingServiceのみ、詳細なフォーマットロジックはWorkspaces/Coreで実装
- EditorConfigとの統合はCodeStyle機能で提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INewDocumentFormattingService.cs | `src/Features/Core/Portable/Formatting/INewDocumentFormattingService.cs` | サービスインターフェースの定義 |
| 1-2 | INewDocumentFormattingProvider.cs | `src/Features/Core/Portable/Formatting/INewDocumentFormattingProvider.cs` | プロバイダーインターフェースの定義 |

**読解のコツ**:
- **12-20行目**: `INewDocumentFormattingService`インターフェース定義
- **19行目**: `FormatNewDocumentAsync` - 新規ドキュメントのフォーマットメソッド

#### Step 2: 抽象実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractNewDocumentFormattingService.cs | `src/Features/Core/Portable/Formatting/AbstractNewDocumentFormattingService.cs` | 共通ロジックの実装 |

**主要処理フロー**:
- **17行目**: `AbstractNewDocumentFormattingService`抽象クラス
- **19行目**: プロバイダーのコレクションを保持
- **22行目**: `Language`抽象プロパティで言語を指定
- **29-33行目**: `GetProviders` - 言語でフィルタリングしてプロバイダーを取得
- **35-65行目**: `FormatNewDocumentAsync` - メインのフォーマット処理
- **44-57行目**: 各プロバイダーを順に実行、変更があればCleanupSyntaxAsync

#### Step 3: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FormattingRuleUtilities.cs | `src/Features/Core/Portable/Formatting/FormattingRuleUtilities.cs` | フォーマットルールユーティリティ |
| 3-2 | ExportNewDocumentFormattingProviderAttribute.cs | `src/Features/Core/Portable/Formatting/ExportNewDocumentFormattingProviderAttribute.cs` | MEFエクスポート属性 |

### プログラム呼び出し階層図

```
エディタ（新規ドキュメント作成）
    │
    └─ INewDocumentFormattingService.FormatNewDocumentAsync
           │
           ├─ GetProviders（言語フィルタリング）
           │
           └─ foreach provider in providers
                  │
                  ├─ provider.FormatNewDocumentAsync
                  │
                  └─ (変更あり) CodeAction.CleanupSyntaxAsync
```

### データフロー図

```
[入力]               [処理]                           [出力]

Document        ───▶ FormatNewDocumentAsync      ───▶ Document（フォーマット済み）
hintDocument    ───▶
CodeCleanupOptions ───▶
                      │
                      ├─ プロバイダー1で処理
                      ├─ CleanupSyntaxAsync
                      ├─ プロバイダー2で処理
                      ├─ CleanupSyntaxAsync
                      └─ ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INewDocumentFormattingService.cs | `src/Features/Core/Portable/Formatting/` | インターフェース | サービスインターフェース定義 |
| AbstractNewDocumentFormattingService.cs | `src/Features/Core/Portable/Formatting/` | 抽象クラス | 共通ロジック実装 |
| INewDocumentFormattingProvider.cs | `src/Features/Core/Portable/Formatting/` | インターフェース | プロバイダーインターフェース |
| ExportNewDocumentFormattingProviderAttribute.cs | `src/Features/Core/Portable/Formatting/` | 属性 | MEFエクスポート属性 |
| FormattingRuleUtilities.cs | `src/Features/Core/Portable/Formatting/` | ユーティリティ | フォーマットルールヘルパー |
