# 機能設計書 77-行セパレータ

## 概要

本ドキュメントは、Roslynの行セパレータ（LineSeparators）機能の設計を記載する。この機能は、メソッドやプロパティなどのメンバー間に視覚的な区切り線を表示することで、コードの構造を明確にし、可読性を向上させる。

### 本機能の処理概要

**業務上の目的・背景**：大規模なクラスやファイルでは、多数のメソッドやプロパティが含まれ、各メンバーの境界を視覚的に把握することが困難になる場合がある。行セパレータ機能は、メンバー間に薄い水平線を表示することで、コードの論理的な区切りを明確にし、開発者がコードを素早くスキャンして目的のセクションを見つけやすくする。

**機能の利用シーン**：コードエディタでファイルを開いたとき、およびスクロール時に自動的に行セパレータが表示される。Visual Studioのオプションで有効/無効を切り替え可能。

**主要な処理内容**：
1. 指定されたテキスト範囲内のメンバー境界を検出
2. 各メンバーの終了行にセパレータ位置を記録
3. TextSpanのコレクションとして結果を返却
4. エディタがセパレータ線を描画

**関連システム・外部連携**：Visual Studioエディタ、Language Server Protocol (LSP)、エディタの装飾レイヤーと連携する。

**権限による制御**：特になし。全ユーザーが利用可能な標準機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | メンバー間の視覚的区切り線表示 |

## 機能種別

エディタ支援機能（視覚的フィードバック）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| textSpan | TextSpan | Yes | 検索対象のテキスト範囲 | 有効な範囲 |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- エディタからの表示範囲情報
- ドキュメントの構文木

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TextSpan[] | ImmutableArray<TextSpan> | セパレータを表示する位置のコレクション |

### 出力先

- エディタの装飾レイヤー
- ImmutableArray<TextSpan>として返却

## 処理フロー

### 処理シーケンス

```
1. サービスの取得
   └─ ILineSeparatorServiceを言語に応じて取得
2. セパレータ位置の取得
   └─ GetLineSeparatorsAsyncを呼び出し
3. メンバー境界の検出
   ├─ 構文木を解析
   └─ メソッド、プロパティ、フィールドなどの終了位置を特定
4. 結果返却
   └─ TextSpanのコレクションを返却
5. エディタ描画
   └─ 各TextSpanの位置に水平線を描画
```

### フローチャート

```mermaid
flowchart TD
    A[表示範囲変更] --> B[GetLineSeparatorsAsync呼び出し]
    B --> C[構文木取得]
    C --> D[メンバー境界検出]
    D --> E{メンバーあり?}
    E -->|No| F[空配列返却]
    E -->|Yes| G[TextSpanコレクション生成]
    G --> H[結果返却]
    H --> I[エディタでセパレータ描画]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-77-1 | メンバー単位表示 | セパレータはメソッド、プロパティ、フィールドなどのメンバー間に表示 | 常時 |
| BR-77-2 | 表示範囲限定 | 指定されたtextSpan内のセパレータのみ返却 | 常時 |
| BR-77-3 | オプション制御 | Visual Studioのオプションで有効/無効を設定可能 | IDE使用時 |

### 計算ロジック

セパレータ位置の決定:
- 各メンバーの終了行の次の行の開始位置をTextSpanとして記録
- 連続するメンバー間に1本のセパレータ線を配置

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。メモリ上のドキュメントモデルに対する読み取り操作のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CancellationException | ユーザーがキャンセル | 処理中断 |

### リトライ仕様

リトライなし。失敗時は空の配列を返却。

## トランザクション仕様

トランザクションなし。読み取り専用操作。

## パフォーマンス要件

- スクロール時にもスムーズに動作
- 表示範囲限定により不要な計算をスキップ
- 構文木のキャッシュを活用

## セキュリティ考慮事項

特になし。ローカルの読み取り専用操作のみ。

## 備考

- C#とVisual Basicの両言語で利用可能
- 言語固有の実装がメンバー種別の判定を行う
- エディタ描画はEditorFeatures層で実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ILineSeparatorService.cs | `src/Features/Core/Portable/LineSeparators/ILineSeparatorService.cs` | サービスインターフェースの定義 |

**読解のコツ**:
- **13-16行目**: `ILineSeparatorService`インターフェース定義
- **15行目**: `GetLineSeparatorsAsync` - セパレータ位置を非同期で取得

#### Step 2: 言語固有実装を理解する

言語固有の実装は以下のパスに存在する:
- C#: `src/Features/CSharp/Portable/LineSeparators/`
- VB: `src/Features/VisualBasic/Portable/LineSeparators/`

### プログラム呼び出し階層図

```
エディタ（表示範囲変更）
    │
    └─ ILineSeparatorService.GetLineSeparatorsAsync
           │
           ├─ Document.GetSyntaxRootAsync
           │
           ├─ メンバー境界検出（言語固有実装）
           │      └─ メソッド、プロパティ、フィールド等の終了位置
           │
           └─ ImmutableArray<TextSpan>生成
```

### データフロー図

```
[入力]               [処理]                           [出力]

Document        ───▶ GetLineSeparatorsAsync      ───▶ ImmutableArray<TextSpan>
TextSpan        ───▶
                      │
                      ├─ 構文木取得
                      │
                      ├─ メンバー境界検出
                      │
                      └─ TextSpanコレクション生成
                                                       │
                                                       ▼
                                               エディタ装飾レイヤー
                                               （水平線描画）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ILineSeparatorService.cs | `src/Features/Core/Portable/LineSeparators/` | インターフェース | サービスインターフェース定義 |
