# 機能設計書 8-MSBuildワークスペース

## 概要

本ドキュメントは、RoslynプラットフォームにおけるMSBuildワークスペースの機能設計について記述する。MSBuildワークスペースは、MSBuildソリューション/プロジェクトファイルからRoslynワークスペースを構築するための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：MSBuildワークスペースは、.sln/.csproj/.vbprojファイルを読み込んでRoslynのSolution/Project/Document階層構造を構築する。これにより、外部ツールやスクリプトからMSBuildプロジェクトをRoslynで解析・変更することが可能となる。ビルドホストプロセスを使用してMSBuild評価を行い、正確なプロジェクト情報を取得する。

**機能の利用シーン**：
- コード解析ツールからのソリューション読み込み
- リファクタリングツールでのプロジェクト操作
- カスタムビルドツールの実装
- コード生成ツールでのプロジェクト情報取得
- CI/CDでのコード解析

**主要な処理内容**：
1. ソリューションファイル (.sln) の解析
2. プロジェクトファイル (.csproj/.vbproj) のMSBuild評価
3. ソースファイル、参照、アナライザーの解決
4. Roslynワークスペースへの変換
5. 診断情報の収集

**関連システム・外部連携**：
- MSBuildビルドエンジン
- ビルドホストプロセス
- ワークスペース基盤

**権限による制御**：ファイルシステムへの読み取り権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | APIとして使用されるため画面は存在しない |

## 機能種別

ワークスペースプロバイダー

## 入力仕様

### Create静的メソッド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| properties | IDictionary<string, string> | No | MSBuildプロパティ | - |
| hostServices | HostServices | No | ホストサービス | - |

### OpenSolutionAsync

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| solutionFilePath | string | Yes | ソリューションファイルパス | null不可、ファイル存在確認 |
| msbuildLogger | ILogger | No | MSBuildロガー | - |
| progress | IProgress<ProjectLoadProgress> | No | 進捗報告 | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### OpenProjectAsync

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| projectFilePath | string | Yes | プロジェクトファイルパス | null不可、ファイル存在確認 |
| msbuildLogger | ILogger | No | MSBuildロガー | - |
| progress | IProgress<ProjectLoadProgress> | No | 進捗報告 | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ソリューションファイル (.sln)
- プロジェクトファイル (.csproj/.vbproj/.fsproj)
- MSBuildプロパティ
- 環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Solution | Solution | 読み込まれたソリューション |
| Project | Project | 読み込まれたプロジェクト |
| Diagnostics | ImmutableList<WorkspaceDiagnostic> | 読み込み時の診断 |

### 出力先

- ワークスペースのCurrentSolution

## 処理フロー

### 処理シーケンス

```
1. MSBuildWorkspace.Create呼び出し
   └─ プロパティとHostServicesで初期化

2. OpenSolutionAsync呼び出し
   └─ ソリューションファイル解析
   └─ プロジェクト一覧取得

3. 各プロジェクトの読み込み
   └─ BuildHostProcessManagerでビルドホスト起動
   └─ MSBuild評価実行
   └─ ProjectFileInfo取得

4. Roslynプロジェクト構築
   └─ ソースファイル追加
   └─ 参照解決
   └─ アナライザー追加

5. ワークスペース更新
   └─ CurrentSolutionに反映
   └─ 診断情報収集
```

### フローチャート

```mermaid
flowchart TD
    A[MSBuildWorkspace.Create] --> B[プロパティ設定]
    B --> C[OpenSolutionAsync]
    C --> D[SolutionFileReader読み込み]
    D --> E{プロジェクト一覧取得}
    E --> F[各プロジェクトを処理]
    F --> G[BuildHostProcessManager]
    G --> H[MSBuild評価]
    H --> I[ProjectFileInfo取得]
    I --> J{参照プロジェクト?}
    J -->|Yes| K[依存プロジェクト読み込み]
    J -->|No| L[ソースファイル追加]
    K --> L
    L --> M[参照アセンブリ解決]
    M --> N[アナライザー追加]
    N --> O{次のプロジェクト?}
    O -->|Yes| F
    O -->|No| P[CurrentSolution更新]
    P --> Q[診断情報返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | メタデータ参照優先 | LoadMetadataForReferencedProjects=trueで参照プロジェクトをメタデータとして読み込み | 設定時 |
| BR-02 | 未認識プロジェクトスキップ | SkipUnrecognizedProjects=trueで未サポートプロジェクトをスキップ | 設定時 |
| BR-03 | ファイル拡張子関連付け | AssociateFileExtensionWithLanguageで言語を関連付け | カスタム拡張子使用時 |
| BR-04 | ビルドホスト分離 | 別プロセスでMSBuild評価を実行 | 常時 |

### プロパティ

| プロパティ名 | 型 | 説明 |
|-------------|-----|------|
| Properties | ImmutableDictionary<string, string> | MSBuildプロパティ |
| LoadMetadataForReferencedProjects | bool | 参照プロジェクトをメタデータで読み込み |
| SkipUnrecognizedProjects | bool | 未認識プロジェクトをスキップ |
| Diagnostics | ImmutableList<WorkspaceDiagnostic> | 診断情報 |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ArgumentNullException | 引数エラー | ファイルパスnull | 有効なパスを指定 |
| FileNotFoundException | ファイルエラー | ファイル未検出 | パス確認 |
| WorkspaceDiagnostic | 診断 | MSBuild評価エラー | Diagnosticsで確認 |

### リトライ仕様

リトライ処理は存在しない。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- ビルドホストプロセスのプール管理
- 並列プロジェクト読み込み
- 進捗報告によるユーザーフィードバック

## セキュリティ考慮事項

- ファイルシステムアクセス権限の確認
- ビルドホストプロセスの分離

## 備考

- MSBuildWorkspaceはsealed class
- MSBuildMefHostServicesがデフォルトのホストサービスを提供
- ビルドホストプロセスは.NET FrameworkまたはCoreのどちらかを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: MSBuildWorkspaceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MSBuildWorkspace.cs | `src/Workspaces/MSBuild/Core/MSBuild/MSBuildWorkspace.cs` | メインクラス |

**主要処理フロー**:
1. **27行目**: sealed class、Workspaceを継承
2. **32行目**: MSBuildProjectLoaderを保持
3. **45-48行目**: Create静的メソッド
4. **100行目**: Propertiesプロパティ
5. **105行目**: Diagnosticsプロパティ
6. **118-122行目**: LoadMetadataForReferencedProjectsプロパティ
7. **174-179行目**: OpenSolutionAsync

#### Step 2: プロジェクトローダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MSBuildProjectLoader.cs | `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.cs` | プロジェクト読み込み |
| 2-2 | MSBuildProjectLoader.Worker.cs | `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.Worker.cs` | ワーカー実装 |

#### Step 3: ビルドホストを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BuildHostProcessManager.cs | `src/Workspaces/MSBuild/Core/MSBuild/BuildHostProcessManager.cs` | ビルドホスト管理 |
| 3-2 | RemoteBuildHost.cs | `src/Workspaces/MSBuild/Core/Rpc/RemoteBuildHost.cs` | リモートビルドホスト |

### プログラム呼び出し階層図

```
MSBuildWorkspace
    │
    ├─ MSBuildProjectLoader
    │      │
    │      ├─ SolutionFileReader
    │      │      └─ .slnファイル解析
    │      │
    │      └─ Worker
    │             │
    │             ├─ BuildHostProcessManager
    │             │      │
    │             │      └─ RemoteBuildHost
    │             │             │
    │             │             └─ BuildHost (別プロセス)
    │             │
    │             └─ ProjectFileInfo取得
    │
    └─ Workspace (base)
           │
           └─ CurrentSolution更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MSBuildWorkspace.cs | `src/Workspaces/MSBuild/Core/MSBuild/MSBuildWorkspace.cs` | ソース | メインワークスペース |
| MSBuildProjectLoader.cs | `src/Workspaces/MSBuild/Core/MSBuild/MSBuildProjectLoader.cs` | ソース | プロジェクトローダー |
| BuildHostProcessManager.cs | `src/Workspaces/MSBuild/Core/MSBuild/BuildHostProcessManager.cs` | ソース | ビルドホスト管理 |
| SolutionFileReader.cs | `src/Workspaces/MSBuild/Core/MSBuild/SolutionFileReader.cs` | ソース | ソリューション解析 |
| ProjectFileInfo.cs | `src/Workspaces/MSBuild/Contracts/ProjectFileInfo.cs` | ソース | プロジェクト情報 |
| RemoteBuildHost.cs | `src/Workspaces/MSBuild/Core/Rpc/RemoteBuildHost.cs` | ソース | リモートホスト |
