# 機能設計書 80-インラインヒント

## 概要

本ドキュメントは、Roslynのインラインヒント（InlineHints）機能の設計を記載する。この機能は、コード内にパラメータ名や推論された型情報をインラインで表示し、コードの可読性と理解を向上させる。

### 本機能の処理概要

**業務上の目的・背景**：C#やVisual Basicでは、型推論（`var`キーワード）やメソッド呼び出し時の引数順序など、コードを読むだけでは分かりにくい情報が存在する。インラインヒント機能は、これらの情報をエディタ上に直接表示することで、開発者がコードを理解するための補助情報を提供する。特に、パラメータ名ヒントは引数の意味を明確にし、型ヒントは変数の型を一目で把握できるようにする。

**機能の利用シーン**：コードエディタでファイルを開いたとき、設定に応じて自動的にインラインヒントが表示される。Visual Studioのオプションで、パラメータ名ヒント、型ヒントそれぞれの表示条件を詳細に設定可能。

**主要な処理内容**：
1. 指定されたテキスト範囲内のヒント対象を検出
2. パラメータ名ヒントの生成（メソッド呼び出しの引数）
3. 型ヒントの生成（varキーワード、ラムダパラメータ等）
4. 表示テキストとホバー情報の生成
5. オプションに基づくフィルタリング

**関連システム・外部連携**：Visual Studioエディタ、Language Server Protocol (LSP)、エディタのインレイアドーメント機能と連携する。

**権限による制御**：特になし。全ユーザーが利用可能な標準機能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | パラメータ名・型のインライン表示 |

## 機能種別

エディタ支援機能（視覚的フィードバック・補助情報表示）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| textSpan | TextSpan | Yes | 検索対象のテキスト範囲 | 有効な範囲 |
| options | InlineHintsOptions | Yes | ヒントオプション | - |
| displayAllOverride | bool | No | 全表示オーバーライド | - |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ドキュメントの構文木
- セマンティックモデル（型情報取得用）
- InlineHintsOptions設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Span | TextSpan | ヒントを表示する位置 |
| DisplayParts | ImmutableArray<TaggedText> | 表示するテキストパーツ |
| ReplacementTextChange | TextChange? | クリック時の置換テキスト |
| Ranking | double | ヒントの優先度 |

### 出力先

- InlineHintのコレクションとして返却
- エディタのインレイアドーメント

## 処理フロー

### 処理シーケンス

```
1. サービスの取得
   └─ IInlineHintsServiceを言語に応じて取得
2. ヒントの収集
   ├─ パラメータ名ヒントサービス呼び出し
   │   └─ IInlineParameterNameHintsService.AddInlineHintsAsync
   └─ 型ヒントサービス呼び出し
       └─ IInlineTypeHintsService.AddInlineHintsAsync
3. 各サービスでの処理
   ├─ 構文木を解析してヒント対象を検出
   ├─ セマンティックモデルで型情報を取得
   └─ InlineHintを生成してArrayBuilderに追加
4. 結果返却
   └─ ImmutableArray<InlineHint>として返却
```

### フローチャート

```mermaid
flowchart TD
    A[GetInlineHintsAsync開始] --> B[パラメータ名ヒントサービス取得]
    B --> C{サービスあり?}
    C -->|Yes| D[AddInlineHintsAsync呼び出し]
    C -->|No| E[型ヒントサービス取得]
    D --> E
    E --> F{サービスあり?}
    F -->|Yes| G[AddInlineHintsAsync呼び出し]
    F -->|No| H[結果返却]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-1 | パラメータ名ヒント | メソッド呼び出しの引数にパラメータ名を表示 | オプション有効時 |
| BR-80-2 | 型ヒント | var、ラムダパラメータ等に推論された型を表示 | オプション有効時 |
| BR-80-3 | リテラル除外 | リテラル値のパラメータ名ヒントは表示しない設定可能 | オプション設定 |
| BR-80-4 | オブジェクト作成除外 | new式のパラメータ名ヒントは表示しない設定可能 | オプション設定 |
| BR-80-5 | 他パラメータ除外 | パラメータ変数を渡す場合のヒントは表示しない設定可能 | オプション設定 |
| BR-80-6 | 配列のみ許容 | 配列のインデクサのみ型ヒントを表示する設定可能 | オプション設定 |
| BR-80-7 | 明示型除外 | 明示的に型指定されたラムダパラメータには型ヒント不要 | 常時 |

### 計算ロジック

ヒント表示位置:
- パラメータ名ヒント: 引数の直前に表示
- 型ヒント: 変数名の直後に表示

置換テキスト:
- クリック時にパラメータ名を挿入（例: `paramName:`）
- クリック時に型を明示（例: `var` → `string`）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし。メモリ上のドキュメントモデルとセマンティックモデルに対する読み取り操作のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CancellationException | ユーザーがキャンセル | 処理中断 |

### リトライ仕様

リトライなし。失敗時は空の配列を返却。

## トランザクション仕様

トランザクションなし。読み取り専用操作。

## パフォーマンス要件

- スクロール時にもスムーズに動作
- 表示範囲限定により不要な計算をスキップ
- ArrayBuilderの大規模インスタンスをプールで再利用

## セキュリティ考慮事項

特になし。ローカルの読み取り専用操作のみ。

## 備考

- C#とVisual Basicの両言語で利用可能
- LSPのtextDocument/inlayHintリクエストで使用
- VS 2022以降で強化された機能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インラインヒント機能で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InlineHint.cs | `src/Features/Core/Portable/InlineHints/InlineHint.cs` | ヒント情報を保持する構造体 |
| 1-2 | InlineHintsOptions.cs | `src/Features/Core/Portable/InlineHints/InlineHintsOptions.cs` | オプション設定の定義 |

**読解のコツ**:
- **InlineHint.cs 14-19行目**: 構造体のフィールド定義（Span, DisplayParts, ReplacementTextChange, Ranking）
- **InlineHint.cs 22-54行目**: 複数のコンストラクタオーバーロード
- **InlineHint.cs 60-61行目**: `GetDescriptionAsync`でホバー時の説明を取得

#### Step 2: オプション設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InlineParameterHintsOptions.cs | `src/Features/Core/Portable/InlineHints/InlineParameterHintsOptions.cs` | パラメータ名ヒントオプション |
| 2-2 | InlineTypeHintsOptions.cs | `src/Features/Core/Portable/InlineHints/InlineTypeHintsOptions.cs` | 型ヒントオプション |

#### Step 3: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IInlineHintsService.cs | `src/Features/Core/Portable/InlineHints/IInlineHintsService.cs` | メインサービスインターフェース |
| 3-2 | IInlineParameterNameHintsService.cs | `src/Features/Core/Portable/InlineHints/IInlineParameterNameHintsService.cs` | パラメータ名ヒントサービス |
| 3-3 | IInlineTypeHintsService.cs | `src/Features/Core/Portable/InlineHints/IInlineTypeHintsService.cs` | 型ヒントサービス |

**主要処理フロー**:
- **IInlineHintsService.cs 15-16行目**: `GetInlineHintsAsync`でヒントを非同期取得

#### Step 4: サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractInlineHintsService.cs | `src/Features/Core/Portable/InlineHints/AbstractInlineHintsService.cs` | メインサービス実装 |
| 4-2 | AbstractInlineParameterNameHintsService.cs | `src/Features/Core/Portable/InlineHints/AbstractInlineParameterNameHintsService.cs` | パラメータ名ヒント実装 |
| 4-3 | AbstractInlineTypeHintsService.cs | `src/Features/Core/Portable/InlineHints/AbstractInlineTypeHintsService.cs` | 型ヒント実装 |

**主要処理フロー**:
- **AbstractInlineHintsService.cs 17-37行目**: パラメータ名ヒントと型ヒントを順に収集
- **AbstractInlineHintsService.cs 24行目**: 大規模配列をプールで再利用

### プログラム呼び出し階層図

```
エディタ（表示範囲変更）
    │
    └─ IInlineHintsService.GetInlineHintsAsync
           │
           ├─ IInlineParameterNameHintsService.AddInlineHintsAsync
           │      ├─ Document.GetSemanticModelAsync
           │      ├─ メソッド呼び出し引数の検出
           │      └─ InlineHint生成（パラメータ名）
           │
           └─ IInlineTypeHintsService.AddInlineHintsAsync
                  ├─ Document.GetSemanticModelAsync
                  ├─ var/ラムダパラメータの検出
                  └─ InlineHint生成（型情報）
```

### データフロー図

```
[入力]               [処理]                           [出力]

Document        ───▶ GetInlineHintsAsync         ───▶ ImmutableArray<InlineHint>
TextSpan        ───▶                                   ├─ Span
Options         ───▶                                   ├─ DisplayParts
displayAllOverride ───▶                                ├─ ReplacementTextChange
                      │                                └─ Ranking
                      ├─ パラメータ名ヒント収集
                      │   ├─ セマンティックモデル取得
                      │   └─ 引数からヒント生成
                      │
                      └─ 型ヒント収集
                          ├─ セマンティックモデル取得
                          └─ var/ラムダからヒント生成
                                                         │
                                                         ▼
                                                  エディタインレイアドーメント

表示イメージ:
Method(paramName: arg1, otherParam: arg2);
       ^^^^^^^^^       ^^^^^^^^^^
var x = GetValue();
    : string
    ^^^^^^^^
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IInlineHintsService.cs | `src/Features/Core/Portable/InlineHints/` | インターフェース | メインサービスインターフェース |
| AbstractInlineHintsService.cs | `src/Features/Core/Portable/InlineHints/` | 抽象クラス | メインサービス実装 |
| InlineHint.cs | `src/Features/Core/Portable/InlineHints/` | データ型 | ヒント情報構造体 |
| InlineHintsOptions.cs | `src/Features/Core/Portable/InlineHints/` | オプション | 統合オプション設定 |
| InlineParameterHintsOptions.cs | `src/Features/Core/Portable/InlineHints/` | オプション | パラメータ名ヒントオプション |
| InlineTypeHintsOptions.cs | `src/Features/Core/Portable/InlineHints/` | オプション | 型ヒントオプション |
| IInlineParameterNameHintsService.cs | `src/Features/Core/Portable/InlineHints/` | インターフェース | パラメータ名ヒントサービス |
| AbstractInlineParameterNameHintsService.cs | `src/Features/Core/Portable/InlineHints/` | 抽象クラス | パラメータ名ヒント実装 |
| IInlineTypeHintsService.cs | `src/Features/Core/Portable/InlineHints/` | インターフェース | 型ヒントサービス |
| AbstractInlineTypeHintsService.cs | `src/Features/Core/Portable/InlineHints/` | 抽象クラス | 型ヒント実装 |
| InlineHintHelpers.cs | `src/Features/Core/Portable/InlineHints/` | ヘルパー | ユーティリティメソッド |
| TypeHint.cs | `src/Features/Core/Portable/InlineHints/` | データ型 | 型ヒント情報 |
| InlineHintsConstants.cs | `src/Features/Core/Portable/InlineHints/` | 定数 | 定数定義 |
