# 機能設計書 81-コードラッピング

## 概要

本ドキュメントは、Roslyn IDEにおけるコードラッピング機能の設計を記載する。コードラッピングとは、長いコード行を複数行に折り返す、または複数行を1行にまとめるリファクタリング機能である。

### 本機能の処理概要

コードラッピング機能は、開発者がコードの可読性を向上させるために、引数リスト、パラメータリスト、二項式、メソッドチェーンなどの要素を複数行に展開したり、1行にまとめたりする操作を提供する。

**業務上の目的・背景**：コードの可読性はソフトウェア保守性に直結する。長い引数リストや複雑な式は1行に収まらないことが多く、適切な位置で改行を入れることでコードが読みやすくなる。逆に、短い要素が不必要に複数行に分かれている場合は1行にまとめることで画面スペースを有効活用できる。本機能は、これらの整形作業を自動化し、開発者の生産性を向上させる。

**機能の利用シーン**：
- 長いメソッドコールの引数リストを見やすく整形したい場合
- 複数行に分かれたパラメータ定義を1行にまとめたい場合
- 二項演算子を含む長い式を適切に分割したい場合
- メソッドチェーンを1行ずつに展開したい場合

**主要な処理内容**：
1. カーソル位置から対象となる構文ノード（引数リスト、パラメータリスト、二項式、チェーン式）を検出
2. 適用可能なラッピングオプション（展開/折りたたみ）を計算
3. 各オプションに対応するコードアクションを生成
4. ユーザー選択に応じてコードを変換・整形

**関連システム・外部連携**：EditorConfigの設定（インデントサイズ、タブ/スペース設定、折り返し列位置）と連携

**権限による制御**：特になし（エディタ機能として全ユーザーが利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | ライトバルブメニューからラッピングオプションを選択 |

## 機能種別

コードリファクタリング / コード整形

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | ドキュメント範囲内 |
| options | SyntaxWrappingOptions | Yes | ラッピングオプション | - |

### 入力データソース

- エディタ上のカーソル位置
- EditorConfig設定（FormattingOptions）
- ドキュメントの構文木

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CodeActions | ImmutableArray&lt;CodeAction&gt; | ラッピングコードアクション一覧 |

### 出力先

ライトバルブメニュー（コードアクションリスト）

## 処理フロー

### 処理シーケンス

```
1. カーソル位置のトークンを取得
   └─ 構文ルートからFindTokenを実行
2. 親ノードを走査し対象ノードを検索
   └─ AncestorsAndSelfを使用して上位ノードを順次チェック
3. 各ISyntaxWrapperで対象ノードを処理
   └─ TryCreateComputerAsync で該当するラッパーを特定
4. コードアクションを計算
   └─ GetTopLevelCodeActionsAsync でラッピングオプションを生成
5. 重複アクションを除外
   └─ 同一結果となるアクションをフィルタリング
6. コードアクションを登録
   └─ context.RegisterRefactorings で登録
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[カーソル位置のトークン取得]
    B --> C{構文エラーあり?}
    C -->|Yes| D{ラッパーで処理可能?}
    C -->|No| E[親ノードを走査]
    D -->|Yes| F[コードアクション計算]
    D -->|No| G[終了]
    E --> H{ISyntaxWrapperで対象?}
    H -->|Yes| F
    H -->|No| I{さらに親あり?}
    I -->|Yes| E
    I -->|No| G
    F --> J[重複除外]
    J --> K[アクション登録]
    K --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 最小要素数 | 2要素以上のリストのみ対象 | リスト要素が1個以下の場合は対象外 |
| BR-02 | 構文エラー時の制限 | 構文エラーを含むノードは一部処理をスキップ | 対象ノードにエラーがある場合 |
| BR-03 | MRU順序 | 最近使用したラッピングオプションを優先表示 | 過去のラッピング操作履歴がある場合 |

### 計算ロジック

ラッピング列位置はEditorConfigの`max_line_length`または`WrappingColumn`オプションで制御される。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 処理スキップ | 構文エラーがあり処理不能 | コードアクションを生成しない |
| - | 処理スキップ | ホワイトスペース以外のトリビアを編集しようとした場合 | コードアクションを生成しない |

### リトライ仕様

なし

## トランザクション仕様

なし（エディタバッファへの変更のみ）

## パフォーマンス要件

- コードアクション計算は100ms以内に完了すること
- 大規模ファイルでもレスポンスが遅延しないこと

## セキュリティ考慮事項

特になし

## 備考

- ラッピングアクションは低優先度(CodeActionPriority.Low)で表示される
- 同一結果となるアクションは自動的に重複除外される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SyntaxWrappingOptions.cs | `src/Features/Core/Portable/Wrapping/SyntaxWrappingOptions.cs` | ラッピングオプション（FormattingOptions、OperatorPlacement）を理解 |
| 1-2 | Edit.cs | `src/Features/Core/Portable/Wrapping/Edit.cs` | 編集操作の構造（左右トークンとトリビア）を理解 |
| 1-3 | WrappingGroup.cs | `src/Features/Core/Portable/Wrapping/WrappingGroup.cs` | ラッピングアクショングループの構造を理解 |

**読解のコツ**: `SyntaxWrappingOptions`はFormattingOptionsを内包し、タブ/スペース設定やラッピング列位置を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractWrappingCodeRefactoringProvider.cs | `src/Features/Core/Portable/Wrapping/AbstractWrappingCodeRefactoringProvider.cs` | リファクタリングプロバイダーのエントリーポイント |

**主要処理フロー**:
1. **35-39行目**: ComputeRefactoringsAsyncでカーソル位置を取得
2. **42-46行目**: 構文ルートとオプションを取得
3. **48-70行目**: 親ノードを走査し各ISyntaxWrapperでコードアクションを生成

#### Step 3: ラッパーインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISyntaxWrapper.cs | `src/Features/Core/Portable/Wrapping/ISyntaxWrapper.cs` | ラッパーの契約（TryCreateComputerAsync）を理解 |

#### Step 4: コードアクション計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractCodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/AbstractCodeActionComputer.cs` | コードアクション生成の共通ロジック |

**主要処理フロー**:
- **120-161行目**: TryCreateCodeActionAsyncでツリー書き換えと重複チェック
- **271-315行目**: GetTopLevelCodeActionsAsyncでラッピンググループをアクションに変換

#### Step 5: 具体的なラッパー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | AbstractSeparatedSyntaxListWrapper.cs | `src/Features/Core/Portable/Wrapping/SeparatedSyntaxList/AbstractSeparatedSyntaxListWrapper.cs` | カンマ区切りリスト（引数、パラメータ）のラッピング |
| 5-2 | AbstractBinaryExpressionWrapper.cs | `src/Features/Core/Portable/Wrapping/BinaryExpression/AbstractBinaryExpressionWrapper.cs` | 二項式のラッピング |
| 5-3 | AbstractChainedExpressionWrapper.cs | `src/Features/Core/Portable/Wrapping/ChainedExpression/AbstractChainedExpressionWrapper.cs` | メソッドチェーンのラッピング |

#### Step 6: コードアクションの実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | WrapItemsAction.cs | `src/Features/Core/Portable/Wrapping/WrapItemsAction.cs` | 実際のドキュメント変更とMRU履歴管理 |

**主要処理フロー**:
- **44-48行目**: ComputeOperationsAsyncでRecordCodeActionOperationを追加
- **50-51行目**: SortActionsByMostRecentlyUsedでMRU順にソート

### プログラム呼び出し階層図

```
AbstractWrappingCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ ISyntaxWrapper.TryCreateComputerAsync
    │      │
    │      └─ AbstractSeparatedSyntaxListWrapper.TryCreateComputerAsync
    │              └─ SeparatedSyntaxListCodeActionComputer (new)
    │
    └─ ICodeActionComputer.GetTopLevelCodeActionsAsync
           │
           ├─ ComputeWrappingGroupsAsync
           │      └─ TryCreateCodeActionAsync
           │              ├─ RewriteTreeAsync
           │              └─ FormatDocumentAsync
           │
           └─ WrapItemsAction (new)
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ───▶ AbstractWrappingCodeRefactoringProvider
                        │
                        ▼
Document ────────▶ ISyntaxWrapper.TryCreateComputerAsync
                        │
                        ▼
EditorConfig ────▶ AbstractCodeActionComputer
                        │
                        ▼
                  GetTopLevelCodeActionsAsync ───▶ CodeActions
                        │
                        ▼
                  WrapItemsAction ───▶ 変更後Document
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractWrappingCodeRefactoringProvider.cs | `src/Features/Core/Portable/Wrapping/AbstractWrappingCodeRefactoringProvider.cs` | ソース | エントリーポイント |
| ISyntaxWrapper.cs | `src/Features/Core/Portable/Wrapping/ISyntaxWrapper.cs` | ソース | ラッパーインターフェース |
| ICodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/ICodeActionComputer.cs` | ソース | コードアクション計算インターフェース |
| AbstractCodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/AbstractCodeActionComputer.cs` | ソース | 共通コードアクション計算 |
| AbstractWrapper.cs | `src/Features/Core/Portable/Wrapping/AbstractWrapper.cs` | ソース | 共通ラッパー基底クラス |
| SyntaxWrappingOptions.cs | `src/Features/Core/Portable/Wrapping/SyntaxWrappingOptions.cs` | ソース | ラッピングオプション |
| Edit.cs | `src/Features/Core/Portable/Wrapping/Edit.cs` | ソース | 編集操作データ構造 |
| WrapItemsAction.cs | `src/Features/Core/Portable/Wrapping/WrapItemsAction.cs` | ソース | コードアクション実装 |
| WrappingGroup.cs | `src/Features/Core/Portable/Wrapping/WrappingGroup.cs` | ソース | アクショングループ |
| AbstractSeparatedSyntaxListWrapper.cs | `src/Features/Core/Portable/Wrapping/SeparatedSyntaxList/AbstractSeparatedSyntaxListWrapper.cs` | ソース | リストラッピング |
| SeparatedSyntaxListCodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/SeparatedSyntaxList/SeparatedSyntaxListCodeActionComputer.cs` | ソース | リストラッピング計算 |
| WrappingStyle.cs | `src/Features/Core/Portable/Wrapping/SeparatedSyntaxList/WrappingStyle.cs` | ソース | ラッピングスタイル列挙 |
| AbstractBinaryExpressionWrapper.cs | `src/Features/Core/Portable/Wrapping/BinaryExpression/AbstractBinaryExpressionWrapper.cs` | ソース | 二項式ラッピング |
| BinaryExpressionCodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/BinaryExpression/BinaryExpressionCodeActionComputer.cs` | ソース | 二項式ラッピング計算 |
| AbstractChainedExpressionWrapper.cs | `src/Features/Core/Portable/Wrapping/ChainedExpression/AbstractChainedExpressionWrapper.cs` | ソース | チェーン式ラッピング |
| ChainedExpressionCodeActionComputer.cs | `src/Features/Core/Portable/Wrapping/ChainedExpression/ChainedExpressionCodeActionComputer.cs` | ソース | チェーン式ラッピング計算 |
