# 機能設計書 82-Edit and Continue

## 概要

本ドキュメントは、Roslyn IDEにおけるEdit and Continue（EnC）機能の設計を記載する。Edit and Continueは、デバッグセッション中にソースコードを編集し、アプリケーションを再起動することなく変更を適用する機能である。

### 本機能の処理概要

Edit and Continue機能は、開発者がデバッグ中にコードを修正し、その変更をすぐに実行中のアプリケーションに反映させることを可能にする。これにより、従来のデバッグ・修正・再起動サイクルを大幅に短縮できる。

**業務上の目的・背景**：アプリケーション開発において、バグ修正や機能調整のためにデバッグセッションを中断して再起動する必要があると、開発効率が著しく低下する。特に状態の再現に時間がかかるアプリケーションでは、この問題が顕著である。Edit and Continueは、デバッグセッションを維持したまま変更を適用することで、開発のイテレーションを高速化する。

**機能の利用シーン**：
- デバッグ中にバグの原因を発見し、その場で修正したい場合
- UIの微調整を即座に確認したい場合
- ロジックの変更を再起動なしでテストしたい場合
- Hot Reload機能として継続的開発を行いたい場合

**主要な処理内容**：
1. デバッグセッションの開始と管理
2. ソースコード変更の検出と分析
3. 変更が適用可能かどうかの判定（Rude Editの検出）
4. デルタ（差分）の生成とモジュールへの適用
5. アクティブステートメントの追跡と再マッピング

**関連システム・外部連携**：
- デバッガー（IManagedHotReloadService）
- コンパイラ（Emit API）
- PDB情報

**権限による制御**：特になし（デバッグセッション中のみ有効）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | デバッグ中のコード編集 |
| - | エラーリスト | 結果表示画面 | Rude Edit診断の表示 |

## 機能種別

デバッグ支援 / Hot Reload

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| solution | Solution | Yes | 現在のソリューション | null不可 |
| debuggerService | IManagedHotReloadService | Yes | デバッガーサービス | null不可 |
| sourceTextProvider | IPdbMatchingSourceTextProvider | Yes | PDBマッチング用テキストプロバイダー | null不可 |
| activeStatementSpanProvider | ActiveStatementSpanProvider | Yes | アクティブステートメント位置プロバイダー | - |

### 入力データソース

- ソリューションのドキュメント
- デバッガーからのアクティブステートメント情報
- コンパイル出力（アセンブリ、PDB）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ModuleUpdates | ManagedHotReloadUpdates | モジュール更新情報 |
| Diagnostics | ImmutableArray&lt;Diagnostic&gt; | 診断情報 |
| SyntaxError | Diagnostic? | 構文エラー |
| ProjectsToRestart | ImmutableArray&lt;ProjectId&gt; | 再起動が必要なプロジェクト |
| ProjectsToRebuild | ImmutableArray&lt;ProjectId&gt; | 再ビルドが必要なプロジェクト |

### 出力先

- デバッガー（モジュール更新）
- エラーリスト（診断）
- Visual Studioステータスバー

## 処理フロー

### 処理シーケンス

```
1. デバッグセッション開始
   └─ StartDebuggingSessionでセッション作成
2. コミット済みソリューションの管理
   └─ 最後にデバッグ対象に適用されたソリューションを保持
3. ドキュメント変更の検出
   └─ GetDocumentDiagnosticsAsyncで変更分析
4. Rude Editの検出
   └─ 適用不可能な変更を診断としてレポート
5. ソリューション更新の発行
   └─ EmitSolutionUpdateAsyncでデルタ生成
6. 更新のコミットまたは破棄
   └─ CommitSolutionUpdateまたはDiscardSolutionUpdate
```

### フローチャート

```mermaid
flowchart TD
    A[デバッグ開始] --> B[StartDebuggingSession]
    B --> C[ソリューションスナップショット保存]
    C --> D{コード変更あり?}
    D -->|No| D
    D -->|Yes| E[GetDocumentDiagnosticsAsync]
    E --> F{Rude Edit?}
    F -->|Yes| G[診断をレポート]
    F -->|No| H[EmitSolutionUpdateAsync]
    H --> I{デルタ生成成功?}
    I -->|Yes| J[デバッガーに送信]
    I -->|No| G
    J --> K{適用成功?}
    K -->|Yes| L[CommitSolutionUpdate]
    K -->|No| M[DiscardSolutionUpdate]
    L --> D
    M --> D
    G --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Rude Edit制約 | 特定の変更パターンは適用不可 | ジェネリクス変更、列挙型変更、非同期ステートマシン変更など |
| BR-02 | アクティブステートメント制約 | 現在実行中のメソッド内の特定変更は不可 | ブレークポイント位置のコードを変更する場合 |
| BR-03 | ベースライン管理 | 同一モジュールに対する累積的なデルタ適用 | 複数回の変更を適用する場合 |

### 計算ロジック

デルタ生成はEmit APIを使用し、前回のベースラインからの差分のみを計算する。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENC0001〜 | Rude Edit | 適用不可能な変更 | ユーザーに通知、変更の取り消しまたはセッション再起動 |
| ErrorReadingFile | IO Error | DLL/PDB読み取り失敗 | エラーメッセージを表示 |

### リトライ仕様

ファイル読み取りエラー時は、ユーザーが再度変更適用を試行可能

## トランザクション仕様

- 更新は一括でコミットまたは破棄
- 部分的な適用は不可

## パフォーマンス要件

- 変更分析はリアルタイムで実行
- デルタ生成はブレーク状態から継続までの待機時間を最小化

## セキュリティ考慮事項

- デバッグセッションはローカルプロセスに限定
- テレメトリデータは匿名化

## 備考

- .NET Hot Reload機能と共通の基盤を使用
- 言語固有の分析はC#とVB用に個別実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DebuggingSessionId.cs | `src/Features/Core/Portable/EditAndContinue/DebuggingSessionId.cs` | セッションIDの構造 |
| 1-2 | ActiveStatement.cs | `src/Features/Core/Portable/EditAndContinue/ActiveStatement.cs` | アクティブステートメントの構造 |
| 1-3 | RudeEditKind.cs | `src/Features/Core/Portable/EditAndContinue/RudeEditKind.cs` | Rude Edit種別の列挙 |
| 1-4 | ModuleUpdateStatus.cs | `src/Features/Core/Portable/EditAndContinue/ModuleUpdateStatus.cs` | 更新ステータスの列挙 |

**読解のコツ**: Rude EditとはEnCで適用できない変更パターンを指す。種類ごとにユーザーへのメッセージが異なる。

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IEditAndContinueService.cs | `src/Features/Core/Portable/EditAndContinue/IEditAndContinueService.cs` | サービスの公開API |

**主要処理フロー**:
1. **27行目**: StartDebuggingSessionでセッション開始
2. **21行目**: GetDocumentDiagnosticsAsyncで診断取得
3. **22行目**: EmitSolutionUpdateAsyncでデルタ発行
4. **24行目**: CommitSolutionUpdateで変更確定

#### Step 3: サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | EditAndContinueService.cs | `src/Features/Core/Portable/EditAndContinue/EditAndContinueService.cs` | サービスの実装 |

**主要処理フロー**:
- **151-178行目**: StartDebuggingSessionでDebuggingSessionを作成
- **180-193行目**: EndDebuggingSessionでセッション終了
- **202-208行目**: GetDocumentDiagnosticsAsyncで診断を収集
- **210-224行目**: EmitSolutionUpdateAsyncでデルタ発行

#### Step 4: デバッグセッションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DebuggingSession.cs | `src/Features/Core/Portable/EditAndContinue/DebuggingSession.cs` | セッション管理の中核 |

**主要処理フロー**:
- **129-160行目**: コンストラクタでセッション初期化
- **453-521行目**: GetDocumentDiagnosticsAsyncでドキュメント分析
- **523-585行目**: EmitSolutionUpdateAsyncでソリューション更新発行
- **587-654行目**: CommitSolutionUpdateで更新コミット

#### Step 5: 分析ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | AbstractEditAndContinueAnalyzer.cs | `src/Features/Core/Portable/EditAndContinue/AbstractEditAndContinueAnalyzer.cs` | 言語固有の分析基盤 |
| 5-2 | EditSession.cs | `src/Features/Core/Portable/EditAndContinue/EditSession.cs` | 編集セッション管理 |

### プログラム呼び出し階層図

```
EditAndContinueService
    │
    ├─ StartDebuggingSession
    │      └─ DebuggingSession (new)
    │              └─ EditSession (new)
    │
    ├─ GetDocumentDiagnosticsAsync
    │      └─ DebuggingSession.GetDocumentDiagnosticsAsync
    │              └─ EditSession.Analyses.GetDocumentAnalysisAsync
    │                      └─ IEditAndContinueAnalyzer.AnalyzeDocumentAsync
    │
    ├─ EmitSolutionUpdateAsync
    │      └─ DebuggingSession.EmitSolutionUpdateAsync
    │              └─ EditSession.EmitSolutionUpdateAsync
    │                      ├─ GetOrCreateEmitBaselines
    │                      └─ Compilation.EmitDifference
    │
    └─ CommitSolutionUpdate
           └─ DebuggingSession.CommitSolutionUpdate
                   └─ LastCommittedSolution.CommitChanges
```

### データフロー図

```
[入力]               [処理]                    [出力]

Solution ────────▶ EditAndContinueService
                        │
                        ▼
DebuggerService ──▶ DebuggingSession
                        │
                        ▼
Document変更 ─────▶ EditSession.Analyses
                        │
                        ▼
                  AbstractEditAndContinueAnalyzer
                        │
                        ├─ Rude Edit ───────▶ Diagnostics
                        │
                        ▼
Compilation ─────▶ EmitDifference ──────▶ ModuleUpdates
                        │
                        ▼
                  CommitSolutionUpdate ──▶ 更新確定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IEditAndContinueService.cs | `src/Features/Core/Portable/EditAndContinue/IEditAndContinueService.cs` | ソース | サービスインターフェース |
| EditAndContinueService.cs | `src/Features/Core/Portable/EditAndContinue/EditAndContinueService.cs` | ソース | サービス実装 |
| DebuggingSession.cs | `src/Features/Core/Portable/EditAndContinue/DebuggingSession.cs` | ソース | デバッグセッション管理 |
| EditSession.cs | `src/Features/Core/Portable/EditAndContinue/EditSession.cs` | ソース | 編集セッション管理 |
| CommittedSolution.cs | `src/Features/Core/Portable/EditAndContinue/CommittedSolution.cs` | ソース | コミット済みソリューション |
| AbstractEditAndContinueAnalyzer.cs | `src/Features/Core/Portable/EditAndContinue/AbstractEditAndContinueAnalyzer.cs` | ソース | 分析基盤 |
| RudeEditKind.cs | `src/Features/Core/Portable/EditAndContinue/RudeEditKind.cs` | ソース | Rude Edit種別 |
| RudeEditDiagnostic.cs | `src/Features/Core/Portable/EditAndContinue/RudeEditDiagnostic.cs` | ソース | Rude Edit診断 |
| ActiveStatement.cs | `src/Features/Core/Portable/EditAndContinue/ActiveStatement.cs` | ソース | アクティブステートメント |
| ActiveStatementSpan.cs | `src/Features/Core/Portable/EditAndContinue/ActiveStatementSpan.cs` | ソース | アクティブステートメントスパン |
| DocumentAnalysisResults.cs | `src/Features/Core/Portable/EditAndContinue/DocumentAnalysisResults.cs` | ソース | ドキュメント分析結果 |
| EmitSolutionUpdateResults.cs | `src/Features/Core/Portable/EditAndContinue/EmitSolutionUpdateResults.cs` | ソース | 更新発行結果 |
| SolutionUpdate.cs | `src/Features/Core/Portable/EditAndContinue/SolutionUpdate.cs` | ソース | ソリューション更新 |
| ModuleUpdate.cs | `src/Features/Core/Portable/EditAndContinue/ModuleUpdate.cs` | ソース | モジュール更新 |
| ProjectBaseline.cs | `src/Features/Core/Portable/EditAndContinue/ProjectBaseline.cs` | ソース | プロジェクトベースライン |
| EditAndContinueCapabilities.cs | `src/Features/Core/Portable/EditAndContinue/EditAndContinueCapabilities.cs` | ソース | EnC機能フラグ |
| EditAndContinueDiagnosticDescriptors.cs | `src/Features/Core/Portable/EditAndContinue/EditAndContinueDiagnosticDescriptors.cs` | ソース | 診断記述子 |
