# 機能設計書 83-デバッグ機能

## 概要

本ドキュメントは、Roslyn IDEにおけるデバッグ支援機能の設計を記載する。デバッグ機能は、ブレークポイントの解決、データTip情報の提供、近傍式の取得など、デバッガーと連携してデバッグ体験を向上させる機能群である。

### 本機能の処理概要

デバッグ機能は、Visual Studioデバッガーと連携して、開発者がコードをデバッグする際に必要な情報を提供する。具体的には、ブレークポイントの設定位置の解決、変数ホバー時のデータTip情報の生成、現在のコンテキストで評価可能な式の列挙などを行う。

**業務上の目的・背景**：効果的なデバッグは、ソフトウェア開発において不可欠である。開発者がブレークポイントを設定したり、変数の値を確認したりする際に、正確かつ迅速に情報を提供することで、バグの特定と修正を効率化する。

**機能の利用シーン**：
- 「関数にブレークポイントを設定」機能（Ctrl+B）で関数名を入力した場合
- デバッグ中に変数にマウスホバーしてデータTipを表示する場合
- 「ウォッチ」ウィンドウで現在のスコープの式候補を表示する場合
- デバッグ時にカーソル位置のシンボル情報を取得する場合

**主要な処理内容**：
1. ブレークポイント解決：テキスト表現からソースコード位置を特定
2. データTip情報取得：カーソル位置のシンボルに対する評価式とスパンを取得
3. 近傍式取得：現在位置周辺で評価可能な式のリストを生成
4. デバッグ位置情報取得：現在位置のメソッド名と行番号を取得

**関連システム・外部連携**：Visual Studioデバッガー

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | ブレークポイント設定、データTip表示 |
| - | 関数にブレークポイントを設定ダイアログ | 補助画面 | ブレークポイント解決 |
| - | ウォッチウィンドウ | 結果表示画面 | 近傍式の候補表示 |

## 機能種別

デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | ドキュメント範囲内 |
| text | string | No | ブレークポイント検索テキスト | - |

### 入力データソース

- エディタ上のカーソル位置
- ドキュメントの構文木とセマンティックモデル
- ユーザー入力（ブレークポイント検索テキスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BreakpointResolutionResult | BreakpointResolutionResult | ブレークポイント位置情報 |
| DebugDataTipInfo | DebugDataTipInfo | データTip情報（スパン、テキスト、種別） |
| DebugLocationInfo | DebugLocationInfo | デバッグ位置情報（メソッド名、行番号） |
| ProximityExpressions | IEnumerable&lt;string&gt; | 近傍式リスト |

### 出力先

Visual Studioデバッガー

## 処理フロー

### 処理シーケンス

```
1. ブレークポイント解決
   └─ テキスト解析 → シンボル検索 → 位置特定
2. データTip情報取得
   └─ カーソル位置 → トークン特定 → シンボル解決 → スパン計算
3. 位置情報取得
   └─ カーソル位置 → メソッド特定 → 行番号計算
```

### フローチャート

```mermaid
flowchart TD
    A[デバッガーからのリクエスト] --> B{リクエスト種別}
    B -->|ブレークポイント解決| C[テキスト解析]
    C --> D[シンボル検索]
    D --> E[ソース位置特定]
    E --> F[BreakpointResolutionResult返却]

    B -->|データTip| G[カーソル位置のトークン取得]
    G --> H[シンボル解決]
    H --> I{シンボルあり?}
    I -->|Yes| J[データTipスパン計算]
    I -->|No| K[空結果返却]
    J --> L[DebugDataTipInfo返却]

    B -->|位置情報| M[現在位置のメソッド特定]
    M --> N[行番号計算]
    N --> O[DebugLocationInfo返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | メソッド本体要件 | ブレークポイントはメソッド本体がある場所のみ | 抽象メソッドや外部メソッドは除外 |
| BR-02 | ソース要件 | ソースコードがある位置のみ対象 | メタデータシンボルは除外 |
| BR-03 | パラメータ数マッチング | 指定されたパラメータ数に一致するオーバーロードのみ | パラメータ数が指定された場合 |

### 計算ロジック

データTipスパンは、対象トークンの開始位置から終了位置を計算する。`var`キーワードの場合は推論された型名を返す。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 空結果 | シンボルが見つからない | 空のBreakpointResolutionResult返却 |
| - | 空結果 | データTip対象がない | IsDefaultのDebugDataTipInfo返却 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- データTip情報はホバー時にリアルタイムで提供（50ms以内推奨）
- ブレークポイント解決はダイアログ操作時に実行（1秒以内）

## セキュリティ考慮事項

特になし

## 備考

- 言語固有の実装（C#、VB）が必要
- ILanguageDebugInfoServiceインターフェースを実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DebugDataTipInfo.cs | `src/Features/Core/Portable/Debugging/DebugDataTipInfo.cs` | データTip情報の構造（Span, Text, Kind） |
| 1-2 | DebugLocationInfo.cs | `src/Features/Core/Portable/Debugging/DebugLocationInfo.cs` | 位置情報の構造（Name, LineOffset） |
| 1-3 | BreakpointResolutionResult.cs | `src/Features/Core/Portable/Debugging/BreakpointResolutionResult.cs` | ブレークポイント解決結果の構造 |
| 1-4 | DebugMode.cs | `src/Features/Core/Portable/Debugging/DebugMode.cs` | デバッグモードの列挙 |

**読解のコツ**: DebugDataTipInfoのKindフィールドはシンボルの種類（変数、プロパティ等）を表す。

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ILanguageDebugInfoService.cs | `src/Features/Core/Portable/Debugging/ILanguageDebugInfoService.cs` | 言語サービスの公開API |
| 2-2 | IBreakpointResolutionService.cs | `src/Features/Core/Portable/Debugging/IBreakpointResolutionService.cs` | ブレークポイント解決サービス |
| 2-3 | IProximityExpressionsService.cs | `src/Features/Core/Portable/Debugging/IProximityExpressionsService.cs` | 近傍式サービス |

**主要処理フロー**:
1. **ILanguageDebugInfoService.GetLocationInfoAsync**: 位置情報取得
2. **ILanguageDebugInfoService.GetDataTipInfoAsync**: データTip情報取得
3. **IBreakpointResolutionService.ResolveBreakpointsAsync**: ブレークポイント解決

#### Step 3: ブレークポイント解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractBreakpointResolver.cs | `src/Features/Core/Portable/Debugging/AbstractBreakpointResolver.cs` | ブレークポイント解決の共通ロジック |

**主要処理フロー**:
- **89-120行目**: DoAsyncでテキスト解析からシンボル検索まで実行
- **122-156行目**: FindMembersAsyncでシンボル検索
- **241-281行目**: IsApplicableで適用可能性を判定

#### Step 4: データTip取得を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractDataTipInfoGetter.cs | `src/Features/Core/Portable/Debugging/AbstractDataTipInfoGetter.cs` | データTip取得の共通ロジック |

### プログラム呼び出し階層図

```
Visual Studio Debugger
    │
    ├─ IBreakpointResolutionService.ResolveBreakpointsAsync
    │      └─ AbstractBreakpointResolver.DoAsync
    │              ├─ ParseText (言語固有)
    │              ├─ FindMembersAsync
    │              │      └─ GetAllTypesAsync
    │              ├─ IsApplicable
    │              └─ CreateBreakpoint
    │
    ├─ ILanguageDebugInfoService.GetDataTipInfoAsync
    │      └─ AbstractDataTipInfoGetter.GetInfoAsync
    │              └─ GetMemberAsync
    │
    └─ ILanguageDebugInfoService.GetLocationInfoAsync
           └─ 言語固有実装
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブレークポイント
テキスト ──────▶ AbstractBreakpointResolver ──▶ BreakpointResolutionResult
                     │
                     ▼
                SymbolFinder
                     │
                     ▼
                IsApplicable
                     │
                     ▼
カーソル位置 ───▶ AbstractDataTipInfoGetter ──▶ DebugDataTipInfo
                     │
                     ▼
                SemanticModel
                     │
                     ▼
                GetSymbolInfo
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ILanguageDebugInfoService.cs | `src/Features/Core/Portable/Debugging/ILanguageDebugInfoService.cs` | ソース | 言語サービスインターフェース |
| IBreakpointResolutionService.cs | `src/Features/Core/Portable/Debugging/IBreakpointResolutionService.cs` | ソース | ブレークポイント解決インターフェース |
| IProximityExpressionsService.cs | `src/Features/Core/Portable/Debugging/IProximityExpressionsService.cs` | ソース | 近傍式サービスインターフェース |
| AbstractBreakpointResolver.cs | `src/Features/Core/Portable/Debugging/AbstractBreakpointResolver.cs` | ソース | ブレークポイント解決基底クラス |
| AbstractBreakpointResolver.NameAndArity.cs | `src/Features/Core/Portable/Debugging/AbstractBreakpointResolver.NameAndArity.cs` | ソース | 名前とアリティのデータ構造 |
| AbstractDataTipInfoGetter.cs | `src/Features/Core/Portable/Debugging/AbstractDataTipInfoGetter.cs` | ソース | データTip取得基底クラス |
| DebugDataTipInfo.cs | `src/Features/Core/Portable/Debugging/DebugDataTipInfo.cs` | ソース | データTip情報構造体 |
| DebugLocationInfo.cs | `src/Features/Core/Portable/Debugging/DebugLocationInfo.cs` | ソース | 位置情報構造体 |
| BreakpointResolutionResult.cs | `src/Features/Core/Portable/Debugging/BreakpointResolutionResult.cs` | ソース | ブレークポイント解決結果 |
| DebugMode.cs | `src/Features/Core/Portable/Debugging/DebugMode.cs` | ソース | デバッグモード列挙 |
| DebugInformationReaderProvider.cs | `src/Features/Core/Portable/Debugging/DebugInformationReaderProvider.cs` | ソース | デバッグ情報リーダー |
