# 機能設計書 85-スタックトレース探索

## 概要

本ドキュメントは、Roslyn IDEにおけるスタックトレース探索機能の設計を記載する。この機能は、例外スタックトレースや呼び出し履歴テキストを解析し、対応するソースコード位置へのナビゲーションを提供する。

### 本機能の処理概要

スタックトレース探索機能は、コピーされたスタックトレーステキストを解析し、各フレームに対応するソースコードの定義へナビゲーションする機能を提供する。Visual StudioのStackTrace Explorerツールウィンドウで使用される。

**業務上の目的・背景**：アプリケーションで例外が発生した際、スタックトレースはエラーの原因を特定するための重要な情報である。しかし、スタックトレースは単なるテキストであり、対応するソースコードを手動で探すのは手間がかかる。本機能は、スタックトレーステキストを自動解析し、ソースコードへの直接ナビゲーションを提供することで、デバッグ効率を向上させる。

**機能の利用シーン**：
- 例外発生時にスタックトレースをコピーしてStackTrace Explorerに貼り付けた場合
- ログファイルからスタックトレースを取得してソースコードを確認したい場合
- 本番環境のクラッシュレポートを分析したい場合

**主要な処理内容**：
1. スタックトレーステキストの解析（各行をフレームとして解析）
2. メソッドシグネチャからシンボルの検索
3. ソースファイルと行番号のマッチング
4. 定義位置へのナビゲーション

**関連システム・外部連携**：Remote Workspaces（OOP）

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | StackTrace Explorer | 主画面 | スタックトレースの表示とナビゲーション |
| - | コードエディタ | 遷移先画面 | 定義位置へのナビゲーション |

## 機能種別

デバッグ支援 / コードナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| callstack | string | Yes | スタックトレーステキスト | 空文字列でないこと |
| solution | Solution | Yes | 検索対象ソリューション | null不可 |

### 入力データソース

- ユーザーが貼り付けたスタックトレーステキスト
- ソリューション内のドキュメント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| StackTraceAnalysisResult | StackTraceAnalysisResult | 解析結果（フレームリスト） |
| DefinitionItem | DefinitionItem | シンボル定義情報 |
| TextDocument | TextDocument | 対応するドキュメント |
| line | int | 行番号 |

### 出力先

StackTrace Explorerウィンドウ

## 処理フロー

### 処理シーケンス

```
1. スタックトレーステキスト入力
   └─ AnalyzeAsyncでテキストを解析
2. 行ごとにフレーム解析
   └─ 複数のパーサーを順に試行
3. ファイルパスと行番号の抽出
   └─ ソリューション内のドキュメントを検索
4. シンボル定義の検索
   └─ TryFindDefinitionAsyncで定義を特定
5. ナビゲーション
   └─ DefinitionItemを使用して定義へ移動
```

### フローチャート

```mermaid
flowchart TD
    A[スタックトレーステキスト入力] --> B[HTMLデコード]
    B --> C[行分割]
    C --> D{各行を処理}
    D --> E[空白トリム]
    E --> F{パーサーで解析}
    F -->|DotnetStackFrameParser| G[.NETスタックフレーム解析]
    F -->|VSDebugCallstackParser| H[VSデバッグコールスタック解析]
    F -->|DefaultStackParser| I[デフォルト解析]
    G --> J[ParsedStackFrame生成]
    H --> J
    I --> J
    J --> D
    D -->|全行処理完了| K[StackTraceAnalysisResult返却]
    K --> L{ナビゲーションリクエスト}
    L --> M[TryFindDefinitionAsync]
    M --> N{RemoteHost利用可能?}
    N -->|Yes| O[リモートサービス呼び出し]
    N -->|No| P[ローカル処理]
    O --> Q[DefinitionItem返却]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | パーサー優先順位 | DotnetStackFrameParser → VSDebugCallstackParser → DefaultStackParser | 最初に成功したパーサーの結果を使用 |
| BR-02 | ファイル名マッチング | 完全パス一致 → ファイル名のみ一致 | パスが見つからない場合はファイル名で検索 |
| BR-03 | HTMLデコード | スタックトレースのHTMLエスケープを解除 | ActivityLog.xml等からのコピー対応 |

### 計算ロジック

行番号は1ベースでソースドキュメントと対応付ける。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 解析失敗 | スタックトレース形式が不正 | 解析できない行はIgnoredFrameとして処理 |
| - | シンボル未発見 | ソリューションにシンボルがない | ナビゲーション不可として表示 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- スタックトレース解析は1秒以内
- シンボル検索はリモートワークスペースで並列処理

## セキュリティ考慮事項

特になし

## 備考

- 複数のスタックトレース形式をサポート
- Remote Workspacesを使用して大規模ソリューションでも高速に動作

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ParsedFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/ParsedFrame.cs` | 解析済みフレームの基底クラス |
| 1-2 | ParsedStackFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/ParsedStackFrame.cs` | 解析成功フレーム |
| 1-3 | IgnoredFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/IgnoredFrame.cs` | 無視されたフレーム |
| 1-4 | StackTraceAnalysisResult.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalysisResult.cs` | 解析結果全体 |

**読解のコツ**: ParsedFrameは抽象クラスで、解析成功（ParsedStackFrame）と解析失敗（IgnoredFrame）を区別する。

#### Step 2: 解析処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StackTraceAnalyzer.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalyzer.cs` | スタックトレース解析のエントリーポイント |
| 2-2 | IStackFrameParser.cs | `src/Features/Core/Portable/StackTraceExplorer/IStackFrameParser.cs` | パーサーインターフェース |
| 2-3 | DotnetStackFrameParser.cs | `src/Features/Core/Portable/StackTraceExplorer/DotnetStackFrameParser.cs` | .NETスタックフレームパーサー |

**主要処理フロー**:
- **24行目**: 複数のパーサーを配列で保持
- **26-29行目**: AnalyzeAsyncでテキストを解析
- **32-68行目**: Parseメソッドで行ごとに解析
- **40行目**: HTMLデコードを適用
- **58-64行目**: パーサーを順に試行

#### Step 3: サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StackTraceExplorerService.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceExplorerService.cs` | サービス実装 |
| 3-2 | IStackTraceExplorerService.cs | `src/Features/Core/Portable/StackTraceExplorer/IStackTraceExplorerService.cs` | サービスインターフェース |

**主要処理フロー**:
- **27-41行目**: GetDocumentAndLineでファイルと行番号を取得
- **43-73行目**: TryFindDefinitionAsyncでシンボル定義を検索
- **75-117行目**: GetFileMatchesでファイルマッチング

#### Step 4: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StackTraceExplorerUtilities.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceExplorerUtilities.cs` | 共通ユーティリティ |

### プログラム呼び出し階層図

```
StackTraceExplorerService
    │
    ├─ GetDocumentAndLine
    │      └─ GetFileMatches
    │              ├─ solution.GetDocumentIdsWithFilePath
    │              └─ Path.GetFileName でマッチング
    │
    ├─ TryFindDefinitionAsync
    │      ├─ RemoteHostClient.TryGetClientAsync
    │      │      └─ IRemoteStackTraceExplorerService.TryFindDefinitionAsync
    │      │
    │      └─ StackTraceExplorerUtilities.GetDefinitionAsync
    │              └─ SymbolFinder.FindSourceDefinitionAsync
    │
    └─ StackTraceAnalyzer.AnalyzeAsync
           ├─ WebUtility.HtmlDecode
           ├─ SplitLines
           └─ s_parsers.TryParseLine
                  ├─ DotnetStackFrameParser
                  ├─ VSDebugCallstackParser
                  └─ DefaultStackParser
```

### データフロー図

```
[入力]               [処理]                    [出力]

スタックトレース
テキスト ──────▶ StackTraceAnalyzer.AnalyzeAsync
                        │
                        ▼
                  IStackFrameParser.TryParseLine
                        │
                        ▼
                  ParsedFrame[] ───────▶ StackTraceAnalysisResult
                        │
                        ▼
Solution ────────▶ StackTraceExplorerService
                        │
                        ├─ GetDocumentAndLine ──▶ (TextDocument, line)
                        │
                        └─ TryFindDefinitionAsync ──▶ DefinitionItem
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IStackTraceExplorerService.cs | `src/Features/Core/Portable/StackTraceExplorer/IStackTraceExplorerService.cs` | ソース | サービスインターフェース |
| StackTraceExplorerService.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceExplorerService.cs` | ソース | サービス実装 |
| StackTraceAnalyzer.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalyzer.cs` | ソース | スタックトレース解析 |
| StackTraceAnalysisResult.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceAnalysisResult.cs` | ソース | 解析結果 |
| ParsedFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/ParsedFrame.cs` | ソース | 解析済みフレーム基底 |
| ParsedStackFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/ParsedStackFrame.cs` | ソース | 解析成功フレーム |
| IgnoredFrame.cs | `src/Features/Core/Portable/StackTraceExplorer/IgnoredFrame.cs` | ソース | 無視フレーム |
| IStackFrameParser.cs | `src/Features/Core/Portable/StackTraceExplorer/IStackFrameParser.cs` | ソース | パーサーインターフェース |
| DotnetStackFrameParser.cs | `src/Features/Core/Portable/StackTraceExplorer/DotnetStackFrameParser.cs` | ソース | .NETパーサー |
| VSDebugCallstackParser.cs | `src/Features/Core/Portable/StackTraceExplorer/VSDebugCallstackParser.cs` | ソース | VSデバッグパーサー |
| DefaultStackParser.cs | `src/Features/Core/Portable/StackTraceExplorer/DefaultStackParser.cs` | ソース | デフォルトパーサー |
| StackTraceExplorerUtilities.cs | `src/Features/Core/Portable/StackTraceExplorer/StackTraceExplorerUtilities.cs` | ソース | ユーティリティ |
| StackFrameSymbolPart.cs | `src/Features/Core/Portable/StackTraceExplorer/StackFrameSymbolPart.cs` | ソース | シンボルパート列挙 |
