# 機能設計書 86-値追跡

## 概要

本ドキュメントは、Roslyn IDEにおける値追跡（Value Tracking）機能の設計を記載する。この機能は、変数やパラメータの値がどこから来ているかを追跡し、データフローを可視化する。

### 本機能の処理概要

値追跡機能は、選択した変数、プロパティ、フィールド、またはパラメータの値の由来を遡って追跡する。これにより、開発者はデータがどこで設定され、どのように伝播しているかを理解できる。

**業務上の目的・背景**：複雑なコードベースでは、変数の値がどこで設定されているかを把握するのが困難な場合がある。特に、複数のメソッドを経由して値が渡される場合、手動での追跡は時間がかかりエラーが発生しやすい。本機能は、この追跡を自動化し、開発者がデータフローを素早く理解できるようにする。

**機能の利用シーン**：
- 変数の値がどこで設定されているかを確認したい場合
- パラメータがどのように呼び出し元から渡されているかを追跡したい場合
- メソッドの戻り値がどこから来ているかを調べたい場合
- データフローに関連するバグを調査したい場合

**主要な処理内容**：
1. 選択されたシンボルの検出（変数、プロパティ、フィールド、パラメータ）
2. シンボルの宣言と代入箇所の収集
3. 再帰的なデータソース追跡
4. 追跡結果のツリー構造での表示

**関連システム・外部連携**：Remote Workspaces（OOP）、Find References

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | 追跡開始位置の選択 |
| - | Value Tracking Tool Window | 結果表示画面 | 追跡結果のツリー表示 |

## 機能種別

コード分析 / データフロー追跡

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| selection | TextSpan | Yes | 選択範囲 | ドキュメント範囲内 |
| document | Document | Yes | 対象ドキュメント | null不可 |
| previousTrackedItem | ValueTrackedItem | No | 親追跡項目（再帰追跡時） | - |

### 入力データソース

- エディタ上の選択位置
- ドキュメントの構文木とセマンティックモデル
- シンボル参照情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ValueTrackedItems | ImmutableArray&lt;ValueTrackedItem&gt; | 追跡結果リスト |

### 出力先

Value Tracking Tool Window

## 処理フロー

### 処理シーケンス

```
1. 選択位置からシンボル取得
   └─ GetSelectedSymbolAsyncでシンボルを特定
2. シンボル種別による処理分岐
   └─ 変数/プロパティ/フィールド/パラメータで異なる処理
3. 宣言位置の追跡
   └─ TrackVariableDefinitionsAsyncで初期化子を収集
4. 参照位置の追跡
   └─ TrackVariableReferencesAsyncで代入を収集
5. 再帰的追跡（オプション）
   └─ TrackValueSourceAsyncで子項目を追跡
```

### フローチャート

```mermaid
flowchart TD
    A[選択位置] --> B[GetSelectedSymbolAsync]
    B --> C{シンボル種別}
    C -->|IPropertySymbol| D[プロパティ追跡]
    C -->|IFieldSymbol| E[フィールド追跡]
    C -->|ILocalSymbol| F[ローカル変数追跡]
    C -->|IParameterSymbol| G[パラメータ追跡]
    C -->|IMethodSymbol| H[メソッド戻り値追跡]
    D --> I[TrackVariableDefinitionsAsync]
    E --> I
    F --> I
    I --> J[TrackVariableReferencesAsync]
    J --> K[ValueTrackedItem生成]
    G --> L{宣言位置?}
    L -->|Yes| I
    L -->|No| M[TrackParameterSymbolAsync]
    M --> K
    H --> N[TrackMethodSymbolAsync]
    N --> K
    K --> O[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 対象シンボル | プロパティ、フィールド、ローカル変数、パラメータが対象 | メソッドシンボルは戻り値追跡 |
| BR-02 | 代入追跡 | 左辺値への代入のみ追跡 | 右辺値の場合は代入元を探索 |
| BR-03 | Ref/Out追跡 | RefまたはOutパラメータは特別処理 | メソッド内の代入を追跡 |
| BR-04 | 親パラメータ判定 | 前回追跡のメソッドのパラメータは再追跡しない | 無限ループ防止 |

### 計算ロジック

追跡は再帰的に行われ、各追跡項目の親子関係をツリー構造で表現する。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 空結果 | 追跡対象が見つからない | 空のリストを返却 |
| - | シンボル解決失敗 | シンボルが存在しない | 追跡をスキップ |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- 初期追跡は500ms以内
- 子項目の展開は200ms以内
- Remote Workspacesを使用して並列処理

## セキュリティ考慮事項

特になし

## 備考

- Find Referencesインフラストラクチャを再利用
- ログ機能でパフォーマンス測定可能（FunctionId.ValueTracking_TrackValueSource）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ValueTrackedItem.cs | `src/Features/Core/Portable/ValueTracking/ValueTrackedItem.cs` | 追跡項目の構造 |
| 1-2 | SerializableValueTrackedItem.cs | `src/Features/Core/Portable/ValueTracking/SerializableValueTrackedItem.cs` | シリアライズ用構造 |

**読解のコツ**: ValueTrackedItemは親子関係を持つツリー構造で、Parentプロパティで親項目を参照する。

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IValueTrackingService.cs | `src/Features/Core/Portable/ValueTracking/IValueTrackingService.cs` | サービスの公開API |

#### Step 3: サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ValueTrackingService.cs | `src/Features/Core/Portable/ValueTracking/ValueTrackingService.cs` | サービス実装 |

**主要処理フロー**:
- **27-55行目**: TrackValueSourceAsync（初期追跡）
- **32-33行目**: RemoteHostClient使用判定
- **52-54行目**: ローカル処理フォールバック
- **57-85行目**: TrackValueSourceAsync（子項目追跡）

#### Step 4: 追跡ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ValueTracker.cs | `src/Features/Core/Portable/ValueTracking/ValueTracker.cs` | 追跡の中核ロジック |

**主要処理フロー**:
- **19-71行目**: TrackValueSourceAsync（選択位置からの追跡）
- **25行目**: GetSelectedSymbolAsyncでシンボル取得
- **28-33行目**: シンボル種別チェック
- **42-52行目**: 宣言位置と代入の追跡
- **73-136行目**: TrackValueSourceAsync（再帰追跡）
- **164-172行目**: TrackVariableReferencesAsync
- **188-196行目**: TrackMethodSymbolAsync

#### Step 5: オペレーションコレクターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ValueTracker.OperationCollector.cs | `src/Features/Core/Portable/ValueTracking/ValueTracker.OperationCollector.cs` | 操作収集ロジック |

### プログラム呼び出し階層図

```
ValueTrackingService.TrackValueSourceAsync
    │
    ├─ RemoteHostClient.TryInvokeAsync
    │      └─ IRemoteValueTrackingService.TrackValueSourceAsync
    │
    └─ ValueTracker.TrackValueSourceAsync
           │
           ├─ GetSelectedSymbolAsync
           │
           ├─ (シンボル種別による分岐)
           │      ├─ IPropertySymbol/IFieldSymbol/ILocalSymbol
           │      │      ├─ TrackVariableDefinitionsAsync
           │      │      └─ TrackVariableReferencesAsync
           │      │
           │      ├─ IParameterSymbol
           │      │      ├─ TrackVariableReferencesAsync
           │      │      └─ TrackParameterSymbolAsync
           │      │              └─ SymbolFinder.FindReferencesAsync
           │      │
           │      └─ IMethodSymbol
           │             └─ TrackMethodSymbolAsync
           │
           └─ ValueTrackingProgressCollector.TryReportAsync
```

### データフロー図

```
[入力]               [処理]                    [出力]

選択位置 ───────▶ GetSelectedSymbolAsync
                        │
                        ▼
Document ────────▶ シンボル解決
                        │
                        ▼
SemanticModel ──▶ TrackVariableDefinitionsAsync
                        │                 │
                        ▼                 ▼
SymbolFinder ───▶ TrackVariableReferencesAsync ──▶ ImmutableArray<ValueTrackedItem>
                        │
                        ▼
                  OperationCollector
                        │
                        ├─ IAssignmentOperation
                        ├─ IReturnOperation
                        └─ IArgumentOperation
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IValueTrackingService.cs | `src/Features/Core/Portable/ValueTracking/IValueTrackingService.cs` | ソース | サービスインターフェース |
| ValueTrackingService.cs | `src/Features/Core/Portable/ValueTracking/ValueTrackingService.cs` | ソース | サービス実装 |
| ValueTracker.cs | `src/Features/Core/Portable/ValueTracking/ValueTracker.cs` | ソース | 追跡ロジック本体 |
| ValueTracker.OperationCollector.cs | `src/Features/Core/Portable/ValueTracking/ValueTracker.OperationCollector.cs` | ソース | 操作収集 |
| ValueTracker.FindReferencesProgress.cs | `src/Features/Core/Portable/ValueTracking/ValueTracker.FindReferencesProgress.cs` | ソース | 参照検索プログレス |
| ValueTrackedItem.cs | `src/Features/Core/Portable/ValueTracking/ValueTrackedItem.cs` | ソース | 追跡項目データ構造 |
| ValueTrackingProgressCollector.cs | `src/Features/Core/Portable/ValueTracking/ValueTrackingProgressCollector.cs` | ソース | プログレス収集 |
| SerializableValueTrackedItem.cs | `src/Features/Core/Portable/ValueTracking/SerializableValueTrackedItem.cs` | ソース | シリアライズ用構造 |
