# 機能設計書 88-逆コンパイルソース

## 概要

本ドキュメントは、Roslyn IDEにおける逆コンパイルソース（Decompiled Source）機能の設計を記載する。この機能は、コンパイル済みアセンブリからILを逆コンパイルし、読み取り可能なC#/VBソースコードとして表示する。

### 本機能の処理概要

逆コンパイルソース機能は、外部アセンブリのシンボルに対して、ILCSpyなどの逆コンパイラを使用してILコードからソースコードを復元する。メタデータシグネチャのみの表示よりも、実装の詳細を含む完全なソースコードを提供する。

**業務上の目的・背景**：外部ライブラリの動作を理解したり、バグを調査したりする際に、実装コードを確認できることは非常に有益である。ソースコードが公開されていないライブラリでも、逆コンパイルによって実装を確認できる。本機能は、この逆コンパイル処理をIDEに統合し、シームレスなコード探索を可能にする。

**機能の利用シーン**：
- 外部ライブラリの内部実装を確認したい場合
- フレームワークの動作を詳しく調べたい場合
- NuGetパッケージのバグを調査したい場合
- ソースリンクやPDBソースが利用できない場合

**主要な処理内容**：
1. アセンブリの位置特定
2. ILCSpyを使用した逆コンパイル
3. 生成されたソースコードのフォーマット
4. 一時ファイルへの出力とエディタでの表示

**関連システム・外部連携**：
- ILSpy (ICSharpCode.Decompiler)
- メタデータソース表示機能

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | 定義へ移動の実行 |
| - | 逆コンパイルソースビュー | 結果表示画面 | 生成されたソースの表示 |
| - | オプション設定 | 設定画面 | 逆コンパイル有効/無効の切り替え |

## 機能種別

コードナビゲーション / ソース表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| symbolCompilation | Compilation | Yes | シンボルのコンパイル情報 | null不可 |
| symbol | ISymbol | Yes | 対象シンボル | null不可 |
| metadataReference | MetadataReference | No | メタデータ参照 | - |
| assemblyLocation | string | No | アセンブリのパス | - |
| formattingOptions | SyntaxFormattingOptions | No | フォーマットオプション | - |

### 入力データソース

- アセンブリファイル
- PDBファイル（存在する場合）
- メタデータ参照

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Document | Document? | 逆コンパイルされたソースを含むドキュメント |

### 出力先

一時フォルダ内のソースファイル

## 処理フロー

### 処理シーケンス

```
1. アセンブリ位置の特定
   └─ MetadataReferenceからアセンブリパスを取得
2. 逆コンパイラの初期化
   └─ ICSharpCode.Decompilerを使用
3. シンボルの逆コンパイル
   └─ 型全体を逆コンパイル
4. ソースコードの生成
   └─ ドキュメントにソースを追加
5. フォーマットと出力
   └─ SyntaxFormattingOptionsでフォーマット
```

### フローチャート

```mermaid
flowchart TD
    A[定義へ移動実行] --> B{逆コンパイル有効?}
    B -->|No| C[メタデータソース表示へ]
    B -->|Yes| D[アセンブリ位置特定]
    D --> E{アセンブリ存在?}
    E -->|No| C
    E -->|Yes| F[ICSharpCode.Decompiler初期化]
    F --> G[型の逆コンパイル]
    G --> H{成功?}
    H -->|No| I[null返却]
    H -->|Yes| J[ソースコード生成]
    J --> K[フォーマット適用]
    K --> L[Document返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | オプション依存 | ユーザー設定で逆コンパイルを有効化する必要あり | デフォルトは無効 |
| BR-02 | 型単位逆コンパイル | シンボルを含む型全体を逆コンパイル | 個別メンバーではなく型全体 |
| BR-03 | フォールバック | 逆コンパイル失敗時はメタデータソースにフォールバック | エラー時 |

### 計算ロジック

逆コンパイラの設定は、最新のC#言語バージョンと読みやすさを優先する設定を使用。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 逆コンパイル失敗 | ILが無効またはサポート外 | nullを返却、フォールバック |
| - | アセンブリ読み込み失敗 | ファイルアクセス不可 | nullを返却 |

### リトライ仕様

なし（フォールバックで対応）

## トランザクション仕様

なし

## パフォーマンス要件

- 逆コンパイル処理は3秒以内
- 大規模な型でも5秒以内

## セキュリティ考慮事項

- 逆コンパイル機能は明示的に有効化が必要
- 一時ファイルは読み取り専用

## 備考

- ICSharpCode.Decompilerライブラリを使用
- 逆コンパイル結果はオリジナルソースと完全一致しない場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IDecompiledSourceService.cs | `src/Features/Core/Portable/DecompiledSource/IDecompiledSourceService.cs` | サービスの公開API |

**主要処理フロー**:
- **26行目**: AddSourceToAsyncでソース追加（document, symbolCompilation, symbol, metadataReference, assemblyLocation, formattingOptions）

**読解のコツ**: 戻り値がDocument?なのは、逆コンパイル失敗時にnullを返すため。

#### Step 2: プロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DecompiledSourceService.cs | `src/Features/CSharp/Portable/DecompiledSource/DecompiledSourceService.cs` | C#用実装 |

#### Step 3: メタデータソースとの統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MetadataAsSourceFileService.cs | `src/Features/Core/Portable/MetadataAsSource/MetadataAsSourceFileService.cs` | プロバイダーチェーン |

**主要処理フロー**:
プロバイダーは以下の順序で試行される:
1. PdbSourceDocumentProvider
2. DecompiledSourceProvider
3. MetadataAsSourceProvider（フォールバック）

### プログラム呼び出し階層図

```
MetadataAsSourceFileService.GetGeneratedFileAsync
    │
    └─ IMetadataAsSourceFileProvider (順次試行)
           │
           ├─ PdbSourceDocumentProvider (優先)
           │
           ├─ DecompiledSourceProvider
           │      │
           │      └─ IDecompiledSourceService.AddSourceToAsync
           │              │
           │              └─ CSharpDecompiledSourceService
           │                      ├─ ICSharpCode.Decompiler初期化
           │                      ├─ Decompiler.DecompileType
           │                      └─ ドキュメント生成
           │
           └─ MetadataAsSourceProvider (フォールバック)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ISymbol ─────────▶ GetGeneratedFileAsync
                        │
                        ▼
MetadataReference ──▶ アセンブリ位置特定
                        │
                        ▼
AssemblyPath ────────▶ ICSharpCode.Decompiler
                        │
                        ▼
                  DecompileType
                        │
                        ▼
                  ソース文字列
                        │
                        ▼
FormattingOptions ──▶ Document生成 ──▶ Document
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IDecompiledSourceService.cs | `src/Features/Core/Portable/DecompiledSource/IDecompiledSourceService.cs` | ソース | サービスインターフェース |
| CSharpDecompiledSourceService.cs | `src/Features/CSharp/Portable/DecompiledSource/CSharpDecompiledSourceService.cs` | ソース | C#逆コンパイル実装 |
| AssemblyResolver.cs | `src/Features/CSharp/Portable/DecompiledSource/AssemblyResolver.cs` | ソース | アセンブリ解決 |
