# 機能設計書 9-リモートワークスペース

## 概要

本ドキュメントは、Roslynプラットフォームにおけるリモートワークスペースの機能設計について記述する。リモートワークスペースは、Visual Studioなどのホストプロセスから別プロセス (ServiceHub) でRoslyn機能を実行するための分散ワークスペース基盤を提供する。

### 本機能の処理概要

**業務上の目的・背景**：リモートワークスペースは、Visual StudioのUIプロセスと分離されたプロセスでRoslyn機能を実行することで、IDEの応答性を維持しながら計算集約的な言語サービス機能を提供する。これにより、コード解析、リファクタリング、IntelliSenseなどの機能がバックグラウンドで効率的に実行される。また、プロセス分離によるメモリ管理の最適化も実現している。

**機能の利用シーン**：
- Visual StudioでのバックグラウンドIntelliSense処理
- リモートコード解析の実行
- 診断分析のアウトオブプロセス実行
- Find All References等の検索機能
- シンボルナビゲーション

**主要な処理内容**：
1. ServiceHubを通じたリモートサービス接続
2. ソリューションアセットの同期
3. リモートでのコンパイル・解析実行
4. 結果のホストプロセスへの返却
5. キャッシュとメモリ管理

**関連システム・外部連携**：
- Visual Studio ServiceHub
- ワークスペース基盤
- 診断アナライザー

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | バックエンドサービスのため画面は存在しない |

## 機能種別

分散処理基盤 / IPC

## 入力仕様

### リモートサービス呼び出し

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| PinnedSolutionInfo | Checksum | Yes | ソリューション識別子 | null不可 |
| DocumentId | DocumentId | Yes | 対象ドキュメント | null不可 |
| cancellationToken | CancellationToken | No | キャンセルトークン | - |

### 入力データソース

- ホストプロセスのWorkspace/Solution
- SolutionAssetStorageからのアセット

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 解析結果 | 各サービス固有 | リモート実行結果 |
| 診断 | ImmutableArray<Diagnostic> | 検出された診断 |

### 出力先

- ホストプロセスへのコールバック

## 処理フロー

### 処理シーケンス

```
1. ホストプロセスからリモートサービス呼び出し
   └─ BrokeredServiceConnection経由

2. ソリューションアセット同期
   └─ PinnedSolutionInfoからチェックサム取得
   └─ SolutionAssetProviderからアセット取得
   └─ RemoteWorkspaceにソリューション再構築

3. リモートサービス実行
   └─ 対象ドキュメント/シンボルの解析
   └─ 結果の生成

4. 結果返却
   └─ シリアライズしてホストへ返送
```

### フローチャート

```mermaid
flowchart TD
    A[ホストプロセス] --> B[BrokeredServiceConnection]
    B --> C[ServiceHub Process]
    C --> D[リモートサービス呼び出し]
    D --> E{ソリューション同期必要?}
    E -->|Yes| F[SolutionAssetProvider]
    E -->|No| G[キャッシュ使用]
    F --> H[アセット取得]
    H --> I[RemoteWorkspace更新]
    G --> I
    I --> J[サービス実行]
    J --> K[結果シリアライズ]
    K --> L[ホストへ返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | アセットキャッシュ | SolutionAssetCacheでアセットをキャッシュ | 常時 |
| BR-02 | チェックサム同期 | チェックサムで変更を検出して差分同期 | アセット取得時 |
| BR-03 | ソリューションキャッシュ | RemoteSolutionCacheでソリューションをキャッシュ | 常時 |

### ServiceDescriptor

主要なリモートサービス:
- RemoteDiagnosticAnalyzerService: 診断分析
- RemoteSemanticClassificationService: セマンティック分類
- RemoteSymbolFinderService: シンボル検索
- RemoteRenamerService: 名前変更
- RemoteCompletionService: コード補完

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ConnectionLost | 接続エラー | サービス接続断 | 再接続 |
| OperationCanceledException | キャンセル | 処理中断 | 正常終了 |
| RemoteInvocationException | リモートエラー | リモート側例外 | ログ記録 |

### リトライ仕様

接続エラー時は再接続を試行。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- SolutionAssetCacheによる効率的なキャッシュ
- 差分同期によるデータ転送最小化
- 並列サービス実行

## セキュリティ考慮事項

- プロセス分離によるセキュリティ境界
- ServiceBrokerによる認証

## 備考

- RemoteWorkspaceはServiceHubプロセス内で動作
- ServiceHubRemoteHostClientがホスト側のクライアント

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: リモートサービス基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ServiceDescriptors.cs | `src/Workspaces/Remote/Core/ServiceDescriptors.cs` | サービス定義 |
| 1-2 | BrokeredServiceDescriptors.cs | `src/Workspaces/Remote/Core/BrokeredServiceDescriptors.cs` | ブローカーサービス |

#### Step 2: クライアント側を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ServiceHubRemoteHostClient.cs | `src/Workspaces/Remote/Core/ServiceHubRemoteHostClient.cs` | リモートホストクライアント |
| 2-2 | BrokeredServiceConnection.cs | `src/Workspaces/Remote/Core/BrokeredServiceConnection.cs` | サービス接続 |

#### Step 3: サービス側を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RemoteWorkspace.cs | `src/Workspaces/Remote/ServiceHub/Host/RemoteWorkspace.cs` | リモートワークスペース |
| 3-2 | SolutionAssetCache.cs | `src/Workspaces/Remote/ServiceHub/Host/SolutionAssetCache.cs` | アセットキャッシュ |

### プログラム呼び出し階層図

```
ホストプロセス (Visual Studio)
    │
    ├─ ServiceHubRemoteHostClient
    │      │
    │      └─ BrokeredServiceConnection
    │             │
    │             └─ IPC (名前付きパイプ等)
    │
    ▼
ServiceHubプロセス
    │
    ├─ RemoteWorkspaceManager
    │      │
    │      └─ RemoteWorkspace
    │             │
    │             ├─ SolutionAssetCache
    │             │
    │             └─ AssetProvider
    │
    └─ リモートサービス実装
           │
           ├─ RemoteDiagnosticAnalyzerService
           ├─ RemoteSemanticClassificationService
           ├─ RemoteSymbolFinderService
           └─ ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RemoteWorkspace.cs | `src/Workspaces/Remote/ServiceHub/Host/RemoteWorkspace.cs` | ソース | リモートワークスペース |
| RemoteWorkspaceManager.cs | `src/Workspaces/Remote/ServiceHub/Host/RemoteWorkspaceManager.cs` | ソース | ワークスペース管理 |
| SolutionAssetCache.cs | `src/Workspaces/Remote/ServiceHub/Host/SolutionAssetCache.cs` | ソース | アセットキャッシュ |
| SolutionAssetProvider.cs | `src/Workspaces/Remote/Core/SolutionAssetProvider.cs` | ソース | アセットプロバイダー |
| ServiceHubRemoteHostClient.cs | `src/Workspaces/Remote/Core/ServiceHubRemoteHostClient.cs` | ソース | リモートクライアント |
| BrokeredServiceConnection.cs | `src/Workspaces/Remote/Core/BrokeredServiceConnection.cs` | ソース | サービス接続 |
| ServiceDescriptors.cs | `src/Workspaces/Remote/Core/ServiceDescriptors.cs` | ソース | サービス定義 |
