# 機能設計書 90-Language Server Protocol

## 概要

本ドキュメントは、Roslyn IDEにおけるLanguage Server Protocol（LSP）機能の設計を記載する。LSP機能は、標準化されたプロトコルを通じて、Visual Studio以外のエディタやIDEにRoslynの言語サービスを提供する。

### 本機能の処理概要

Language Server Protocol機能は、LSP仕様に準拠したサーバーを実装し、Visual Studio Code、Sublime Text、Emacsなど様々なエディタにRoslynの言語機能（コード補完、定義へ移動、リファクタリング等）を提供する。

**業務上の目的・背景**：言語サービスの開発は複雑で工数がかかる。LSPは、言語サーバーとエディタの間の通信を標準化することで、一つの言語サーバー実装で複数のエディタをサポートできるようにする。Roslynは.NETの参照実装としてLSPサーバーを提供し、C#/VBの言語サービスを様々な環境で利用可能にする。

**機能の利用シーン**：
- Visual Studio Codeで.NET開発を行う場合
- C# Dev Kitを使用する場合
- その他のLSP対応エディタで.NET開発を行う場合
- カスタムIDEやツールでRoslynを利用する場合

**主要な処理内容**：
1. LSPリクエストの受信とルーティング
2. ドキュメント同期（テキスト変更の追跡）
3. 言語機能の提供（補完、診断、ホバー等）
4. コードアクションとリファクタリング
5. セマンティックトークン（シンタックスハイライト）

**関連システム・外部連携**：
- Visual Studio Code
- C# Dev Kit
- Razor Language Server

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | VS Code | クライアント | 各種言語機能の呼び出し |
| - | エディタ | 主画面 | コード編集、補完、ナビゲーション |

## 機能種別

言語サービス / 通信プロトコル

## 入力仕様

### 入力パラメータ

LSPプロトコルに従った各種リクエストメッセージ。代表的なものを以下に示す。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TextDocumentPositionParams | TextDocumentPositionParams | - | ドキュメント位置パラメータ | LSP仕様準拠 |
| CompletionParams | CompletionParams | - | 補完リクエストパラメータ | LSP仕様準拠 |
| HoverParams | HoverParams | - | ホバーリクエストパラメータ | LSP仕様準拠 |

### 入力データソース

- LSPクライアントからのJSON-RPCリクエスト
- エディタのドキュメントバッファ

## 出力仕様

### 出力データ

LSPプロトコルに従った各種レスポンスメッセージ。代表的なものを以下に示す。

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionList | CompletionList | 補完候補リスト |
| Hover | Hover | ホバー情報 |
| Location[] | Location[] | 定義/参照位置 |
| Diagnostic[] | Diagnostic[] | 診断情報 |

### 出力先

LSPクライアント（JSON-RPC経由）

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ JSON-RPCでリクエスト受信
2. ハンドラールーティング
   └─ リクエストメソッドに対応するハンドラーを選択
3. ドキュメント取得
   └─ RequestContextからドキュメントを取得
4. 言語機能実行
   └─ 対応するRoslynサービスを呼び出し
5. レスポンス返却
   └─ JSON-RPCでレスポンス送信
```

### フローチャート

```mermaid
flowchart TD
    A[JSON-RPCリクエスト] --> B[LanguageServer]
    B --> C[RequestExecutionQueue]
    C --> D{メソッドルーティング}
    D --> E[ILspServiceRequestHandler]
    E --> F[RequestContext取得]
    F --> G{ドキュメント必要?}
    G -->|Yes| H[Document取得]
    G -->|No| I[処理実行]
    H --> I
    I --> J[レスポンス生成]
    J --> K[JSON-RPCレスポンス]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ドキュメント同期 | didOpen/didChange/didCloseで同期 | テキスト編集時 |
| BR-02 | 部分同期 | インクリメンタル同期をサポート | 大規模ファイル |
| BR-03 | 遅延計算 | 診断は非同期で計算しpush通知 | diagnostics |
| BR-04 | キャパビリティネゴシエーション | initializeでサポート機能を通知 | 接続時 |

### 計算ロジック

位置計算はLSPのLine/Character（0ベース）からRoslynのPosition（0ベース）に変換。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| -32700 | ParseError | JSON解析エラー | エラーレスポンス返却 |
| -32600 | InvalidRequest | 不正なリクエスト | エラーレスポンス返却 |
| -32601 | MethodNotFound | 未実装メソッド | エラーレスポンス返却 |

### リトライ仕様

クライアント側で実装

## トランザクション仕様

なし

## パフォーマンス要件

- 補完リクエストは200ms以内にレスポンス
- ホバーリクエストは100ms以内にレスポンス
- 診断は非同期でpush通知

## セキュリティ考慮事項

- 信頼できるワークスペースのみ開く
- 拡張機能の実行に注意

## 備考

- LSP 3.17準拠
- Visual Studio拡張（VSInternal）もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ハンドラーパターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ILspServiceRequestHandler.cs | `src/LanguageServer/Protocol/Handler/ILspServiceRequestHandler.cs` | ハンドラーインターフェース |
| 1-2 | RequestContext.cs | `src/LanguageServer/Protocol/Handler/RequestContext.cs` | リクエストコンテキスト |

**読解のコツ**: ILspServiceRequestHandler<TRequest, TResponse>はLSPリクエストを処理する基本インターフェース。

#### Step 2: 代表的なハンドラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HoverHandler.cs | `src/LanguageServer/Protocol/Handler/Hover/HoverHandler.cs` | ホバーハンドラー |
| 2-2 | CompletionHandler.cs | `src/LanguageServer/Protocol/Handler/Completion/CompletionHandler.cs` | 補完ハンドラー |

**主要処理フロー**:
- **HoverHandler 42-52行目**: HandleRequestAsyncでホバー処理
- **HoverHandler 68-84行目**: GetHoverAsyncで実際のホバー情報取得
- **CompletionHandler 45-67行目**: HandleRequestAsyncで補完処理
- **CompletionHandler 69-109行目**: GetCompletionListAsyncで補完リスト生成

#### Step 3: ドキュメント同期を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DidOpenHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidOpenHandler.cs` | ドキュメントオープン |
| 3-2 | DidChangeHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidChangeHandler.cs` | ドキュメント変更 |
| 3-3 | DidCloseHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidCloseHandler.cs` | ドキュメントクローズ |

#### Step 4: 診断配信を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DocumentPullDiagnosticHandler.cs | `src/LanguageServer/Protocol/Handler/Diagnostics/DocumentPullDiagnosticHandler.cs` | ドキュメント診断 |

#### Step 5: プロトコル変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ProtocolConversions.cs | `src/LanguageServer/Protocol/ProtocolConversions.cs` | LSP-Roslyn変換 |

### プログラム呼び出し階層図

```
LanguageServer (JSON-RPC受信)
    │
    ├─ RequestExecutionQueue
    │      └─ リクエストキューイング
    │
    └─ ILspServiceRequestHandler (各種ハンドラー)
           │
           ├─ HoverHandler
           │      ├─ context.GetRequiredDocument()
           │      └─ QuickInfoService.GetQuickInfoAsync
           │
           ├─ CompletionHandler
           │      ├─ context.GetRequiredDocument()
           │      └─ CompletionService.GetCompletionsAsync
           │
           ├─ DefinitionHandler
           │      ├─ context.GetRequiredDocument()
           │      └─ GoToDefinitionService.FindDefinitionsAsync
           │
           ├─ DocumentSymbolHandler
           │      └─ NavigationBarService
           │
           ├─ DidOpenHandler
           │      └─ ワークスペースドキュメント追加
           │
           └─ DidChangeHandler
                  └─ ドキュメントテキスト更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

JSON-RPC ──────▶ LanguageServer
                        │
                        ▼
TextDocumentIdentifier ──▶ RequestContext
                        │
                        ▼
                  Document取得
                        │
                        ▼
Position ────────▶ ProtocolConversions
                        │
                        ▼
                  Roslynサービス呼び出し
                        │
                        ├─ QuickInfoService
                        ├─ CompletionService
                        ├─ FindUsagesService
                        └─ ...
                        │
                        ▼
                  ProtocolConversions ───▶ LSPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ILspServiceRequestHandler.cs | `src/LanguageServer/Protocol/Handler/ILspServiceRequestHandler.cs` | ソース | ハンドラーインターフェース |
| ILspServiceDocumentRequestHandler.cs | `src/LanguageServer/Protocol/Handler/ILspServiceDocumentRequestHandler.cs` | ソース | ドキュメントハンドラーインターフェース |
| RequestContext.cs | `src/LanguageServer/Protocol/Handler/RequestContext.cs` | ソース | リクエストコンテキスト |
| HoverHandler.cs | `src/LanguageServer/Protocol/Handler/Hover/HoverHandler.cs` | ソース | ホバーハンドラー |
| CompletionHandler.cs | `src/LanguageServer/Protocol/Handler/Completion/CompletionHandler.cs` | ソース | 補完ハンドラー |
| CompletionResolveHandler.cs | `src/LanguageServer/Protocol/Handler/Completion/CompletionResolveHandler.cs` | ソース | 補完解決ハンドラー |
| DefinitionHandler.cs | `src/LanguageServer/Protocol/Handler/Definitions/DefinitionHandler.cs` | ソース | 定義ハンドラー |
| ReferencesHandler.cs | `src/LanguageServer/Protocol/Handler/References/ReferencesHandler.cs` | ソース | 参照ハンドラー |
| RenameHandler.cs | `src/LanguageServer/Protocol/Handler/Rename/RenameHandler.cs` | ソース | 名前変更ハンドラー |
| CodeActionHandler.cs | `src/LanguageServer/Protocol/Handler/CodeActions/CodeActionHandler.cs` | ソース | コードアクションハンドラー |
| DidOpenHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidOpenHandler.cs` | ソース | ドキュメントオープン |
| DidChangeHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidChangeHandler.cs` | ソース | ドキュメント変更 |
| DidCloseHandler.cs | `src/LanguageServer/Protocol/Handler/DocumentSync/DidCloseHandler.cs` | ソース | ドキュメントクローズ |
| DocumentPullDiagnosticHandler.cs | `src/LanguageServer/Protocol/Handler/Diagnostics/DocumentPullDiagnosticHandler.cs` | ソース | 診断ハンドラー |
| SemanticTokensHandler.cs | `src/LanguageServer/Protocol/Handler/SemanticTokens/SemanticTokensHandler.cs` | ソース | セマンティックトークン |
| ProtocolConversions.cs | `src/LanguageServer/Protocol/ProtocolConversions.cs` | ソース | プロトコル変換 |
