# 機能設計書 92-Roslyn言語サーバー

## 概要

本ドキュメントは、Roslyn の言語サーバー（Language Server）実装の機能設計を定義する。このコンポーネントは、共通 LSP フレームワーク上に構築され、C# および Visual Basic の言語サービスを LSP 対応エディタに提供する。

### 本機能の処理概要

Roslyn 言語サーバーは、Visual Studio Code などの LSP 対応エディタに対して、コード補完、定義へ移動、参照検索、診断情報表示などの IDE 機能を提供する。MSBuild プロジェクトシステムとの連携、ワークスペース管理、テスト実行支援などの機能も含む。

**業務上の目的・背景**：Visual Studio 以外のエディタ（VS Code、Neovim など）でも、Visual Studio と同等の C#/VB 開発体験を提供するため、標準化された LSP を通じて言語サービスを公開する。クロスプラットフォーム対応と軽量な開発環境のニーズに応える。

**機能の利用シーン**：開発者が VS Code で .NET プロジェクトを開き、C# ファイルを編集する際に、IntelliSense、エラー診断、リファクタリング、デバッグ設定の生成などの機能を利用する。

**主要な処理内容**：
1. プロジェクトシステムの初期化と MSBuild 連携
2. LSP ハンドラーによる各種言語機能の提供
3. ワークスペースの状態管理とファイル監視
4. 診断情報の収集とクライアントへのプッシュ
5. テスト検出と実行支援

**関連システム・外部連携**：MSBuild、NuGet、.NET SDK、Razor 言語サービス、テストフレームワーク（xUnit、NUnit、MSTest）、Brokered Services。

**権限による制御**：プロジェクトファイルへのファイルシステムアクセス権限が必要。

## 関連画面

本機能は LSP プロトコルを提供するバックエンド処理であり、直接的な UI 画面は持たない。クライアント側のエディタ UI と連携する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | LSP クライアント（VS Code 等）との連携 |

## 機能種別

言語サービス / プロジェクト管理 / デバッグ支援 / テスト支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| inputStream | Stream | Yes | 標準入力ストリーム（LSP 通信用） | null チェック |
| outputStream | Stream | Yes | 標準出力ストリーム（LSP 通信用） | null チェック |
| exportProvider | ExportProvider | Yes | MEF エクスポートプロバイダー | null チェック |
| loggerFactory | ILoggerFactory | Yes | ログファクトリ | null チェック |
| typeRefResolver | AbstractTypeRefResolver | Yes | 型参照リゾルバ | null チェック |

### 入力データソース

- LSP クライアントからの JSON-RPC リクエスト
- .csproj/.vbproj プロジェクトファイル
- .sln ソリューションファイル
- ソースコードファイル (.cs/.vb)
- EditorConfig 設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CompletionList | LSP CompletionList | コード補完候補リスト |
| Diagnostics | LSP Diagnostic[] | 診断情報（エラー、警告） |
| Location | LSP Location | 定義位置情報 |
| WorkspaceEdit | LSP WorkspaceEdit | ワークスペース編集内容 |
| TestResults | TestResult[] | テスト実行結果 |

### 出力先

- JSON-RPC を通じた LSP クライアントへのレスポンス
- ログファイル

## 処理フロー

### 処理シーケンス

```
1. サーバー起動
   └─ LanguageServerHost コンストラクタで JsonRpc、RoslynLanguageServer 初期化
2. 初期化リクエスト処理
   └─ initialize リクエストでサーバー機能をネゴシエーション
3. プロジェクト読み込み
   └─ LanguageServerProjectSystem でプロジェクト構造を読み込み
4. ワークスペース構築
   └─ LanguageServerWorkspace でソリューション/プロジェクト管理
5. LSP リクエスト処理
   └─ 各種ハンドラーで機能提供
6. 診断情報配信
   └─ SolutionCrawler で変更検知、診断情報をプッシュ
```

### フローチャート

```mermaid
flowchart TD
    A[VS Code 起動] --> B[言語サーバープロセス起動]
    B --> C[LanguageServerHost 初期化]
    C --> D[JsonRpc 接続確立]
    D --> E[initialize リクエスト]
    E --> F[プロジェクト自動検出/読み込み]
    F --> G{プロジェクト読み込み成功?}
    G -->|Yes| H[ワークスペース構築完了]
    G -->|No| I[エラー通知]
    H --> J[LSP リクエスト待機]
    J --> K[ハンドラーで処理]
    K --> L[レスポンス返却]
    L --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-01 | プロジェクト自動読み込み | ワークスペースフォルダ内の .sln/.csproj を自動検出 | AutoLoadProjects 設定が有効な場合 |
| BR-92-02 | ファイルベースプログラム | 単一 .cs ファイルを仮想プロジェクトとして処理 | プロジェクトファイルが存在しない場合 |
| BR-92-03 | Razor 連携 | Razor ファイルの言語サービスは Razor 言語サーバーに委譲 | .razor/.cshtml ファイルの場合 |
| BR-92-04 | テスト検出 | プロジェクト内のテストメソッドを自動検出 | テストフレームワーク参照がある場合 |

### 計算ロジック

なし（プロトコル処理とファイルシステム操作が主）

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PROJECT_LOAD_FAILED | プロジェクト読み込みエラー | .csproj のパースエラー | プロジェクトファイルを修正 |
| MSBUILD_NOT_FOUND | MSBuild 未検出 | .NET SDK 未インストール | SDK をインストール |
| RESTORE_REQUIRED | パッケージ復元必要 | NuGet パッケージ未復元 | dotnet restore を実行 |
| OOP_CRASH | OOP プロセスクラッシュ | ServiceHub プロセス異常終了 | プロセス自動再起動 |

### リトライ仕様

- プロジェクト読み込み失敗時: ファイル変更検知後に再試行
- OOP プロセスクラッシュ時: 自動再起動

## トランザクション仕様

LSP リクエストは個別の操作として処理される。ワークスペースの変更はアトミックに適用される。

## パフォーマンス要件

- プロジェクト読み込み: 大規模ソリューション（100+ プロジェクト）でも 1 分以内
- コード補完レスポンス: 200ms 以内
- 診断情報更新: ファイル変更後 500ms 以内

## セキュリティ考慮事項

- ファイルシステムアクセスはワークスペースフォルダに限定
- 外部プロセス起動は .NET CLI および MSBuild に限定
- ユーザー認証情報の取り扱いなし

## 備考

VS Code 拡張機能「C# Dev Kit」と連携して動作する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LanguageServerHost.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/LanguageServerHost.cs` | サーバーのホストクラス、JsonRpc 初期化 |

**主要処理フロー**:
1. **29-54行目**: コンストラクタで JsonRpc、RoslynLanguageServer を初期化
2. **56-62行目**: Start() で JsonRpc リスニング開始
3. **64-68行目**: WaitForExitAsync() でサーバー終了待機
4. **70-73行目**: GetRequiredLspService<T>() でサービス取得

#### Step 2: プロジェクトシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LanguageServerProjectSystem.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectSystem.cs` | プロジェクト管理のコア実装 |
| 2-2 | LanguageServerProjectLoader.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectLoader.cs` | プロジェクト読み込みロジック |
| 2-3 | LanguageServerWorkspaceFactory.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerWorkspaceFactory.cs` | ワークスペース作成ファクトリ |

#### Step 3: LSP ハンドラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OpenProjectsHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/OpenProjectsHandler.cs` | プロジェクトを開くハンドラー |
| 3-2 | OpenSolutionHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/OpenSolutionHandler.cs` | ソリューションを開くハンドラー |
| 3-3 | RestoreHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/Restore/RestoreHandler.cs` | NuGet 復元ハンドラー |

#### Step 4: テスト機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | RunTestsHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/RunTestsHandler.cs` | テスト実行ハンドラー |
| 4-2 | TestDiscoverer.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestDiscoverer.cs` | テスト検出ロジック |
| 4-3 | TestRunner.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestRunner.cs` | テスト実行ロジック |

### プログラム呼び出し階層図

```
LanguageServerHost
    │
    ├─ Start()
    │      └─ JsonRpc.StartListening()
    │
    ├─ RoslynLanguageServer
    │      ├─ ILanguageServerFactory.Create()
    │      └─ AbstractLanguageServer<RequestContext>
    │
    └─ LanguageServerWorkspaceFactory
           ├─ LanguageServerProjectSystem
           │      └─ LanguageServerProjectLoader
           │             └─ LoadedProject
           │
           └─ LanguageServerWorkspace
                  └─ WorkspaceProject
```

### データフロー図

```
[入力]                          [処理]                              [出力]

プロジェクトファイル ───▶ LanguageServerProjectLoader ───▶ Workspace
      (.csproj)                    │
                                   ▼
ソースファイル ─────────▶ Document ─────────────────────▶ 診断情報
      (.cs)                        │
                                   ▼
LSP リクエスト ─────────▶ Handler ──────────────────────▶ LSP レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LanguageServerHost.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/` | ソース | サーバーホスト |
| LanguageServerProjectSystem.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/` | ソース | プロジェクトシステム |
| LanguageServerProjectLoader.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/` | ソース | プロジェクト読み込み |
| LanguageServerWorkspaceFactory.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/` | ソース | ワークスペースファクトリ |
| LanguageServerWorkspace.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/` | ソース | ワークスペース実装 |
| RunTestsHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/` | ソース | テスト実行ハンドラー |
| TestDiscoverer.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/` | ソース | テスト検出 |
| RestoreHandler.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/Handler/Restore/` | ソース | NuGet 復元 |
| ServerConfigurationFactory.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/` | ソース | サーバー設定 |
| DotnetCliHelper.cs | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/` | ソース | .NET CLI ヘルパー |
| README.md | `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/` | ドキュメント | 概要説明 |
