# 機能設計書 94-継承マージン

## 概要

本ドキュメントは、Roslyn の継承マージン（Inheritance Margin）機能の設計を定義する。継承マージンは、エディタの左マージンに継承関係を示すアイコンを表示し、型やメンバーの継承・実装関係を視覚的に把握できる機能である。

### 本機能の処理概要

継承マージンは、クラス、インターフェース、メソッド、プロパティなどの宣言に対して、それらが継承・実装しているターゲット、または継承・実装されているターゲットを検出し、エディタのマージン領域にアイコンとして表示する。

**業務上の目的・背景**：オブジェクト指向プログラミングでは継承やインターフェース実装が頻繁に使用される。コードを読む際に、あるメソッドがどのインターフェースを実装しているか、または何をオーバーライドしているかを素早く確認できることで、コードの理解が容易になる。

**機能の利用シーン**：開発者がクラスやメソッドを編集する際、そのシンボルがどのような継承関係を持っているかをマージンのアイコンで確認する。アイコンをクリックすると、継承元または実装先へナビゲーションできる。

**主要な処理内容**：
1. ドキュメント内の型・メンバー宣言を検出
2. 各シンボルの継承関係を分析
3. 継承ターゲット（実装元、派生先など）を収集
4. マージンアイコンとして表示

**関連システム・外部連携**：Visual Studio エディタマージン、Go to Base/Go to Implementation 機能との連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | 継承マージンコンテキストメニュー | 主機能 | 継承関係（継承元・実装先）へのナビゲーションメニュー |

## 機能種別

継承分析 / 情報表示 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null チェック |
| spanToSearch | TextSpan | Yes | 検索対象のテキスト範囲 | 有効な範囲 |
| includeGlobalImports | bool | No | グローバルインポートを含めるか | - |
| frozenPartialSemantics | bool | No | 部分的セマンティクスを使用するか | - |

### 入力データソース

- ドキュメントのセマンティックモデル
- シンボルの型情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LineNumber | int | マージンを表示する行番号 |
| DisplayTexts | TaggedText[] | 表示テキスト |
| Glyph | Glyph | シンボルのグリフ |
| TargetItems | InheritanceTargetItem[] | 継承ターゲットの配列 |
| TopLevelDisplayText | string | トップレベル表示テキスト（オプション） |

### 出力先

- エディタマージン領域
- 継承ナビゲーションメニュー

## 処理フロー

### 処理シーケンス

```
1. ドキュメント読み込み
   └─ 指定範囲のシンタックスノードを取得
2. メンバー検出
   └─ GetMembers で型・メソッド・プロパティなどを抽出
3. シンボル分析
   └─ 各シンボルの継承関係を分析
4. ターゲット収集
   └─ 継承元、実装インターフェース、派生クラスなどを収集
5. 結果生成
   └─ InheritanceMarginItem として結果を返却
```

### フローチャート

```mermaid
flowchart TD
    A[ドキュメント変更検知] --> B[GetInheritanceMemberItemsAsync]
    B --> C{OOP 利用可能?}
    C -->|Yes| D[RemoteInheritanceMarginService 呼び出し]
    C -->|No| E[GetInheritanceMarginItemsInProcessAsync]
    D --> F[結果マージ]
    E --> F
    F --> G[各シンボルに対して]
    G --> H{継承ターゲットあり?}
    H -->|Yes| I[InheritanceMarginItem 作成]
    H -->|No| J[スキップ]
    I --> K[マージンに表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-94-01 | 対象シンボル判定 | 静的でないクラス、インターフェース、構造体のみ対象 | CanHaveInheritanceTarget で判定 |
| BR-94-02 | 対象メソッド判定 | Ordinary、ExplicitInterfaceImplementation、UserDefinedOperator、Conversion のみ対象 | MethodKind チェック |
| BR-94-03 | ターゲット順序 | 表示名でソート、言語グリフで降順、プロジェクト名でソート | Order メソッド |
| BR-94-04 | グローバルインポート | 設定に応じてグローバルインポートを含める | includeGlobalImports フラグ |

### 計算ロジック

継承関係の検出:
- 基底クラス → 実装しているとマーク
- 実装インターフェース → 実装しているとマーク
- 派生クラス → 継承されているとマーク
- オーバーライドメソッド → オーバーライド元を表示

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | OOP 接続失敗 | リモートサービス利用不可 | インプロセスフォールバック |
| - | セマンティックモデル取得失敗 | コンパイルエラー等 | 空の結果を返却 |

### リトライ仕様

OOP 失敗時はインプロセスで処理を続行。

## トランザクション仕様

トランザクション不要（読み取り専用操作）。

## パフォーマンス要件

- 表示行ごとの処理: 10ms 以内
- フローズンセマンティクスを使用して高速化
- バックグラウンドで非同期実行

## セキュリティ考慮事項

- プロジェクト内のコードのみ分析対象
- 外部システムへのアクセスなし

## 備考

Visual Studio 2019 以降で利用可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InheritanceMarginItem.cs | `src/Features/Core/Portable/InheritanceMargin/InheritanceMarginItem.cs` | マージン項目のデータ構造 |
| 1-2 | InheritanceTargetItem.cs | `src/Features/Core/Portable/InheritanceMargin/InheritanceTargetItem.cs` | 継承ターゲットのデータ構造 |
| 1-3 | InheritanceRelationship.cs | `src/Features/Core/Portable/InheritanceMargin/InheritanceRelationship.cs` | 継承関係の種別列挙 |

**読解のコツ**: InheritanceMarginItem は readonly struct として定義され、LineNumber、DisplayTexts、Glyph、TargetItems を持つ。

#### Step 2: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/IInheritanceMarginService.cs` | サービスインターフェース |
| 2-2 | IRemoteInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/IRemoteInheritanceMarginService.cs` | リモートサービスインターフェース |

#### Step 3: コア実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/AbstractInheritanceMarginService.cs` | サービスの抽象基底クラス |
| 3-2 | AbstractInheritanceMarginService_Helpers.cs | `src/Features/Core/Portable/InheritanceMargin/AbstractInheritanceMarginService_Helpers.cs` | ヘルパーメソッド |

**主要処理フロー**:
- **30-67行目**: GetInheritanceMemberItemsAsync - OOP/インプロセスの判定と呼び出し
- **69-86行目**: CanHaveInheritanceTarget - 対象シンボルの判定ロジック

### プログラム呼び出し階層図

```
IInheritanceMarginService
    │
    └─ AbstractInheritanceMarginService
           │
           ├─ GetInheritanceMemberItemsAsync()
           │      ├─ RemoteHostClient.TryInvokeAsync()
           │      │      └─ IRemoteInheritanceMarginService.GetInheritanceMarginItemsAsync()
           │      │
           │      └─ GetInheritanceMarginItemsInProcessAsync()
           │             ├─ GetMembers()
           │             ├─ GetDeclarationToken()
           │             └─ CanHaveInheritanceTarget()
           │
           └─ (言語固有実装)
                  ├─ CSharpInheritanceMarginService
                  └─ VisualBasicInheritanceMarginService
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Document ───────────────▶ GetMembers() ────────────────────▶ SyntaxNode[]
                                │
                                ▼
TextSpan ───────────────▶ GetDeclarationToken() ───────────▶ SyntaxToken
                                │
                                ▼
SemanticModel ──────────▶ CanHaveInheritanceTarget() ──────▶ ISymbol
                                │
                                ▼
                    継承関係分析 ────────────────────────▶ InheritanceTargetItem[]
                                │
                                ▼
                    InheritanceMarginItem.CreateOrdered() ─▶ InheritanceMarginItem
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | サービス抽象基底クラス |
| AbstractInheritanceMarginService_Helpers.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | ヘルパーメソッド |
| IInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | サービスインターフェース |
| IRemoteInheritanceMarginService.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | リモートサービスインターフェース |
| InheritanceMarginItem.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | マージン項目データ構造 |
| InheritanceTargetItem.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | ターゲット項目データ構造 |
| InheritanceRelationship.cs | `src/Features/Core/Portable/InheritanceMargin/` | ソース | 継承関係列挙型 |
