# 機能設計書 96-VBスクリプト

## 概要

本ドキュメントは、Roslyn の Visual Basic スクリプト機能の設計を定義する。VB スクリプトは、コンパイル済みアセンブリを作成せずに Visual Basic コードを直接実行できるスクリプティング機能を提供する。

### 本機能の処理概要

Visual Basic スクリプト (VisualBasicScript) は、C# スクリプトと同様に、文字列として提供された Visual Basic コードを動的にコンパイルし、実行する機能を提供する。C# スクリプトと共通のコアインフラストラクチャ（Scripting.Core）を使用しながら、Visual Basic 固有の構文とセマンティクスをサポートする。

**業務上の目的・背景**：Visual Basic を使用するプロジェクトや開発者に対して、C# と同等のスクリプティング機能を提供する。既存の VB コードベースとの互換性を維持しながら、スクリプト実行環境を利用可能にする。

**機能の利用シーン**：
- vbi.exe (VB Interactive) での対話的なコード実行
- Visual Basic スクリプトファイルの実行
- VB ベースのアプリケーションへのスクリプト機能の埋め込み

**主要な処理内容**：
1. Visual Basic ソースコードのパース
2. VB セマンティック分析とコンパイル
3. IL 生成とメモリ内アセンブリ作成
4. スクリプトの実行と結果の取得
5. スクリプト状態の管理

**関連システム・外部連携**：Roslyn VB コンパイラ、.NET ランタイム。

**権限による制御**：C# スクリプトと同様。

## 関連画面

本機能はライブラリ/API として提供され、直接的な UI 画面は持たない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | API 呼び出しによるスクリプト実行 |

## 機能種別

スクリプト実行 / コンパイル / ランタイム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code | String | Yes | スクリプトのソースコード | 空文字列はデフォルト動作 |
| options | ScriptOptions | No | スクリプトオプション | Nothing の場合デフォルト使用 |
| globalsType | Type | No | グローバル変数の型 | Nothing 許容 |
| globals | Object | No | グローバル変数のインスタンス | globalsType と一致 |
| assemblyLoader | InteractiveAssemblyLoader | No | アセンブリローダー | Nothing 許容 |

### 入力データソース

- 文字列としての Visual Basic ソースコード
- ScriptOptions による参照・インポート設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Script(Of T) | Script(Of T) | コンパイル済みスクリプトオブジェクト |
| ScriptState(Of T) | ScriptState(Of T) | 実行後のスクリプト状態 |
| ReturnValue | T | スクリプトの戻り値 |
| Variables | ImmutableArray(Of ScriptVariable) | 宣言された変数一覧 |

### 出力先

- メソッド戻り値

## 処理フロー

### 処理シーケンス

```
1. スクリプト作成
   └─ VisualBasicScript.Create(Of T)(code, options, globalsType, assemblyLoader)
2. コンパイル
   └─ script.Compile() でコンパイルと診断情報取得
3. 実行
   └─ script.RunAsync(globals) でスクリプト実行
4. 結果取得
   └─ ScriptState から戻り値・変数を取得
```

### フローチャート

```mermaid
flowchart TD
    A[VisualBasicScript.Create] --> B[Script(Of T) オブジェクト作成]
    B --> C[GetCompilation]
    C --> D[VisualBasicScriptCompiler.CreateSubmission]
    D --> E{コンパイルエラー?}
    E -->|Yes| F[CompilationErrorException]
    E -->|No| G[RunAsync]
    G --> H[GetExecutor]
    H --> I[ScriptBuilder.CreateExecutor]
    I --> J[IL 生成・アセンブリ作成]
    J --> K[スクリプト実行]
    K --> L[ScriptState(Of T) 返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-01 | グローバル変数の検証 | globals の型が globalsType と一致する必要がある | globals IsNot Nothing の場合 |
| BR-96-02 | コード空文字列対応 | code が Nothing の場合、String.Empty として処理 | If(code, String.Empty) |
| BR-96-03 | 共通スクリプトコア使用 | C# スクリプトと共通の Script 基底クラスを使用 | 常に |

### 計算ロジック

C# スクリプトと同様、スクリプトのコンパイルは Submission として扱われる。

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompilationErrorException | コンパイルエラー | コードを修正 |
| - | 実行時例外 | スクリプト実行中のエラー | 例外処理 |

### リトライ仕様

スクリプト実行のリトライは呼び出し元で制御する。

## トランザクション仕様

トランザクション不要。

## パフォーマンス要件

C# スクリプトと同様。

## セキュリティ考慮事項

C# スクリプトと同様。

## 備考

NuGet パッケージ `Microsoft.CodeAnalysis.VisualBasic.Scripting` として公開。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | VisualBasicScript.vb | `src/Scripting/VisualBasic/VisualBasicScript.vb` | VB スクリプトのファクトリクラス |

**主要処理フロー**:
- **22-27行目**: Create(Of T) - スクリプト作成
- **32-37行目**: Create - Object 型スクリプト作成
- **42-47行目**: RunAsync(Of T) - スクリプト実行
- **52-57行目**: RunAsync - Object 型実行
- **62-67行目**: EvaluateAsync(Of T) - スクリプト評価と結果取得
- **72-77行目**: EvaluateAsync - Object 型評価

**読解のコツ**: VB の Optional パラメータ構文を理解する。Nothing はデフォルト値として使用される。

#### Step 2: VB コンパイラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VisualBasicScriptCompiler.vb | `src/Scripting/VisualBasic/VisualBasicScriptCompiler.vb` | VB スクリプトコンパイラ実装 |

#### Step 3: 共通スクリプトコアを理解する

C# スクリプト (No.95) と同じ Scripting.Core を使用するため、詳細は No.95 を参照。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Script.cs | `src/Scripting/Core/Script.cs` | 共通スクリプト基底クラス |
| 3-2 | ScriptOptions.cs | `src/Scripting/Core/ScriptOptions.cs` | 共通オプションクラス |

### プログラム呼び出し階層図

```
VisualBasicScript (Shared/Static Factory)
    │
    └─ Create(Of T)(code, options, globalsType, assemblyLoader)
           └─ Script.CreateInitialScript(Of T)()
                  └─ New Script(Of T)()
                         │
                         ├─ GetCompilation()
                         │      └─ VisualBasicScriptCompiler.CreateSubmission()
                         │
                         └─ RunAsync(globals)
                                └─ ScriptState(Of T)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

String code ─────────────▶ SourceText.From() ──────────────▶ SourceText
                                 │
                                 ▼
ScriptOptions ───────────▶ VisualBasicScriptCompiler ──────▶ Compilation
                                 │
                                 ▼
globalsType/globals ─────▶ ScriptBuilder.CreateExecutor() ─▶ Func(Of Object(), Task(Of T))
                                 │
                                 ▼
                         RunAsync() ───────────────────────▶ ScriptState(Of T)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VisualBasicScript.vb | `src/Scripting/VisualBasic/` | ソース | ファクトリクラス |
| VisualBasicScriptCompiler.vb | `src/Scripting/VisualBasic/` | ソース | VB コンパイラ実装 |
| VisualBasicObjectFormatter.vb | `src/Scripting/VisualBasic/Hosting/ObjectFormatting/` | ソース | オブジェクトフォーマッター |
| Script.cs | `src/Scripting/Core/` | ソース | 共通 Script 基底クラス |
| ScriptOptions.cs | `src/Scripting/Core/` | ソース | 共通オプションクラス |
| ScriptState.cs | `src/Scripting/Core/` | ソース | 共通実行状態 |
