# 機能設計書 97-スクリプトコア

## 概要

本ドキュメントは、Roslyn のスクリプティングコア（Scripting.Core）機能の設計を定義する。スクリプトコアは、C# スクリプトおよび VB スクリプトの共通基盤となるクラスとインフラストラクチャを提供する。

### 本機能の処理概要

スクリプトコアは、言語に依存しないスクリプト実行の共通フレームワークを提供する。Script 基底クラス、ScriptOptions、ScriptState、ScriptBuilder などのコアコンポーネントを含み、C# と VB のスクリプト実装で共有される。

**業務上の目的・背景**：C# スクリプトと VB スクリプトで共通するロジック（コンパイル、実行、状態管理、オプション管理）を一元化することで、コードの重複を排除し、一貫した動作を保証する。

**機能の利用シーン**：
- C#/VB スクリプトの基盤として使用
- カスタムスクリプトホストの実装
- コマンドラインランナー（csi/vbi）の実装

**主要な処理内容**：
1. スクリプトオブジェクトの管理（Script, Script<T>）
2. スクリプトオプションの管理（ScriptOptions）
3. スクリプト状態の管理（ScriptState<T>）
4. 実行デリゲートの生成（ScriptBuilder）
5. コマンドラインインターフェース（CommandLineRunner）

**関連システム・外部連携**：言語固有のスクリプトコンパイラ（C#/VB）、.NET ランタイム。

**権限による制御**：ホストアプリケーションの権限に従う。

## 関連画面

本機能はライブラリとして提供され、直接的な UI 画面は持たない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | ライブラリとして使用 |

## 機能種別

フレームワーク / ランタイム / ホスティング

## 入力仕様

### 入力パラメータ

スクリプトコアの主要クラスの入力パラメータ。

#### ScriptOptions

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filePath | string | No | スクリプトファイルパス | デフォルト空文字列 |
| references | ImmutableArray<MetadataReference> | No | メタデータ参照 | デフォルト参照含む |
| namespaces | ImmutableArray<string> | No | インポート名前空間 | デフォルト空 |
| metadataResolver | MetadataReferenceResolver | No | 参照リゾルバ | デフォルトリゾルバ |
| sourceResolver | SourceReferenceResolver | No | ソースリゾルバ | デフォルトリゾルバ |
| emitDebugInformation | bool | No | デバッグ情報出力 | デフォルト false |
| optimizationLevel | OptimizationLevel | No | 最適化レベル | デフォルト Debug |
| allowUnsafe | bool | No | unsafe 許可 | デフォルト true |

### 入力データソース

- スクリプトソースコード
- メタデータ参照
- ソースファイル参照（#load ディレクティブ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Script<T> | Script<T> | コンパイル済みスクリプト |
| ScriptState<T> | ScriptState<T> | 実行状態 |
| Compilation | Compilation | コンパイル結果 |
| Diagnostics | ImmutableArray<Diagnostic> | 診断情報 |

### 出力先

- メソッド戻り値

## 処理フロー

### 処理シーケンス

```
1. ScriptOptions 構築
   └─ 参照、インポート、オプションを設定
2. Script 作成
   └─ Script.CreateInitialScript でスクリプトオブジェクト作成
3. コンパイル
   └─ GetCompilation で Compilation 取得
   └─ ScriptBuilder.CreateExecutor で実行デリゲート生成
4. 実行
   └─ RunAsync で実行状態を取得
5. 継続
   └─ ContinueWith で次のスクリプトをチェーン
   └─ RunFromAsync で前の状態から継続実行
```

### フローチャート

```mermaid
flowchart TD
    A[ScriptOptions 構築] --> B[Script.CreateInitialScript]
    B --> C[Script<T> オブジェクト]
    C --> D[GetCompilation]
    D --> E[ScriptCompiler.CreateSubmission]
    E --> F[Compilation]
    F --> G{Compile 呼び出し?}
    G -->|Yes| H[ScriptBuilder.CreateExecutor]
    H --> I[Func<object[], Task<T>>]
    G -->|No| J[RunAsync 呼び出し]
    I --> J
    J --> K[ScriptExecutionState.Create]
    K --> L[RunSubmissionsAsync]
    L --> M[ScriptState<T>]
    M --> N{ContinueWith?}
    N -->|Yes| O[新しい Script<T> 作成]
    O --> D
    N -->|No| P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-97-01 | ホストアセンブリ参照 | GlobalsType のアセンブリに再帰的エイリアス `<host>` を付与 | GlobalsType != null |
| BR-97-02 | デフォルト参照 | .NET Core では基本ライブラリを自動参照 | GacFileResolver.IsAvailable == false |
| BR-97-03 | 参照継承禁止 | ContinueWith では参照とインポートを継承しない | Previous != null |
| BR-97-04 | 遅延解決参照 | UnresolvedMetadataReference は実行時に解決 | MetadataResolver で解決 |

### 計算ロジック

スクリプトチェーンでは、各スクリプトの Submission が順番に実行され、前のスクリプトの宣言が次のスクリプトで参照可能になる。

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_MetadataFileNotFound | 参照解決エラー | 参照ファイルが見つからない | パスを確認 |
| - | ArgumentNullException | 必須パラメータが null | パラメータを指定 |
| - | ArgumentException | globals 型不一致 | 正しい型を指定 |
| - | CompilationErrorException | コンパイルエラー | コードを修正 |

### リトライ仕様

リトライは呼び出し元で制御する。

## トランザクション仕様

トランザクション不要。

## パフォーマンス要件

- Executor キャッシュによる再実行の高速化
- 遅延初期化パターンの活用
- 不変データ構造による並行実行安全性

## セキュリティ考慮事項

- AllowUnsafe オプションで unsafe コードを制御
- スクリプトはホストプロセスの権限で実行

## 備考

NuGet パッケージ `Microsoft.CodeAnalysis.Scripting.Common` として公開。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: スクリプトオプションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ScriptOptions.cs | `src/Scripting/Core/ScriptOptions.cs` | スクリプト実行オプション |

**主要プロパティ/メソッド**:
- **25-37行目**: Default 静的プロパティ
- **39-77行目**: GetDefaultMetadataReferences - デフォルト参照取得
- **88-143行目**: 主要プロパティ定義（MetadataReferences, MetadataResolver, Imports 等）
- **215-306行目**: WithReferences 各オーバーロード

#### Step 2: Script 基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Script.cs | `src/Scripting/Core/Script.cs` | Script 抽象クラスと Script<T> 実装 |

**主要処理フロー**:
- **39-52行目**: コンストラクタ
- **54-57行目**: CreateInitialScript - 初期スクリプト作成
- **144-153行目**: GetCompilation - コンパイル取得
- **164-168行目**: EvaluateAsync - 評価実行
- **339-395行目**: Script<T>.GetExecutor - 実行デリゲート取得

#### Step 3: スクリプト状態を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ScriptState.cs | `src/Scripting/Core/ScriptState.cs` | 実行状態管理 |
| 3-2 | ScriptVariable.cs | `src/Scripting/Core/ScriptVariable.cs` | 変数情報 |
| 3-3 | ScriptExecutionState.cs | `src/Scripting/Core/ScriptExecutionState.cs` | 実行状態内部管理 |

#### Step 4: スクリプトビルダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ScriptBuilder.cs | `src/Scripting/Core/ScriptBuilder.cs` | IL 生成と実行デリゲート作成 |

#### Step 5: コマンドラインランナーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/CommandLineRunner.cs` | REPL ループ実装 |

**主要処理フロー**:
- **53-69行目**: RunInteractive - エントリーポイント
- **222-292行目**: RunInteractiveLoop - REPL ループ
- **294-318行目**: BuildAndRun - コンパイルと実行

### プログラム呼び出し階層図

```
Script (Abstract)
    │
    └─ Script<T>
           │
           ├─ CreateInitialScript<T>()
           │      └─ new Script<T>(compiler, builder, sourceText, options, ...)
           │
           ├─ GetCompilation()
           │      └─ ScriptCompiler.CreateSubmission()
           │             └─ Compilation
           │
           ├─ GetExecutor()
           │      └─ ScriptBuilder.CreateExecutor<T>()
           │             └─ Func<object[], Task<T>>
           │
           └─ RunAsync()
                  └─ ScriptExecutionState.Create()
                         └─ RunSubmissionsAsync()
                                └─ ScriptState<T>

CommandLineRunner
    │
    └─ RunInteractive()
           └─ RunInteractiveCore()
                  ├─ RunScript()
                  │      └─ script.RunAsync()
                  │
                  └─ RunInteractiveLoop()
                         └─ BuildAndRun()
                                ├─ script.Compile()
                                └─ script.RunAsync() / script.RunFromAsync()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ScriptOptions ───────────▶ Script<T> ──────────────────────▶ Compilation
      │                         │
      ▼                         ▼
MetadataReferences ─────▶ GetReferencesForCompilation() ───▶ ImmutableArray<MetadataReference>
      │                         │
      ▼                         ▼
SourceText ─────────────▶ ScriptCompiler.CreateSubmission() ▶ Compilation
                                │
                                ▼
                    ScriptBuilder.CreateExecutor() ────────▶ Func<object[], Task<T>>
                                │
                                ▼
globals ────────────────▶ ScriptExecutionState ────────────▶ ScriptState<T>
                                │
                                ▼
                         ReturnValue / Variables / Exception
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Script.cs | `src/Scripting/Core/` | ソース | Script 抽象/ジェネリッククラス |
| ScriptOptions.cs | `src/Scripting/Core/` | ソース | オプション管理 |
| ScriptState.cs | `src/Scripting/Core/` | ソース | 実行状態 |
| ScriptVariable.cs | `src/Scripting/Core/` | ソース | 変数情報 |
| ScriptCompiler.cs | `src/Scripting/Core/` | ソース | コンパイラ抽象クラス |
| ScriptBuilder.cs | `src/Scripting/Core/` | ソース | 実行デリゲート生成 |
| ScriptExecutionState.cs | `src/Scripting/Core/` | ソース | 実行状態内部管理 |
| ScriptRunner.cs | `src/Scripting/Core/` | ソース | スクリプトランナーデリゲート |
| CommandLineRunner.cs | `src/Scripting/Core/Hosting/CommandLine/` | ソース | REPL ランナー |
| InteractiveAssemblyLoader.cs | `src/Scripting/Core/Hosting/` | ソース | アセンブリローダー |
| ObjectFormatter.cs | `src/Scripting/Core/Hosting/ObjectFormatting/` | ソース | オブジェクトフォーマッター |
| RuntimeMetadataReferenceResolver.cs | `src/Scripting/Core/Hosting/Resolvers/` | ソース | 参照リゾルバ |
