---
generated_at: 2026-02-10 15:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：100-インタラクティブホスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Interactive/Host/Interactive/Core/InteractiveHost.cs`
- E-02: `src/Interactive/Host/Interactive/Core/RemoteExecutionResult.cs`
- E-03: `src/Interactive/Host/Interactive/Core/InteractiveHostOptions.cs`
- E-04: `src/Interactive/Host/Interactive/Core/InteractiveHostPlatform.cs`
- E-05: 機能一覧.csv（No.100 インタラクティブホスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DefaultPlatform = InteractiveHostPlatform.Core | E-01: 26行目 | ○ |
| C-02 | OutputEncoding = Encoding.Unicode | E-01: 35行目 | ○ |
| C-03 | コンストラクタ定義 | E-01: 71-85行目 | ○ |
| C-04 | millisecondsTimeout デフォルト 5000 | E-01: 74行目 | ○ |
| C-05 | MaxAttemptsToCreateProcess = 2 | E-01: 51行目 | ○ |
| C-06 | Dispose メソッド | E-01: 113-120行目 | ○ |
| C-07 | SetOutputs メソッド | E-01: 127-150行目 | ○ |
| C-08 | CreateRemoteService メソッド | E-01: 187-190行目 | ○ |
| C-09 | ExecuteRemoteAsync メソッド | E-01: 269-271行目 | ○ |
| C-10 | ResetAsync メソッド | E-01: 330-352行目 | ○ |
| C-11 | ExecuteAsync メソッド | E-01: 362-366行目 | ○ |
| C-12 | ExecuteFileAsync メソッド | E-01: 377-381行目 | ○ |
| C-13 | AddReferenceAsync メソッド | E-01: 391-395行目 | ○ |
| C-14 | SetPathsAsync メソッド | E-01: 400-407行目 | ○ |
| C-15 | OnOutputReceived メソッド | E-01: 152-163行目 | ○ |
| C-16 | TryGetOrCreateRemoteServiceAsync メソッド | E-01: 216-267行目 | ○ |
| C-17 | JsonRpc 使用 | E-01: 37-44行目 s_jsonRpcTargetOptions | ○ |
| C-18 | ProcessInitialized イベント | E-01: 69行目 | ○ |
| C-19 | OutputReceived イベント | E-01: 89行目 | ○ |
| C-20 | ErrorOutputReceived イベント | E-01: 90行目 | ○ |
| C-21 | RemoteExecutionResult データ構造 | E-02: ファイル存在 | ○ |
| C-22 | InteractiveHostOptions 構造 | E-03: ファイル存在 | ○ |
| C-23 | InteractiveHostPlatform 列挙 | E-04: ファイル存在 | ○ |
| C-24 | パフォーマンス要件（2秒、100ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件**：ソースコードに具体的なパフォーマンス目標は定義されていない。
  - 候補：Visual Studio パフォーマンスガイドライン / プロジェクト要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアクラスの説明（ソースコード確認済み）
- 0: 低リスク - API 説明
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] InteractiveHost の主要メソッドが網羅されているか
- [ ] プロセス管理（起動、リセット、終了）のフローが正確か
- [ ] JSON-RPC 通信の説明が正確か
- [ ] コードリーディングガイドの行番号が最新コードと一致しているか
