---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：101-VS C#拡張

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的な数値**: 根拠不足
  2. **Visual Studio バージョン互換性の詳細**: 根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/CSharp/Impl/CSharpPackage.cs`（1-175行目）
- E-02: `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPage.cs`（1-18行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（関連画面情報）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSharpPackage が AbstractPackage を継承 | E-01: 58行目 `internal sealed class CSharpPackage : AbstractPackage<CSharpPackage, CSharpLanguageService>` | ○ |
| C-02 | オプションページが属性で登録される | E-01: 43-52行目 `[ProvideLanguageEditorOptionPage]` 属性群 | ○ |
| C-03 | TempPE コンパイラサービスを登録 | E-01: 74-78行目 `AddService(typeof(ICSharpTempPECompilerService)` | ○ |
| C-04 | ICSharpProjectHost サービスを登録 | E-01: 83-88行目 `AddService(typeof(ICSharpProjectHost)` | ○ |
| C-05 | ObjectBrowserLibraryManager を登録 | E-01: 97-112行目 `RegisterObjectBrowserLibraryManager` メソッド | ○ |
| C-06 | CSharpEditorFactory を生成 | E-01: 149-155行目 `CreateEditorFactories` メソッド | ○ |
| C-07 | CSharpLanguageService を生成 | E-01: 157-158行目 `CreateLanguageService` メソッド | ○ |
| C-08 | MiscellaneousFilesWorkspace に登録 | E-01: 160-166行目 `RegisterMiscellaneousFilesWorkspaceInformation` | ○ |
| C-09 | オートメーションオブジェクトを提供 | E-01: 139-147行目 `GetAutomationObject` メソッド | ○ |
| C-10 | AdvancedOptionPage が AbstractOptionPage を継承 | E-02: 12行目 `class AdvancedOptionPage : AbstractOptionPage` | ○ |
| C-11 | 関連画面として C#詳細オプションページ | E-03: 画面No 34 | ○ |
| C-12 | 関連画面として C#書式設定オプションページ | E-03: 画面No 35 | ○ |
| C-13 | パッケージ GUID は CSharpPackageIdString | E-01: 57行目 `[Guid(Guids.CSharpPackageIdString)]` | ○ |
| C-14 | FatalError でエラーレポート | E-01: 90行目 `FatalError.ReportAndPropagateUnlessCanceled` | ○ |
| C-15 | バックグラウンドタスクで初期化 | E-01: 67行目 `isMainThreadTask: false` | ○ |
| C-16 | IVsUserSettingsQuery を実装 | E-01: 131-137行目 `NeedExport` メソッド | ○ |
| C-17 | パフォーマンス要件の具体的な数値 | **根拠なし** | △ |
| C-18 | Visual Studio バージョン互換性の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値が記載されたドキュメントが見つからない
  - 候補：性能要件定義書 / ベンチマーク結果 / 設計レビュー資料
- Visual Studio のサポートバージョンに関する公式ドキュメントが未参照
  - 候補：リリースノート / 互換性マトリクス / VSIX マニフェスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能
- 1: 中リスク - パフォーマンス要件は推測に基づく記述のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] オプションページの階層構造が実際の VS メニューと一致しているか確認
- [ ] プロジェクトシステムシムの互換性に関する記述が現在も有効か確認
- [ ] パフォーマンス要件について開発チームに確認
