---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 8
  claims_without_evidence: 4
confidence_derived: 0.67
---

# 根拠レポート：102-VS VB拡張

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.67**
  - 根拠あり：8 / 12、根拠なし：4
- 優先レビュー（高）
  1. **VB パッケージのソースコード**: リポジトリ内に見つからない
  2. **VB 固有のオプションページ実装**: 直接確認できず
  3. **VB 言語サービスの詳細実装**: 直接確認できず
  4. **VB コードモデルサービスの実装**: 直接確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義、102行目）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（関連画面情報、画面No 36）
- E-03: `src/VisualStudio/CSharp/Impl/CSharpPackage.cs`（C# 拡張の参考実装）
- E-04: Glob 検索結果（`src/VisualStudio/VisualBasic/**/*.cs` - No files found）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VB 拡張は Visual Studio 用言語サービスを提供 | E-01: 機能一覧.csv 102行目 | ○ |
| C-02 | ソースコードは src/VisualStudio/VisualBasic に配置 | E-01: 備考列 | ○ |
| C-03 | 関連画面として VB詳細オプションページ | E-02: 画面No 36 | ○ |
| C-04 | C# 拡張と同様のアーキテクチャ | E-03: CSharpPackage の実装パターンから推測 | ○ |
| C-05 | AbstractPackage を継承 | E-03: C# 実装からの類推 | ○ |
| C-06 | オブジェクトブラウザ統合 | E-03: C# 実装からの類推 | ○ |
| C-07 | エディタファクトリを生成 | E-03: C# 実装からの類推 | ○ |
| C-08 | 言語サービスを生成 | E-03: C# 実装からの類推 | ○ |
| C-09 | VisualBasicPackage.cs が存在 | E-04: Glob 検索で見つからず | △ |
| C-10 | VB 固有のオプションページ実装 | **根拠なし** - 直接確認できず | △ |
| C-11 | VB 固有のコードモデルサービス | **根拠なし** - 直接確認できず | △ |
| C-12 | VB 固有の構文対応（XML リテラル等） | **根拠なし** - 実装を直接確認できず | △ |

## 4) 不足情報（Unknown / Missing）
- VB 拡張のソースコードがリポジトリ内で見つからない
  - 候補：別リポジトリへの移動 / ビルド時に生成 / 別ディレクトリに配置
- VB 固有の機能実装の詳細
  - 候補：EditorFeatures/VisualBasic / Features/VisualBasic を確認

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - ソースコードが直接確認できないため、多くの記述が C# 拡張からの類推に基づく
- 1: 中リスク - 機能一覧に記載があるため機能自体は存在するはず

## 6) レビュアーチェックリスト（最小）
- [ ] VB 拡張のソースコードの実際の配置場所を確認
- [ ] VB 固有の機能（XML リテラル、Late Binding 等）のサポート状況を確認
- [ ] C# 拡張との機能差分を確認
- [ ] 機能一覧.csv の備考に記載されたパスが正しいか確認
