---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：103-VS コア

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **UI スレッド処理時間制限の根拠**: 実装からの推測
  2. **テレメトリパネルの詳細仕様**: 画面マッピングのみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Impl/RoslynVisualStudioWorkspace.cs`（1-192行目）
- E-02: `src/VisualStudio/Core/Impl/CodeModel/ProjectCodeModelFactory.cs`（1-287行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（関連画面情報）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RoslynVisualStudioWorkspace が VisualStudioWorkspaceImpl を継承 | E-01: 32行目 `class RoslynVisualStudioWorkspace : VisualStudioWorkspaceImpl` | ○ |
| C-02 | MEF でエクスポートされる | E-01: 30-31行目 `[Export(typeof(VisualStudioWorkspace))]` | ○ |
| C-03 | TryGoToDefinitionAsync でナビゲーション | E-01: 94-110行目 | ○ |
| C-04 | OpenInvisibleEditor で不可視エディタを開く | E-01: 55-88行目 | ○ |
| C-05 | GetBrowseObjectAsync でブラウザオブジェクト取得 | E-01: 125-191行目 | ○ |
| C-06 | ProjectCodeModelFactory が IProjectCodeModelFactory を実装 | E-02: 28-30行目 `[Export(typeof(IProjectCodeModelFactory))]` | ○ |
| C-07 | AsyncBatchingWorkQueue でバッチ処理 | E-02: 57-61行目 | ○ |
| C-08 | ドキュメント変更を監視 | E-02: 63行目 `RegisterWorkspaceChangedHandler` | ○ |
| C-09 | FireEventsForChangedDocumentsAsync でイベント発火 | E-02: 139-176行目 | ○ |
| C-10 | UI スレッドでの処理は最大 15ms 以内 | E-02: 148行目 `const int MaxTimeSlice = 15` | ○ |
| C-11 | 入力待ちキューをチェック | E-02: 184-196行目 `IsInputPending` | ○ |
| C-12 | CreateProjectCodeModel でプロジェクトコードモデル生成 | E-02: 239-248行目 | ○ |
| C-13 | GetOrCreateFileCodeModel でファイルコードモデル取得 | E-02: 272-273行目 | ○ |
| C-14 | 関連画面として詳細エラー情報ダイアログ | E-03: 画面No 52 | ○ |
| C-15 | 関連画面として VSテーマ辞書 | E-03: 画面No 54 | ○ |
| C-16 | 関連画面としてプロジェクションバッファマージン | E-03: 画面No 56 | ○ |
| C-17 | 関連画面としてテレメトリパネル | E-03: 画面No 57 | ○ |
| C-18 | Global Undo Transaction 内で編集可能 | E-01: 58行目 `globalUndoService` | ○ |
| C-19 | UI スレッド処理時間制限の設計意図 | **根拠なし** - 設計ドキュメントが見つからず | △ |
| C-20 | テレメトリパネルの詳細仕様 | **根拠なし** - 画面マッピングのみ | △ |

## 4) 不足情報（Unknown / Missing）
- UI スレッド処理時間制限（15ms）の設計根拠
  - 候補：パフォーマンス要件定義書 / 設計レビュー資料
- テレメトリパネルの詳細仕様
  - 候補：UI 仕様書 / XAML ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能
- 1: 中リスク - パフォーマンス制約の数値根拠が不明確

## 6) レビュアーチェックリスト（最小）
- [ ] RoslynVisualStudioWorkspace の各メソッドの動作を確認
- [ ] ProjectCodeModelFactory のイベント発火タイミングを確認
- [ ] 15ms の時間制限が実際に適切か確認
- [ ] 関連画面の実装状況を確認
