---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：104-CodeLens拡張

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **LSP ベース移行の具体的なスケジュール**: コメントからの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/CodeLens/ReferenceCodeLensProvider.cs`（1-313行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IAsyncCodeLensDataPointProvider を実装 | E-01: 39行目 `class ReferenceCodeLensProvider : IAsyncCodeLensDataPointProvider` | ○ |
| C-02 | C# と VB の両方に対応 | E-01: 33-34行目 `[ContentType(ContentTypeNames.CSharpContentType)]`, `[ContentType(ContentTypeNames.VisualBasicContentType)]` | ○ |
| C-03 | MEF でエクスポート | E-01: 31行目 `[Export(typeof(IAsyncCodeLensDataPointProvider))]` | ○ |
| C-04 | ポーリング間隔は 1.5 秒 | E-01: 99行目 `await Task.Delay(TimeSpan.FromSeconds(1.5)` | ○ |
| C-05 | ApplicableSpan で作成可否判定 | E-01: 68行目 `descriptorContext.ApplicableSpan.HasValue` | ○ |
| C-06 | DataPoint クラスが内部で定義 | E-01: 154行目 `private sealed class DataPoint` | ○ |
| C-07 | ヘッダーに12列が定義 | E-01: 156-170行目 `s_header` リスト | ○ |
| C-08 | GetDataAsync で参照数取得 | E-01: 197行目 `public async Task<CodeLensDataPointDescriptor?> GetDataAsync` | ○ |
| C-09 | GetDetailsAsync で参照一覧取得 | E-01: 242行目 `public async Task<CodeLensDetailsDescriptor> GetDetailsAsync` | ○ |
| C-10 | CallbackService で devenv と通信 | E-01: 203-207行目 `await _callbackService.InvokeAsync` | ○ |
| C-11 | Method, Type, Property に対応 | E-01: 228-237行目 switch 文 | ○ |
| C-12 | InvalidatedAsync イベントで更新通知 | E-01: 193行目 `public event AsyncEventHandler? InvalidatedAsync` | ○ |
| C-13 | Invalidate で更新トリガー | E-01: 306-311行目 `internal void Invalidate()` | ○ |
| C-14 | プロジェクト GUID でグループ化 | E-01: 50行目 `Dictionary<Guid, (string version, HashSet<DataPoint> dataPoints)>` | ○ |
| C-15 | LSP ベースへの移行予定 | E-01: 94行目コメント `This behavior is expected to change when CodeLens is rewritten using LSP` | ○ |
| C-16 | LSP 移行の具体的なスケジュール | **根拠なし** - コメントからの推測 | △ |

## 4) 不足情報（Unknown / Missing）
- LSP ベース CodeLens への移行スケジュール
  - 候補：ロードマップドキュメント / GitHub Issues / 設計提案書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほぼすべての記述がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ポーリング間隔 1.5 秒が適切か確認
- [ ] OOP 設計の制約による影響を確認
- [ ] パフォーマンスへの影響を確認
