---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：105-LiveShare連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティポリシーの詳細**: LiveShare 側のドキュメント参照が必要
  2. **パフォーマンス要件の具体値**: 記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/LiveShare/Impl/LiveShareInitializeHandler.cs`（1-61行目）
- E-02: `src/VisualStudio/LiveShare/Impl/LiveShareConstants.cs`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ILspRequestHandler を実装 | E-01: 16行目 `class LiveShareInitializeHandler : ILspRequestHandler<InitializeParams, InitializeResult, Solution>` | ○ |
| C-02 | CodeActionProvider は false | E-01: 22行目 `CodeActionProvider = false` | ○ |
| C-03 | ReferencesProvider は true | E-01: 23行目 `ReferencesProvider = true` | ○ |
| C-04 | RenameProvider は false | E-01: 24行目 `RenameProvider = false` | ○ |
| C-05 | InitializeResult を返す | E-01: 28-29行目 `Task<InitializeResult> HandleAsync` | ○ |
| C-06 | CSharpInitializeHandlerShim が存在 | E-01: 43-51行目 | ○ |
| C-07 | VisualBasicInitializeHandlerShim が存在 | E-01: 53-61行目 | ○ |
| C-08 | RoslynInitializeHandlerShim は Obsolete | E-01: 33行目 `[Obsolete("Used for backwards compatibility with old liveshare clients.")]` | ○ |
| C-09 | ExportLspRequestHandler 属性で登録 | E-01: 32, 43, 53行目 | ○ |
| C-10 | LiveShareConstants でコントラクト名定義 | E-01: 32行目 `LiveShareConstants.RoslynContractName` | ○ |
| C-11 | ImportingConstructor を使用 | E-01: 36-40, 45-50, 55-60行目 | ○ |
| C-12 | MefConstruction メッセージを使用 | E-01: 37, 46, 56行目 | ○ |
| C-13 | セキュリティポリシーの詳細 | **根拠なし** - LiveShare 側のドキュメント参照が必要 | △ |
| C-14 | パフォーマンス要件の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- LiveShare のセキュリティポリシーに関する詳細
  - 候補：LiveShare ドキュメント / セキュリティ設計書
- ネットワーク遅延のパフォーマンス要件
  - 候補：パフォーマンス要件定義書 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能
- 1: 中リスク - セキュリティ関連の記述は LiveShare 側の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ServerCapabilities の設定が現在も有効か確認
- [ ] 後方互換性用の Obsolete ハンドラが削除可能か確認
- [ ] LiveShare 側のセキュリティ要件を確認
