---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：106-Razor連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **RazorLanguageServiceClientFactory の実装詳細**: ファイルが確認できていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Razor/RazorLanguageServiceClient.cs`（1-87行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RazorLanguageServiceClient は Obsolete | E-01: 19行目 `[Obsolete("Use Microsoft.CodeAnalysis.ExternalAccess.Razor.RazorRemoteHostClient instead")]` | ○ |
| C-02 | RemoteHostClient を使用 | E-01: 21行目 `private readonly RemoteHostClient _client` | ○ |
| C-03 | RemoteServiceName を使用 | E-01: 22行目 `private readonly RemoteServiceName _serviceName` | ○ |
| C-04 | TryRunRemoteAsync メソッドが存在 | E-01: 30-31行目 | ○ |
| C-05 | Solution が null なら null を返す | E-01: 36-40行目 `if (solution == null) { return null; }` | ○ |
| C-06 | CreateSessionAsync は Obsolete | E-01: 33行目 `[Obsolete("Use TryRunRemoteAsync instead")]` | ○ |
| C-07 | SessionWithSolution を使用 | E-01: 48行目 `SessionWithSolution.CreateAsync` | ○ |
| C-08 | 内部クラス Session が存在 | E-01: 62-85行目 | ○ |
| C-09 | Session.InvokeAsync メソッド | E-01: 71-78行目 | ○ |
| C-10 | Session は IDisposable | E-01: 80-84行目 `public void Dispose()` | ○ |
| C-11 | AspNetCore-Tooling で使用 | E-01: 17行目コメント | ○ |
| C-12 | OOPTagHelperResolver が参照 | E-01: 17行目コメント | ○ |
| C-13 | RunRemoteAsync でリモート呼び出し | E-01: 31, 73, 78行目 | ○ |
| C-14 | RazorLanguageServiceClientFactory の詳細 | **根拠なし** - ファイル未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- RazorLanguageServiceClientFactory.cs の実装詳細
  - 候補：同ディレクトリの別ファイル / 別リポジトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能
- 0: 低リスク - Obsolete API であるため新規利用は想定外

## 6) レビュアーチェックリスト（最小）
- [ ] Obsolete 属性の推奨代替 API（RazorRemoteHostClient）を確認
- [ ] AspNetCore-Tooling リポジトリでの使用状況を確認
- [ ] ExternalAccess.Razor の実装を確認
