---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：107-XAML連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **XAML デザイナーとの連携詳細**: 直接確認できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Xaml/Impl/Implementation/XamlProjectService.cs`（1-277行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）
- E-03: Glob 検索結果（XAML 関連ファイル一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XamlProjectService が MEF エクスポート | E-01: 29行目 `[Export]` | ○ |
| C-02 | IDisposable を実装 | E-01: 30行目 `partial class XamlProjectService : IDisposable` | ○ |
| C-03 | TrackOpenDocument メソッドが存在 | E-01: 71-108行目 | ○ |
| C-04 | EnsureDocument でプロジェクト登録 | E-01: 110-194行目 | ○ |
| C-05 | ConcurrentDictionary でドキュメント管理 | E-01: 38行目 `ConcurrentDictionary<string, DocumentId> _documentIds` | ○ |
| C-06 | RDT を使用 | E-01: 41行目 `private RunningDocumentTable? _rdt` | ○ |
| C-07 | IVsSolution を使用 | E-01: 42行目 `private IVsSolution? _vsSolution` | ○ |
| C-08 | OnDocumentClosed でクリーンアップ | E-01: 196-213行目 | ○ |
| C-09 | OnProjectClosing でプロジェクト削除 | E-01: 215-223行目 | ○ |
| C-10 | OnDocumentMonikerChanged でファイル名変更対応 | E-01: 224-261行目 | ○ |
| C-11 | 空のファイルパスは null を返す | E-01: 73-77行目 | ○ |
| C-12 | ArgumentException で RDT なしを処理 | E-01: 131-135行目 | ○ |
| C-13 | StringConstants.XamlLanguageName を使用 | E-01: 162行目 | ○ |
| C-14 | VisualStudioProjectFactory を使用 | E-01: 34, 161-162行目 | ○ |
| C-15 | IXamlDocumentAnalyzerService を使用 | E-01: 51, 69行目 | ○ |
| C-16 | RegisterDocumentClosedHandler でイベント登録 | E-01: 63行目 | ○ |
| C-17 | TryGetTextBufferFromDocData でバッファ取得 | E-01: 268-276行目 | ○ |
| C-18 | XAML デザイナーとの連携詳細 | **根拠なし** - 直接確認できず | △ |

## 4) 不足情報（Unknown / Missing）
- XAML デザイナーとの連携の詳細
  - 候補：デザイナー関連のソースコード / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各 IXaml*Service インターフェースの実装を確認
- [ ] RDT イベント処理の動作を確認
- [ ] プロジェクト登録/削除のタイミングを確認
