---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：108-エディタ機能基盤

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **増分更新の詳細アルゴリズム**: TagComputer の詳細確認が必要
  2. **パフォーマンス最適化の具体値**: 記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EditorFeatures/Core/Classification/Syntactic/SyntacticClassificationTaggerProvider.cs`（1-36行目）
- E-02: `src/EditorFeatures/Core/InlineRename/InlineRenameService.cs`（1-192行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（関連画面情報）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SyntacticClassificationTaggerProvider が存在 | E-01: 18行目クラス定義 | ○ |
| C-02 | TaggerHost と ClassificationTypeMap を受け取る | E-01: 18行目コンストラクタ | ○ |
| C-03 | CreateTagger メソッドが存在 | E-01: 27行目 | ○ |
| C-04 | SyntacticColorizerOptionsStorage でオプション確認 | E-01: 30行目 | ○ |
| C-05 | TagComputer.GetOrCreate でタガー生成 | E-01: 34行目 | ○ |
| C-06 | InlineRenameService が MEF エクスポート | E-02: 26-27行目 `[Export]` | ○ |
| C-07 | StartInlineSession メソッドが存在 | E-02: 50行目 | ○ |
| C-08 | StartInlineSessionAsync で非同期開始 | E-02: 58行目 | ○ |
| C-09 | アクティブセッションは1つのみ | E-02: 63-65行目 例外チェック | ○ |
| C-10 | ActiveSession プロパティで管理 | E-02: 160-181行目 | ○ |
| C-11 | ActiveSessionChanged イベント | E-02: 186行目 | ○ |
| C-12 | 関連画面としてリネームフライアウト | E-03: 画面No 21 | ○ |
| C-13 | 関連画面としてリネームユーザー入力 | E-03: 画面No 22 | ○ |
| C-14 | IEditorInlineRenameService を使用 | E-02: 68行目 | ○ |
| C-15 | 増分更新の詳細アルゴリズム | **根拠なし** - TagComputer の詳細確認が必要 | △ |
| C-16 | パフォーマンス最適化の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TagComputer の増分更新アルゴリズムの詳細
  - 候補：SyntacticClassificationTaggerProvider.TagComputer.cs
- パフォーマンス要件の具体的な数値
  - 候補：パフォーマンス要件定義書 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能
- 1: 中リスク - パフォーマンス関連の記述は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TagComputer の実装を確認
- [ ] InlineRenameSession の動作を確認
- [ ] LSP クライアントの実装を確認
