---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：109-C#エディタ機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **イベントハンドラ生成の詳細フロー**: 複数ファイルにまたがる実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/EditorFeatures/CSharp/InlineRename/CSharpEditorInlineRenameService.cs`（1-170行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）
- E-03: Glob 検索結果（C# EditorFeatures ファイル一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExportLanguageService で C# 用にエクスポート | E-01: 24行目 `[ExportLanguageService(typeof(IEditorInlineRenameService), LanguageNames.CSharp)]` | ○ |
| C-02 | AbstractEditorInlineRenameService を継承 | E-01: 27-28行目 | ○ |
| C-03 | NumberOfContextLines = 20 | E-01: 30行目 `private const int NumberOfContextLines = 20` | ○ |
| C-04 | MaxDefinitionCount = 10 | E-01: 31行目 `private const int MaxDefinitionCount = 10` | ○ |
| C-05 | MaxReferenceCount = 50 | E-01: 32行目 `private const int MaxReferenceCount = 50` | ○ |
| C-06 | GetRenameContextAsync メソッドが存在 | E-01: 38行目 | ○ |
| C-07 | MemberDeclarationSyntax で定義を検索 | E-01: 50行目 | ○ |
| C-08 | StatementSyntax で文を検索 | E-01: 51行目 | ○ |
| C-09 | GetDocumentationCommentXml でドキュメント取得 | E-01: 61行目 | ○ |
| C-10 | definition キーで定義コンテキスト | E-01: 97行目 | ○ |
| C-11 | reference キーで参照コンテキスト | E-01: 100行目 | ○ |
| C-12 | documentation キーでドキュメント | E-01: 104行目 | ○ |
| C-13 | ImmutableDictionary を返却 | E-01: 108行目 | ○ |
| C-14 | Copilot 連携コメント | E-01: 36-37行目コメント | ○ |
| C-15 | AddSpanOfInterest でスニペット収集 | E-01: 110-168行目 | ○ |
| C-16 | イベントハンドラ生成の詳細フロー | **根拠なし** - EventHookupCommandHandler の詳細確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- EventHookupCommandHandler の詳細実装
  - 候補：EventHookupSessionManager.cs / EventHookupSession.cs

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能記述はソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GetRenameContextAsync の動作を確認
- [ ] 各コマンドハンドラの実装を確認
- [ ] Copilot 連携の動作を確認
