---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-シグネチャヘルプ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **レスポンス時間要件（100ms以内）**：明示的なコード規定なし
  2. **OOP実行による非ブロッキング**：推測に基づく記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/SignatureHelp/ISignatureHelpProvider.cs` - TriggerCharacters/RetriggerCharacters定義
- E-02: `src/Features/Core/Portable/SignatureHelp/SignatureHelpService.cs` - サービス実装、プロバイダ選択ロジック
- E-03: `src/Features/Core/Portable/SignatureHelp/AbstractSignatureHelpProvider.cs` - 基底クラス実装
- E-04: `src/Features/Core/Portable/SignatureHelp/SignatureHelpItem.cs` - アイテムモデル定義
- E-05: `src/Features/Core/Portable/SignatureHelp/SignatureHelpItems.cs` - アイテム集合モデル定義
- E-06: `src/Features/Core/Portable/SignatureHelp/SignatureHelpParameter.cs` - パラメータモデル定義
- E-07: `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerInfo.cs` - トリガー情報定義
- E-08: `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerReason.cs` - トリガー理由列挙型
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シグネチャヘルプはメソッド呼び出し時にパラメータ情報を表示する | E-01, E-04 | ○ |
| C-02 | TriggerCharactersで開始トリガー文字を定義 | E-01 (17行目) | ○ |
| C-03 | RetriggerCharactersで終了トリガー文字を定義 | E-01 (23行目) | ○ |
| C-04 | SignatureHelpServiceが言語別プロバイダを管理 | E-02 (27-36行目) | ○ |
| C-05 | ApplicableSpan.Startが最も大きい結果を優先選択 | E-02 (96-98行目) | ○ |
| C-06 | SignatureHelpItemはIsVariadicで可変長パラメータを表現 | E-04 (23行目) | ○ |
| C-07 | SignatureHelpItemsはApplicableSpan/SemanticParameterIndexを保持 | E-05 (26, 36行目) | ○ |
| C-08 | 名前付き引数によるフィルタリングをサポート | E-03 (93-108行目) | ○ |
| C-09 | リンクドファイル（共有プロジェクト）対応 | E-03 (249-316行目) | ○ |
| C-10 | SupportedPlatformDataでプラットフォーム可用性を表示 | E-03 (290, 318-336行目) | ○ |
| C-11 | SignatureHelpTriggerReasonは3種類の列挙値を持つ | E-08 (8-23行目) | ○ |
| C-12 | SignatureHelpTriggerInfoはTriggerReasonとTriggerCharacterを保持 | E-07 (9-10行目) | ○ |
| C-13 | パラメータはName, IsOptional, DisplayPartsを持つ | E-06 (32, 60, 54行目) | ○ |
| C-14 | DocumentationFactoryでドキュメント取得を遅延実行 | E-06 (38行目), E-04 (36行目) | ○ |
| C-15 | MEFによるプロバイダのエクスポート・インポート | E-02 (22-25行目) | ○ |
| C-16 | GetItemsAsyncがキャンセルトークンを受け取る | E-01 (28行目) | ○ |
| C-17 | CreateSignatureHelpItemsでフィルタリングと結果生成 | E-03 (36-66行目) | ○ |
| C-18 | 匿名型・タプル型の特殊表示対応 | E-03 (187-193行目) | ○ |
| C-19 | SemanticParameterIndexが0未満の場合はエラー | E-05 (73-74行目) | ○ |
| C-20 | 重複するアイテムは除去される | E-05 (77-92行目) | ○ |
| C-21 | SymbolKey使用によるシンボル解決 | E-03 (263-276行目) | ○ |
| C-22 | コレクション初期化子の特別処理 | E-03 (68-91行目) | ○ |
| C-23 | TryGetSelectedIndexでオーバーロード選択 | E-03 (338-348行目) | ○ |
| C-24 | レスポンス時間100ms以内の要件 | **根拠なし** | △ |
| C-25 | OOP実行でUIスレッドをブロックしない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（レスポンス時間）に関するコード規定が見つからない
  - 候補：テストコード / パフォーマンステスト / 設計ドキュメント
- OOP（Out-of-Process）実行の詳細
  - 候補：Remote呼び出しコード / ServiceHub設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データモデルとインターフェース定義は明確
- 0: 低リスク - 処理フローはコードから正確に追跡可能
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] トリガー文字の種類と動作がコードと一致しているか確認
- [ ] 名前付き引数フィルタリングの動作を実際のコードで確認
- [ ] パフォーマンス要件の根拠を確認（必要に応じて削除または修正）
- [ ] OOP実行に関する記述の正確性を確認
