---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：111-テキストエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **キャッシュヒット率95%以上**：パフォーマンス要件の数値根拠なし
  2. **マイクロ秒オーダー**：パフォーマンス要件の数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/EditorFeatures/Text/Extensions.cs` (14-105行目)
- E-02: `src/EditorFeatures/Text/Extensions.SnapshotSourceText.cs` (24-376行目)
- E-03: `src/EditorFeatures/Text/ContentTypeNames.cs` (8-19行目)
- E-04: `src/EditorFeatures/Text/Implementation/TextBufferFactoryService/ITextBufferCloneService.cs` (11-36行目)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (111行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ITextBufferからSourceTextContainerへの変換機能を提供 | E-01 (14-15行目: AsTextContainer) | ○ |
| C-02 | SourceTextContainerからITextBufferへの変換機能を提供 | E-01 (17-21行目: GetTextBuffer, TryGetTextBuffer) | ○ |
| C-03 | ITextSnapshotからSourceTextへの変換機能を提供 | E-01 (39-43行目: AsText) | ○ |
| C-04 | SnapshotSourceTextがSourceTextの実装を提供 | E-02 (24行目: class SnapshotSourceText : SourceText) | ○ |
| C-05 | s_textSnapshotMapでスナップショットをキャッシュ | E-02 (62行目: ConditionalWeakTable) | ○ |
| C-06 | 弱参照マップでエディタスナップショットを管理 | E-02 (68行目: s_textImageToEditorSnapshotMap) | ○ |
| C-07 | From静的メソッドでキャッシュ付きファクトリを提供 | E-02 (70-89行目) | ○ |
| C-08 | WithChangesでテキスト変更の効率的な適用 | E-02 (184-224行目) | ○ |
| C-09 | GetChangeRangesで変更範囲を計算 | E-02 (317-343行目) | ○ |
| C-10 | ITextBufferCloneServiceでバッファクローン機能を提供 | E-04 (11-36行目) | ○ |
| C-11 | C#, VB, XAMLなどのコンテンツタイプをサポート | E-03 (8-19行目) | ○ |
| C-12 | TextBufferContainerでSourceTextContainerを実装 | E-01 (14-15行目), 推測 | ○ |
| C-13 | ReiteratedVersionNumberでコンテンツ同一性を判定 | E-02 (366-372行目) | ○ |
| C-14 | ChangedSourceTextで変更適用後のテキストを管理 | E-02 (275-307行目) | ○ |
| C-15 | GetWorkspaceでテキストバッファからWorkspaceを取得 | E-01 (51-60行目) | ○ |
| C-16 | GetRelatedDocumentsWithChangesで関連ドキュメントを取得 | E-01 (67-68行目) | ○ |
| C-17 | キャッシュヒット率95%以上を期待 | **根拠なし** | △ |
| C-18 | スナップショット変換はマイクロ秒オーダー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-17, C-18）の数値的根拠がソースコード内に見当たらない
  - 候補：ベンチマークテスト結果 / パフォーマンスドキュメント / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要な機能・処理フローはソースコードから確認済み
- パフォーマンス要件は経験則または設計意図に基づく可能性があり、実測値での確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 Extensions.csの拡張メソッドが設計書の記述と一致するか確認
- [ ] E-02 SnapshotSourceTextのキャッシュ機構が正しく記述されているか確認
- [ ] パフォーマンス要件の数値（95%, マイクロ秒）が適切かプロジェクトメンバーに確認
- [ ] Visual Studio Editor API との互換性について追加情報が必要か判断
