---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：112-Roslynアナライザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **NuGetパッケージ公開**：公開状況の最新確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/Core/AbstractAllocationAnalyzer.cs` (11-149行目)
- E-02: `src/RoslynAnalyzers/PublicApiAnalyzers/Core/Analyzers/DeclarePublicApiAnalyzer.cs` (17-409行目)
- E-03: `src/RoslynAnalyzers/PerformanceSensitiveAnalyzers/Core/AllocationRules.cs`
- E-04: `src/RoslynAnalyzers/Microsoft.CodeAnalysis.Analyzers/Core/DiagnosticIds.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (112行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (48行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | [PerformanceSensitive]属性付きメソッドのみ割り当て分析を実行 | E-01 (29-45行目: RegisterCompilationStartAction) | ○ |
| C-02 | AttributeCheckerで属性情報を取得 | E-01 (64-128行目: AttributeChecker class) | ○ |
| C-03 | PerformanceSensitiveInfoで許可フラグを管理 | E-01 (131-147行目: PerformanceSensitiveInfo struct) | ○ |
| C-04 | EnableConcurrentExecutionで並行実行を有効化 | E-01 (19行目) | ○ |
| C-05 | ConfigureGeneratedCodeAnalysisで生成コード分析を設定 | E-01 (22行目) | ○ |
| C-06 | RegisterOperationActionでオペレーション分析を登録 | E-01 (56-61行目) | ○ |
| C-07 | PublicAPI.Shipped.txtとPublicAPI.Unshipped.txtを使用 | E-02 (24-31行目: ファイル名定数) | ○ |
| C-08 | *REMOVED*プレフィックスで削除APIを記録 | E-02 (37行目: RemovedApiPrefix) | ○ |
| C-09 | #nullable enableでNullable追跡を有効化 | E-02 (38行目: NullableEnable) | ○ |
| C-10 | ShippedファイルにREMOVEDマーカーがあるとエラー | E-02 (39行目: InvalidReasonShippedCantHaveRemoved) | ○ |
| C-11 | Public/Internalの両方のAPI追跡をサポート | E-02 (109-110行目: isPublic: true/false) | ○ |
| C-12 | RegisterSymbolActionでシンボル分析を登録 | E-02 (142-148行目) | ○ |
| C-13 | EditorConfig設定でアナライザー動作を制御 | E-02 (50-52行目: EditorConfigオプション) | ○ |
| C-14 | SourceTextValueProviderでAPIデータをキャッシュ | E-02 (20-21行目: s_shippingApiDataProvider) | ○ |
| C-15 | s_publicApiFormatでシンボル表示形式を定義 | E-02 (70-89行目) | ○ |
| C-16 | Nullability情報を含む表示形式もサポート | E-02 (91-95行目: s_publicApiFormatWithNullability) | ○ |
| C-17 | 重複シンボルを検出してエラー報告 | E-02 (391-407行目: ValidateApiList) | ○ |
| C-18 | アナライザー設定ビューで設定可能 | E-06 (48行目) | ○ |
| C-19 | パフォーマンス敏感コードでの割り当て警告を提供 | E-01, E-03 | ○ |
| C-20 | PublicApiAnalyzersはNuGetパッケージとして公開 | **根拠なし（外部確認必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- PublicApiAnalyzersのNuGet公開状況（C-20）
  - 候補：nuget.org / プロジェクトのREADME / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：主要なアナライザー機能はソースコードから十分確認済み
- NuGet公開に関する記述は外部情報との照合を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] E-01 AbstractAllocationAnalyzer.csの属性チェック処理が正しく記述されているか確認
- [ ] E-02 DeclarePublicApiAnalyzer.csのファイル形式・検証ロジックが設計書と一致するか確認
- [ ] NuGetでのPublicApiAnalyzers公開状況を確認
- [ ] 診断IDとエラーメッセージの対応が最新か確認
