---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：113-C#アナライザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **IDE診断ID範囲**：IDE0001-IDE0999の範囲確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Analyzers/CSharp/Analyzers/` ディレクトリ構造（Glob結果）
- E-02: `src/Analyzers/CSharp/Analyzers/UsePatternMatching/` 各ファイル
- E-03: `src/Analyzers/CSharp/Analyzers/UseImplicitOrExplicitType/` 各ファイル
- E-04: `src/Analyzers/CSharp/Analyzers/CodeStyle/CSharpAnalyzerOptionsProvider.cs`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (113行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パターンマッチング推奨アナライザーを提供 | E-02（UsePatternMatchingディレクトリ） | ○ |
| C-02 | var使用推奨アナライザーを提供 | E-03（UseImplicitOrExplicitTypeディレクトリ） | ○ |
| C-03 | switch式変換アナライザーを提供 | E-01（ConvertSwitchStatementToExpressionディレクトリ） | ○ |
| C-04 | 不要using削除アナライザーを提供 | E-01（RemoveUnnecessaryImportsディレクトリ） | ○ |
| C-05 | C#固有のオプションプロバイダーを提供 | E-04 | ○ |
| C-06 | EditorConfig設定に基づくルール適用 | E-04, コードから推測 | ○ |
| C-07 | 名前空間・using整理機能を提供 | E-01（MisplacedUsingDirectivesディレクトリ） | ○ |
| C-08 | フォーマット分析機能を提供 | E-01（Formattingディレクトリ） | ○ |
| C-09 | インライン宣言推奨を提供 | E-01（InlineDeclarationディレクトリ） | ○ |
| C-10 | 簡潔なusing宣言推奨を提供 | E-01（UseSimpleUsingStatementディレクトリ） | ○ |
| C-11 | 条件式変換アナライザーを提供 | E-01（UseConditionalExpressionディレクトリ） | ○ |
| C-12 | Null合体演算子推奨を提供 | E-01（UseCoalesceExpressionディレクトリ） | ○ |
| C-13 | アクセシビリティ修飾子追加を提供 | E-01（AddAccessibilityModifiersディレクトリ） | ○ |
| C-14 | 自動プロパティ推奨を提供 | E-01（UseAutoPropertyディレクトリ） | ○ |
| C-15 | IDE0001-IDE0999の診断ID範囲 | **根拠なし（慣例的）** | △ |

## 4) 不足情報（Unknown / Missing）
- 診断ID範囲の公式ドキュメント
  - 候補：Microsoftドキュメント / Roslyn GitHub Wiki

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ディレクトリ構造からアナライザーの存在は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 主要アナライザーファイルの存在確認
- [ ] 診断ID範囲が現在の実装と一致するか確認
- [ ] EditorConfig連携の動作確認
