---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 8
  claims_with_evidence: 5
  claims_without_evidence: 3
confidence_derived: 0.63
---

# 根拠レポート：114-VBアナライザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.63**
  - 根拠あり：5 / 8、根拠なし：3
- 優先レビュー（高）
  1. **VBアナライザーファイルの存在**：Glob検索で該当ファイルが見つからなかった
  2. **VB固有実装の確認**：共有実装か専用実装かの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `docs/code-to-docs/機能一覧/機能一覧.csv` (114行目)
- E-02: `src/Analyzers/Core/Analyzers/` ディレクトリ（共通基盤）
- E-03: Glob検索結果（src/Analyzers/VisualBasic/**/*.cs = No files found）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VB言語固有のコード分析ルールを提供 | E-01 | ○ |
| C-02 | src/Analyzers/VisualBasicにVBアナライザーが存在 | E-03 **ファイルなし** | △ |
| C-03 | C#アナライザーと共通の基盤を使用 | E-02 | ○ |
| C-04 | VB固有構文のパターン分析を提供 | **根拠なし** | △ |
| C-05 | コアアナライザーのVB言語バインディング | E-02（推測） | ○ |
| C-06 | VB特有のコードフィックス提供 | **根拠なし** | △ |
| C-07 | IDE診断IDを使用 | E-02（C#と共通） | ○ |
| C-08 | リアルタイムコード分析をサポート | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- src/Analyzers/VisualBasicディレクトリ内のソースファイル
  - 候補：別ディレクトリに配置 / コンパイル時生成 / 共有実装として存在
- VB固有アナライザーの実装詳細

## 5) リスクフラグ（レビュー観点）
- 2（高リスク）：指定されたディレクトリにファイルが見つからず、設計書の正確性に疑問
- 機能一覧.csvの参照先が正しいか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] src/Analyzers/VisualBasicディレクトリの実際の内容を確認
- [ ] VBアナライザーが別の場所に実装されていないか確認
- [ ] C#アナライザーとの共有実装の範囲を確認
- [ ] 機能一覧.csvの参照先パスの正確性を検証
