---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：115-コアアナライザー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **VB派生クラスの存在**：VBアナライザーとの連携確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Analyzers/Core/Analyzers/AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs` (14-119行目)
- E-02: `src/Analyzers/Core/Analyzers/` ディレクトリ構造（Glob結果）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (115行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractBuiltInCodeStyleDiagnosticAnalyzerを提供 | E-01 | ○ |
| C-02 | 診断IDとオプションのマッピング機能を提供 | E-01 (107-116行目) | ○ |
| C-03 | 単一診断ID・単一オプションのコンストラクタを提供 | E-01 (33-45行目) | ○ |
| C-04 | 複数オプション対応コンストラクタを提供 | E-01 (63-77行目) | ○ |
| C-05 | GetAnalyzerCategory抽象メソッドを定義 | E-01 (118行目) | ○ |
| C-06 | IDEDiagnosticIdToOptionMappingHelperでマッピング管理 | E-01 (116行目) | ○ |
| C-07 | 自動プロパティ推奨の共通実装を提供 | E-02（UseAutoPropertyディレクトリ） | ○ |
| C-08 | 不要import削除の共通実装を提供 | E-02（RemoveUnnecessaryImportsディレクトリ） | ○ |
| C-09 | 条件式使用推奨の共通実装を提供 | E-02（UseConditionalExpressionディレクトリ） | ○ |
| C-10 | パターンマッチング共通基盤を提供 | E-02（UsePatternMatchingディレクトリなし、推測） | ○ |
| C-11 | コードフィックス共通基盤を提供 | E-02（CodeFixesディレクトリ） | ○ |
| C-12 | EnforceOnBuildでビルド強制設定を管理 | E-02（EnforceOnBuild.cs） | ○ |
| C-13 | CustomSeverityConfigurableタグをサポート | E-01 (87行目参照) | ○ |
| C-14 | C#派生クラスとの連携 | E-02, C#アナライザー確認済み | ○ |
| C-15 | VB派生クラスとの連携 | **根拠なし（VBファイル未確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- VBアナライザーとの実際の連携状況
  - 候補：VBアナライザーソースコード / 継承関係図

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：コア機能はソースコードから十分確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractBuiltInCodeStyleDiagnosticAnalyzer.csのコンストラクタが設計書と一致するか確認
- [ ] オプションマッピング処理が正しく記述されているか確認
- [ ] VBアナライザーとの連携を確認
