---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：116-コードスタイル分析

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **EditorConfig解析処理の詳細**：具体的な解析コードの確認が必要
  2. **命名規則機能の詳細**：NamingStyle関連コードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.cs`
- E-02: `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.MefHostExportProvider.cs` (21-71行目)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (116行目)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (関連画面)
- E-05: `src/CodeStyle/Tools/Program.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MEFホストサービスによる言語サービス統合 | E-02 | ○ |
| C-02 | 言語別アセンブリをロード | E-02 (35-52行目: CreateAssemblies) | ○ |
| C-03 | C#用CodeStyle.Fixesアセンブリを使用 | E-02 (43行目) | ○ |
| C-04 | VB用CodeStyle.Fixesアセンブリを使用 | E-02 (47行目) | ○ |
| C-05 | MEFエクスポートの取得機能を提供 | E-02 (55-63行目) | ○ |
| C-06 | 画面27-46で設定UIを提供 | E-04 | ○ |
| C-07 | グリッドオプションプレビューを提供 | E-04 (27行目) | ○ |
| C-08 | 命名スタイルオプションページを提供 | E-04 (30行目) | ○ |
| C-09 | 設定エディタコントロールを提供 | E-04 (37行目) | ○ |
| C-10 | EditorConfigファイルの解析機能 | **根拠なし（推測）** | △ |
| C-11 | 命名規則の定義と検証 | **根拠なし（UI参照のみ）** | △ |
| C-12 | DefaultAssembliesと追加アセンブリをマージ | E-02 (51-52行目) | ○ |
| C-13 | ContainerConfigurationでMEFコンテナ作成 | E-02 (31-32行目) | ○ |
| C-14 | WithMetadataImporterでメタデータ付きエクスポート | E-02 (65-69行目) | ○ |
| C-15 | dotnet_style_*プレフィックスをサポート | E-03, 一般知識 | ○ |
| C-16 | csharp_style_*プレフィックスをサポート | E-03, 一般知識 | ○ |

## 4) 不足情報（Unknown / Missing）
- EditorConfig解析の具体的な実装コード（C-10）
  - 候補：Roslyn Workspaces / AnalyzerConfigOptionsProvider
- 命名規則検証の実装詳細（C-11）
  - 候補：NamingStyleDiagnosticAnalyzer / 関連コードファイル

## 5) リスクフラグ（レビュー観点）
- 1（中リスク）：MEFホスト部分は確認済みだが、EditorConfig解析の詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] MefHostExportProvider.csの処理が設計書と一致するか確認
- [ ] 画面機能マッピングの関連画面が正しく記載されているか確認
- [ ] EditorConfig解析の実装コードを追加調査
- [ ] 命名規則機能の実装詳細を追加調査
