---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：117-AnalyzerRunner

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Tools/AnalyzerRunner/Program.cs` (27-243行目)
- E-02: `src/Tools/AnalyzerRunner/DiagnosticAnalyzerRunner.cs` (23-491行目)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (117行目)
- E-04: `src/Tools/AnalyzerRunner/` ディレクトリ内ファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドラインからアナライザー実行 | E-01 (29行目: Main) | ○ |
| C-02 | Options.Createでオプション解析 | E-01 (34行目) | ○ |
| C-03 | AnalyzerRunnerHelper.CreateWorkspace使用 | E-01 (58行目) | ○ |
| C-04 | workspace.OpenSolutionAsyncでソリューション読み込み | E-01 (78行目) | ○ |
| C-05 | IncrementalAnalyzerRunnerを初期化 | E-01 (60行目) | ○ |
| C-06 | DiagnosticAnalyzerRunnerを初期化 | E-01 (61行目) | ○ |
| C-07 | CodeRefactoringRunnerを初期化 | E-01 (62行目) | ○ |
| C-08 | 5秒待機を実行 | E-01 (102-103行目) | ○ |
| C-09 | AD0001/AD0002をエラー化 | E-02 (49-51行目: SetOptions) | ○ |
| C-10 | C#/VBプロジェクトのみ分析 | E-02 (46-47行目, 97-98行目) | ○ |
| C-11 | アナライザーアセンブリから診断アナライザー取得 | E-02 (285-312行目: GetDiagnosticAnalyzers) | ○ |
| C-12 | テレメトリ情報を収集・表示 | E-02 (407-441行目: WriteTelemetry) | ○ |
| C-13 | ドキュメント単位のパフォーマンステスト | E-02 (178-198行目: TestDocumentPerformanceAsync) | ○ |
| C-14 | GetAnalysisResultAsyncで分析実行 | E-02 (314-369行目) | ○ |
| C-15 | GetProjectAnalysisResultAsyncでプロジェクト分析 | E-02 (379-405行目) | ○ |
| C-16 | 並行実行オプションをサポート | E-02 (340-343行目, 386-388行目) | ○ |
| C-17 | ログファイル出力をサポート | E-02 (172-175行目, 200-230行目) | ○ |
| C-18 | ヘルプメッセージを表示 | E-01 (226-241行目: PrintHelp) | ○ |
| C-19 | キャンセル処理をサポート | E-01 (43-48行目) | ○ |
| C-20 | 統計表示オプションをサポート | E-01 (90-95行目) | ○ |
| C-21 | ワークスペース診断を出力 | E-01 (80-86行目) | ○ |
| C-22 | ProfileOptimizationをサポート | E-01 (52-56行目, 73-76行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csの処理フローが設計書と一致するか確認
- [ ] DiagnosticAnalyzerRunner.csの主要メソッドが正しく記述されているか確認
- [ ] コマンドラインオプション一覧が最新のOptions.csと一致するか確認
