---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：118-BuildBoss

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Tools/BuildBoss/Program.cs` (15-168行目)
- E-02: `src/Tools/BuildBoss/SolutionCheckerUtil.cs` (14-167行目)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (118行目)
- E-04: `src/Tools/BuildBoss/` ディレクトリ内ファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドラインツールとして動作 | E-01 (18行目: Main) | ○ |
| C-02 | MSBuildLocator.RegisterDefaultsを使用 | E-01 (34行目) | ○ |
| C-03 | Mono.Options.OptionSetでオプション解析 | E-01 (41-46行目) | ○ |
| C-04 | Debug/Release構成オプションをサポート | E-01 (44行目, 48-52行目) | ○ |
| C-05 | global.jsonでリポジトリルートを検出 | E-01 (85-94行目: FindRepositoryRoot) | ○ |
| C-06 | ProcessSolutionでソリューション検証 | E-01 (136-140行目) | ○ |
| C-07 | ProcessTargetsでターゲット検証 | E-01 (142-147行目) | ○ |
| C-08 | ProcessPackagesでパッケージ検証 | E-01 (156-160行目) | ○ |
| C-09 | ProcessStructuredLogで構造化ログ検証 | E-01 (149-154行目) | ○ |
| C-10 | ProcessOptProfでOptProf検証 | E-01 (162-166行目) | ○ |
| C-11 | CheckCoreで検証ユーティリティ実行 | E-01 (119-134行目) | ○ |
| C-12 | SolutionCheckerUtilでソリューション検証 | E-02 (14行目: class) | ○ |
| C-13 | CheckDuplicateで重複プロジェクト検出 | E-02 (79-104行目) | ○ |
| C-14 | CheckProjectsでプロジェクト検証 | E-02 (51-77行目) | ○ |
| C-15 | CheckProjectSystemGuidでGUID検証 | E-02 (109-136行目) | ○ |
| C-16 | CheckSameDirectoryで同一ディレクトリ検証 | E-02 (144-165行目) | ○ |
| C-17 | .shprojは同一ディレクトリチェックから除外 | E-02 (150-153行目) | ○ |
| C-18 | 成功時は0、失敗時は1を返す | E-01 (22行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csの処理フローが設計書と一致するか確認
- [ ] SolutionCheckerUtil.csの検証ロジックが正しく記述されているか確認
- [ ] 各CheckerUtilが正しくリストされているか確認
