---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-BuildValidator

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Tools/BuildValidator/Program.cs` (19-403行目)
- E-02: `src/Tools/BuildValidator/CompilationDiff.cs` (21-452行目)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` (119行目)
- E-04: `src/Tools/BuildValidator/` ディレクトリ内ファイル一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | System.CommandLineでオプション定義 | E-01 (35-83行目) | ○ |
| C-02 | --assembliesPathが必須オプション | E-01 (35-40行目: Required = true) | ○ |
| C-03 | --sourcePathが必須オプション | E-01 (46-50行目: Required = true) | ○ |
| C-04 | runtimes/, .resources.dllをデフォルト除外 | E-01 (108-110行目) | ○ |
| C-05 | GetAssemblyInfosでアセンブリ列挙 | E-01 (178-233行目) | ○ |
| C-06 | ReadyToRunアセンブリをスキップ | E-01 (200-204行目) | ○ |
| C-07 | 参照アセンブリをスキップ | E-01 (206-210行目) | ○ |
| C-08 | 重複MVIDをスキップ | E-01 (212-219行目) | ○ |
| C-09 | ValidateFilesで検証とサマリー | E-01 (235-306行目) | ○ |
| C-10 | ValidateFileで個別検証 | E-01 (308-361行目) | ○ |
| C-11 | PEReader.TryOpenAssociatedPortablePdbを使用 | E-01 (318-322行目) | ○ |
| C-12 | CompilationOptionsReaderでオプション抽出 | E-01 (333行目) | ○ |
| C-13 | ResolveSourceLinksでソースリンク解決 | E-01 (339行目, 363-401行目) | ○ |
| C-14 | CompilationDiff.Createで差分生成 | E-01 (350-354行目) | ○ |
| C-15 | RebuildResult enumで結果種別定義 | E-02 (22-29行目) | ○ |
| C-16 | BuildInfo recordでビルド情報管理 | E-02 (33-39行目) | ○ |
| C-17 | byte[].SequenceEqualで比較 | E-02 (159行目) | ○ |
| C-18 | WriteArtifactsでデバッグ出力 | E-02 (199-410行目) | ○ |
| C-19 | SearchForKnownIssuesで既知問題検出 | E-02 (416-449行目) | ○ |
| C-20 | PDB圧縮差異を既知問題として検出 | E-02 (420-449行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全項目がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csの処理フローが設計書と一致するか確認
- [ ] CompilationDiff.csの比較ロジックが正しく記述されているか確認
- [ ] RebuildResult列挙型の値が設計書と一致するか確認
