---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-定義へ移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Features/Core/Portable/GoToDefinition/IGoToDefinitionSymbolService.cs` - サービスインターフェース定義
- E-02: `src/Features/Core/Portable/GoToDefinition/AbstractGoToDefinitionSymbolService.cs` - 抽象基底クラス実装
- E-03: `src/Features/Core/Portable/GoToDefinition/GoToDefinitionFeatureHelpers.cs` - ヘルパー関数
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetSymbolProjectAndBoundSpanAsyncでシンボルを取得 | E-01 (14-15行目) | ○ |
| C-02 | GetTargetIfControlFlowAsyncで制御フロー処理 | E-01 (21-22行目) | ○ |
| C-03 | SymbolFinder.GetSemanticInfoAtPositionAsyncでセマンティック情報取得 | E-02 (28行目) | ○ |
| C-04 | エイリアス→参照→宣言→型の優先順位 | E-02 (34-37行目) | ○ |
| C-05 | ISymbolMappingServiceでシンボルマッピング | E-02 (50-51行目) | ○ |
| C-06 | FindRelatedExplicitlyDeclaredSymbolAsyncで明示的宣言を検索 | E-02 (60行目) | ○ |
| C-07 | GetTargetPositionIfControlFlowで制御フロー位置を取得 | E-02 (75行目) | ○ |
| C-08 | TryGetPreferredSymbolAsyncで優先シンボル取得 | E-03 (18-50行目) | ○ |
| C-09 | グローバル名前空間エイリアスはnullを返す | E-03 (29-31行目) | ○ |
| C-10 | ソース位置がない場合はエイリアスターゲットを使用 | E-03 (37-43行目) | ○ |
| C-11 | SymbolFinder.FindSourceDefinitionAsyncでソース定義検索 | E-03 (46行目) | ○ |
| C-12 | GetDefinitionsAsyncで定義アイテムリスト生成 | E-03 (52-98行目) | ○ |
| C-13 | ToNonClassifiedDefinitionItemAsyncでDefinitionItem生成 | E-03 (83-84行目) | ○ |
| C-14 | IExternalDefinitionItemProviderでサードパーティ拡張 | E-03 (88-94行目) | ○ |
| C-15 | thirdPartyNavigationAllowedでサードパーティナビゲーション制御 | E-03 (86行目) | ○ |
| C-16 | 参照と定義が同じ位置の場合、参照を優先 | E-02 (30-33行目コメント) | ○ |
| C-17 | ISyntaxFactsService.IsBindableTokenでトークン判定 | E-02 (70行目) | ○ |
| C-18 | GetTouchingTokenAsyncでトークン取得 | E-02 (69-70行目) | ○ |
| C-19 | NavigableItemFactory.GetPreferredSourceLocationsで位置取得 | E-03 (39-40行目) | ○ |
| C-20 | ignoreAssemblyKey: trueでアセンブリキー無視 | E-03 (46行目 FindSourceDefinition内部) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり
- 0: 低リスク - インターフェースと実装の対応が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 制御フローキーワードの対応が言語固有実装と一致しているか確認
- [ ] サードパーティ拡張の動作がXAML等で正しく機能するか確認
- [ ] エイリアス解決のロジックがVBグローバルインポートで正しく動作するか確認
