---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 3
  claims_without_evidence: 9
confidence_derived: 0.25
---

# 根拠レポート：120-dotnet-format

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.25**
  - 根拠あり：3 / 12、根拠なし：9
- 優先レビュー（高）
  1. **ソースファイルの所在**：src/Tools/dotnet-format/にファイルが見つからない
  2. **実装詳細**：ほぼすべての実装主張に根拠がない
  3. **参照先の確認**：別リポジトリの可能性を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `docs/code-to-docs/機能一覧/機能一覧.csv` (120行目)
- E-02: Glob検索結果（src/Tools/dotnet-format/**/*.cs = No files found）
- E-03: 一般的なdotnet-formatの知識（公式ドキュメント等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | src/Tools/dotnet-formatにコードがある | E-02 **ファイルなし** | △ |
| C-02 | EditorConfigに基づくフォーマット | E-03（一般知識） | ○ |
| C-03 | --no-restoreオプションをサポート | **根拠なし** | △ |
| C-04 | --verify-no-changesオプションをサポート | E-03（一般知識） | ○ |
| C-05 | --includeオプションをサポート | **根拠なし** | △ |
| C-06 | --excludeオプションをサポート | **根拠なし** | △ |
| C-07 | --severityオプションをサポート | **根拠なし** | △ |
| C-08 | --diagnosticsオプションをサポート | **根拠なし** | △ |
| C-09 | MSBuildWorkspaceを使用 | **根拠なし（推測）** | △ |
| C-10 | Formatter APIを使用 | **根拠なし（推測）** | △ |
| C-11 | .NET SDK 6.0以降に組み込み | E-03（一般知識） | ○ |
| C-12 | CIモードでファイル変更せずエラー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- src/Tools/dotnet-formatディレクトリ内のソースファイル
  - 候補：別リポジトリ（dotnet/format） / 別のディレクトリ配置 / サブモジュール
- 実際のコマンドラインオプション仕様
  - 候補：dotnet format --help / 公式ドキュメント
- 内部実装の詳細
  - 候補：dotnet/format GitHubリポジトリ

## 5) リスクフラグ（レビュー観点）
- 2（高リスク）：指定されたディレクトリにソースファイルが見つからない
- 機能一覧.csvの参照先パスが不正確な可能性がある
- 設計書の内容は一般知識と推測に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] src/Tools/dotnet-formatディレクトリの実際の内容を確認
- [ ] dotnet-formatの正しいソースコード所在を特定
- [ ] 機能一覧.csvの参照先パスを修正する必要があるか判断
- [ ] 別リポジトリ（dotnet/format）との関係を確認
- [ ] 設計書の内容を実際のソースコードと照合して修正
