---
generated_at: 2026-02-10 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：121-IDEベンチマーク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **CI/CDパイプライン統合**：運用ドキュメントの確認が必要
  2. **パフォーマンス基準値**：実際の計測データの確認が必要
  3. **本番環境での使用制限**：運用ルールの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Tools/IdeBenchmarks/Program.cs`
- E-02: `src/Tools/IdeBenchmarks/FormatterBenchmarks.cs`
- E-03: `src/Tools/IdeBenchmarks/SQLitePersistentStorageBenchmark.cs`
- E-04: `src/Tools/IdeBenchmarks/RegexClassifierBenchmarks.cs`
- E-05: `src/Tools/IdeBenchmarks/MemoryDiagnoserConfig.cs`
- E-06: `src/Tools/IdeBenchmarks/Lsp/LspCompletionBenchmarks.cs`
- E-07: `src/Tools/IdeBenchmarks/InheritanceMargin/InheritanceMarginServiceBenchmarks.cs`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BenchmarkDotNetフレームワークを使用している | E-01, E-02 | ○ |
| C-02 | 環境変数ROSLYN_SOURCE_ROOT_PATHを設定する | E-01 (18行目) | ○ |
| C-03 | DEBUGビルドでDebugInProcessConfigを使用 | E-01 (28-31行目) | ○ |
| C-04 | FormatterBenchmarksで5種類のドキュメントを計測 | E-02 (21-26行目) | ○ |
| C-05 | C#とVB両方のフォーマット性能を計測 | E-02 (38-61行目) | ○ |
| C-06 | SQLitePersistentStorageBenchmarkで読み書き比率を設定可能 | E-03 (26-27行目) | ○ |
| C-07 | 並列読み書きパフォーマンスを計測 | E-03 (96-124行目) | ○ |
| C-08 | RegexClassifierで正規表現分類器の性能を計測 | E-04 (39-51行目) | ○ |
| C-09 | MemoryDiagnoserでメモリ使用量を計測 | E-05 (14-17行目), E-06 (17行目) | ○ |
| C-10 | LSP補完機能のベンチマークを提供 | E-06 (18-118行目) | ○ |
| C-11 | 継承マージン機能のベンチマークを提供 | E-07 (20-66行目) | ○ |
| C-12 | UseExportProviderAttributeでMEF初期化を行う | E-02 (19行目), E-03 (23行目) | ○ |
| C-13 | IterationSetup/Cleanupパターンを使用 | E-02 (29-35行目), E-04 (31-37行目) | ○ |
| C-14 | GcServer(true)属性でサーバーGCモードを使用 | E-02 (16行目) | ○ |
| C-15 | 画面No.55「ステータスインジケーター」が関連画面 | E-08 (66行目) | ○ |
| C-16 | TestWorkspaceを使用してワークスペースを構築 | E-02 (43行目), E-03 (54-61行目) | ○ |
| C-17 | MSBuildWorkspaceでソリューションを開く | E-07 (47-48行目) | ○ |
| C-18 | CI/CDパイプラインに組み込んでリグレッション検出を自動化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：CI/CDパイプライン統合に関する具体的な設定ファイルやドキュメントが確認できない
  - 候補：azure-pipelines.yml / .github/workflows / DevOpsドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術的な記述は正確
- 1: 中リスク - CI/CD統合に関する記述は運用レベルの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BenchmarkDotNet関連の記述がソースコードと一致しているか
- [ ] 各ベンチマーククラスの説明が実際の実装と一致しているか
- [ ] 関連画面（ステータスインジケーター）との関係が正確か
- [ ] CI/CDパイプライン統合の記述について運用チームに確認
